/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jidesoft.grid.TableUtils;
import com.jidesoft.icons.IconsFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.broadinstitute.genee.category.MetadataPopup;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.table.HeatMapColumnTable;
import org.broadinstitute.genee.table.IconAdapter;
import org.broadinstitute.genee.table.JideLabelTableCellRenderer;
import org.broadinstitute.genee.table.SortingHelper;

public abstract class MetadataVerticalTableHeader
extends JTable {
    private int columnWidth = -1;
    private HeatMapPanel heatMapPanel;
    private MetadataModel metadataModel;
    private Action[] popupActions;
    private JPopupMenu popupMenu;
    private Project project;
    private ProjectListener projectListener;

    public MetadataVerticalTableHeader(HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        this.setFillsViewportHeight(true);
        this.popupMenu = new JPopupMenu();
        this.setModel(new AbstractTableModel(){

            public Class<String> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return MetadataVerticalTableHeader.this.metadataModel != null ? MetadataVerticalTableHeader.this.metadataModel.getMetadataCount() : 0;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return MetadataVerticalTableHeader.this.metadataModel.getColumnName(columnIndex);
            }
        });
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                Dataset dataset = MetadataVerticalTableHeader.this.project.getSortedFilteredDataset();
                MetadataVerticalTableHeader.this.metadataModel = MetadataVerticalTableHeader.this.getMetadataModel(dataset);
                MetadataVerticalTableHeader.this.setVisible(MetadataVerticalTableHeader.this.metadataModel.getMetadataCount() > 0);
                ((AbstractTableModel)MetadataVerticalTableHeader.this.getModel()).fireTableStructureChanged();
                MetadataVerticalTableHeader.this.revalidate();
                MetadataVerticalTableHeader.this.repaint();
            }
        };
        JideLabelTableCellRenderer renderer = new JideLabelTableCellRenderer();
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.setAutoResizeMode(0);
        renderer.setOrientation(1);
        renderer.setClockwise(false);
        this.setDefaultRenderer(String.class, renderer);
        this.setGridColor(UIUtil.LIGHT_BLUE);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setMinimumSize(new Dimension());
        this.setIntercellSpacing(new Dimension());
        this.setBackground(Color.WHITE);
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProjectSortKey sortKey;
                if (e.isPopupTrigger()) {
                    return;
                }
                int columnIndex = MetadataVerticalTableHeader.this.columnAtPoint(e.getPoint());
                if (columnIndex < 0) {
                    return;
                }
                int rowIndex = MetadataVerticalTableHeader.this.rowAtPoint(e.getPoint());
                if (rowIndex < 0) {
                    return;
                }
                Rectangle rect = MetadataVerticalTableHeader.this.getCellRect(rowIndex, columnIndex, true);
                if ((double)e.getY() < rect.getHeight() - 8.0) {
                    return;
                }
                boolean additionalSort = e.isShiftDown();
                boolean isAltDown = e.isAltDown();
                List<? extends ProjectSortKey> sortKeys = MetadataVerticalTableHeader.this.project.getRowSortKeys();
                int sortKeyIndex = sortKeys.indexOf(new SortKeys.VectorSortKey(MetadataVerticalTableHeader.this.metadataModel.get(columnIndex).getName(), SortOrder.ASCENDING, true));
                ProjectSortKey[] groupByKeys = MetadataVerticalTableHeader.this.project.getRowGroupBy();
                if (sortKeyIndex != -1) {
                    sortKey = sortKeys.get(sortKeyIndex);
                    SortOrder sortOrder = SortingHelper.toggleSortOrder(sortKey);
                    sortKey.setSortOrder(sortOrder);
                } else {
                    sortKey = new SortKeys.VectorSortKey(MetadataVerticalTableHeader.this.metadataModel.get(columnIndex).getName(), SortOrder.ASCENDING, true);
                }
                if (isAltDown) {
                    groupByKeys = new ProjectSortKey[]{sortKey};
                }
                SortingHelper.setSortOrder(MetadataVerticalTableHeader.this.project, sortKey, additionalSort, true, groupByKeys);
            }
        };
        this.addMouseListener(l);
    }

    @Override
    public void addColumn(TableColumn c) {
        super.addColumn(c);
        if (this.columnWidth != -1) {
            this.setColumnSize(c.getModelIndex(), this.columnWidth);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
        this.setProject(this.project);
    }

    public MetadataModel getMetadata() {
        return this.metadataModel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int column = this.columnAtPoint(e.getPoint());
        return column == -1 ? null : this.metadataModel.getColumnName(column);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        int sortIndex;
        if (column >= this.getColumnCount()) {
            return null;
        }
        Component c = super.prepareRenderer(renderer, row, column);
        JLabel label = (JLabel)c;
        label.setToolTipText(this.metadataModel.getColumnName(column));
        List<ProjectSortKey> sortKeys = this.project.getRowSortKeys();
        if (sortKeys == null) {
            sortKeys = Collections.emptyList();
        }
        ProjectSortKey sortKey = (sortIndex = sortKeys.indexOf(new SortKeys.VectorSortKey(this.metadataModel.get(column).getName(), SortOrder.UNSORTED, true))) != -1 ? sortKeys.get(sortIndex) : new SortKeys.VectorSortKey(this.metadataModel.get(column).getName(), SortOrder.UNSORTED, true);
        Icon icon = SortingHelper.getIcon(this.project.getRowSortKeys(), sortKey);
        int columnWidth = this.getColumnModel().getColumn(column).getWidth();
        if (icon != null) {
            if (icon.getIconHeight() > columnWidth) {
                ImageIcon imageIcon = null;
                imageIcon = icon instanceof ImageIcon ? (ImageIcon)icon : new ImageIcon(((ImageIcon)((IconAdapter)icon).getIcon()).getImage());
                icon = IconsFactory.getScaledImage((Component)label, (ImageIcon)imageIcon, (int)columnWidth, (int)icon.getIconHeight());
            }
            icon = IconsFactory.createRotatedImage((Component)label, (Icon)icon, (double)90.0);
        }
        label.setIcon(icon);
        float fontSize = Math.min(columnWidth - 1, 16);
        if (fontSize < 6.0f) {
            fontSize = 6.0f;
        }
        int fontStyle = 0;
        c.setFont(this.getFont().deriveFont(fontStyle, fontSize));
        return c;
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.removeAll();
            int column = this.columnAtPoint(e.getPoint());
            if (column >= 0) {
                new MetadataPopup(this.heatMapPanel, this.project, this.metadataModel, this.metadataModel.get(column), this.popupMenu, true, this.getMoveMode(), this.getPropertyKey());
                if (this.popupActions != null) {
                    this.popupMenu.addSeparator();
                    for (Action action : this.popupActions) {
                        if (action == null) {
                            this.popupMenu.addSeparator();
                            continue;
                        }
                        this.popupMenu.add(action);
                    }
                }
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    public void setColumnWidth(int width) {
        this.columnWidth = width;
        int cc = this.getColumnCount();
        for (int j = 0; j < cc; ++j) {
            this.setColumnSize(j, width);
        }
        HeatMapColumnTable.sizeTableRowHeight(this);
        this.revalidate();
        this.repaint();
    }

    public void setPopupActions(Action[] popupActions) {
        this.popupActions = popupActions;
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
            this.projectListener.projectChanged(null);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        String tablePref = TableUtils.getTablePreferenceByName((JTable)this);
        super.tableChanged(e);
        if (this.defaultRenderersByColumnClass != null) {
            HeatMapColumnTable.sizeTableRowHeight(this);
        }
        TableUtils.setTablePreferenceByName((JTable)this, (String)tablePref);
    }

    @Override
    protected void configureEnclosingScrollPane() {
    }

    protected abstract MetadataModel getMetadataModel(Dataset var1);

    protected abstract MetadataPopup.MOVE_MODE getMoveMode();

    protected abstract Object getPropertyKey();

    private void setColumnSize(int j, int columnSize) {
        TableColumn c = this.getColumnModel().getColumn(j);
        c.setResizable(false);
        c.setMinWidth(columnSize);
        c.setMaxWidth(columnSize);
        c.setPreferredWidth(columnSize);
        c.setWidth(columnSize);
    }
}

