/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class NewSetInputDialog {
    private EditColorButton editColorButton;
    private JRadioButton existingGroupButton;
    private JLabel existingGroupLabel;
    private JComboBox groupComboBox;
    private JTextField setNameTextField;
    private JRadioButton newVector;
    private JLabel newGroupLabel;
    private JTextField newMetadataNameTextField;

    public NewSetInputDialog(Project project, int[] indices, boolean row, String defaultSetName, Callable<?> callable) {
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Name:");
        this.setNameTextField = new JTextField(14);
        this.setNameTextField.setText(defaultSetName);
        formBuilder.add(this.setNameTextField);
        formBuilder.nextRow();
        int totalCategories = 0;
        MetadataModel metadata = row ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
        MetadataModel categorySortedFilteredMetadata = MetadataUtil.getCategoryColumns(row ? project.getSortedFilteredDataset().getRowMetadata() : project.getSortedFilteredDataset().getColumnMetadata());
        int size = categorySortedFilteredMetadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            totalCategories += VectorUtil.getValues(categorySortedFilteredMetadata.get(i)).size();
        }
        this.editColorButton = new EditColorButton(totalCategories > 9 ? QualitativeColorSchemes.TWENTY_COLORS[totalCategories % QualitativeColorSchemes.TWENTY_COLORS.length] : QualitativeColorSchemes.TEN_COLORS[totalCategories % QualitativeColorSchemes.TEN_COLORS.length]);
        formBuilder.addLabel("Color:");
        formBuilder.add(this.editColorButton);
        formBuilder.nextRow();
        if (categorySortedFilteredMetadata.getMetadataCount() > 0) {
            formBuilder.addLabel("Add set to:");
            ButtonGroupHelper bg = new ButtonGroupHelper();
            this.existingGroupButton = bg.createRadioButton("Existing Annotation", true);
            this.newVector = bg.createRadioButton("New Annotation");
            formBuilder.add(this.existingGroupButton);
            formBuilder.nextSmallRow();
            formBuilder.add(this.newVector);
            formBuilder.nextRow();
            this.existingGroupLabel = formBuilder.addLabel("Annotation:");
            this.groupComboBox = UIUtil.createComboBox();
            int size2 = categorySortedFilteredMetadata.getMetadataCount();
            for (int i = 0; i < size2; ++i) {
                this.groupComboBox.addItem(categorySortedFilteredMetadata.get(i).getName());
            }
            formBuilder.add(this.groupComboBox);
            this.groupComboBox.setSelectedIndex(this.groupComboBox.getItemCount() - 1);
            formBuilder.nextRow();
            bg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean existing = NewSetInputDialog.this.existingGroupButton.isSelected();
                    NewSetInputDialog.this.existingGroupLabel.setVisible(existing);
                    NewSetInputDialog.this.groupComboBox.setVisible(existing);
                    NewSetInputDialog.this.newGroupLabel.setVisible(!existing);
                    NewSetInputDialog.this.newMetadataNameTextField.setVisible(!existing);
                }
            });
        }
        this.newGroupLabel = formBuilder.addLabel("Annotation name:");
        this.newMetadataNameTextField = new JTextField(14);
        this.newMetadataNameTextField.setText("Annotation " + (categorySortedFilteredMetadata.getMetadataCount() + 1));
        formBuilder.add(this.newMetadataNameTextField);
        if (categorySortedFilteredMetadata.getMetadataCount() > 0) {
            this.newGroupLabel.setVisible(false);
            this.newMetadataNameTextField.setVisible(false);
        }
        if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), formBuilder.getPanel(), "")) {
            int columnIndex;
            Object value = this.setNameTextField.getText().trim();
            String metadataColumnName = null;
            if (this.newVector == null || this.newVector.isSelected()) {
                metadataColumnName = this.newMetadataNameTextField.getText().trim();
                MetadataUtil.addColumnVector(metadata, metadataColumnName, String.class);
                columnIndex = metadata.getColumnIndex(metadataColumnName);
                int length = indices.length;
                for (int i = 0; i < length; ++i) {
                    metadata.setValue(indices[i], columnIndex, value);
                }
            } else {
                metadataColumnName = (String)this.groupComboBox.getSelectedItem();
                columnIndex = metadata.getColumnIndex(metadataColumnName);
                boolean isNumber = Number.class.isAssignableFrom(metadata.get(columnIndex).getColumnClass());
                if (isNumber) {
                    try {
                        value = Float.valueOf(ParserHelper.parseFloatNaN((String)value));
                    }
                    catch (NumberFormatException nfe) {
                        UIUtil.showErrorDialog(this.editColorButton, nfe.getMessage());
                        throw new RuntimeException();
                    }
                }
                int length = indices.length;
                for (int i = 0; i < length; ++i) {
                    metadata.setValue(indices[i], columnIndex, value);
                }
            }
            Vector vector = metadata.get(metadata.getColumnIndex(metadataColumnName));
            if (row) {
                project.getRowColorModel().setMappedValue(vector, value, this.editColorButton.getColor());
                project.fireRowMetadataChanged();
            } else {
                project.getColumnColorModel().setMappedValue(vector, value, this.editColorButton.getColor());
                project.fireColumnMetadataChanged();
            }
            try {
                callable.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

