/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jidesoft.swing.JideComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.OpenPlateFilesWizard;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.matrix.plate.AnalystReader;
import org.broadinstitute.genee.io.matrix.plate.EnVisionTxtReader;
import org.broadinstitute.genee.io.matrix.plate.SpectraMaxReader;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class OpenPlateFiles {
    public OpenPlateFiles(String[] plateFiles, final String fileFormat) {
        final OpenPlateFilesWizard wizard = new OpenPlateFilesWizard(fileFormat, plateFiles);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OpenPlateFilesTask(wizard, fileFormat).execute();
            }
        };
        wizard.showGui(l);
    }

    private static class OpenPlateFilesTask
    extends BackgroundTask<ProjectGENEEResultTreeNode> {
        private String fileFormat;
        private OpenPlateFilesWizard wizard;
        private PlateHeatMapDisplay display;
        private String[] files;

        public OpenPlateFilesTask(OpenPlateFilesWizard wizard, String format) {
            super("Import Files");
            this.wizard = wizard;
            this.display = wizard.getDisplay();
            this.files = wizard.getPlateFiles();
            this.fileFormat = format;
        }

        @Override
        protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
            Dataset dataset = this.createDataset();
            MetadataUtil.setColumnMetadataVisibility(dataset.getColumnMetadata());
            MetadataUtil.setRowMetadataVisibility(dataset.getRowMetadata());
            MetadataUtil.maybeConvertMetadataClass(dataset, true);
            History map = new History("Open Files");
            map.add("Files", ToStringUtil.toString(this.files, ", "));
            final JideComboBox viewButton = new JideComboBox((Object[])new String[]{"well contents", "plate columns", "plate rows", "plate format"});
            int selectedDropDownIndex = 0;
            selectedDropDownIndex = this.display == PlateHeatMapDisplay.WELL_CONTENTS ? 0 : (this.display == PlateHeatMapDisplay.PLATE_COLUMN ? 1 : (this.display == PlateHeatMapDisplay.PLATE_ROW ? 2 : 3));
            viewButton.setSelectedIndex(selectedDropDownIndex);
            final DefaultProject project = new DefaultProject(dataset);
            viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (viewButton.getSelectedIndex() == 0) {
                        OpenPlateFilesTask.this.display = PlateHeatMapDisplay.WELL_CONTENTS;
                    } else if (viewButton.getSelectedIndex() == 1) {
                        OpenPlateFilesTask.this.display = PlateHeatMapDisplay.PLATE_COLUMN;
                    } else if (viewButton.getSelectedIndex() == 2) {
                        OpenPlateFilesTask.this.display = PlateHeatMapDisplay.PLATE_ROW;
                    } else if (viewButton.getSelectedIndex() == 3) {
                        OpenPlateFilesTask.this.display = PlateHeatMapDisplay.PLATE_LAYOUT;
                    }
                    try {
                        Dataset dataset = OpenPlateFilesTask.this.createDataset();
                        project.setRowSortOrder(null);
                        project.setDataset(dataset);
                        if (OpenPlateFilesTask.this.display == PlateHeatMapDisplay.PLATE_LAYOUT) {
                            SortKeys.VectorSortKey sortKey = new SortKeys.VectorSortKey("plate", SortOrder.ASCENDING, true);
                            project.setRowSortOrder(Arrays.asList(sortKey));
                            project.setRowGroupBy(new ProjectSortKey[]{sortKey});
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Unable to change view");
                    }
                }
            });
            viewButton.setPrototypeDisplayValue((Object)(viewButton.getItemAt(0) + " "));
            ComponentCustomizer cc = new ComponentCustomizer(){

                @Override
                public void customize(Component c) {
                    HeatMapPanel p = (HeatMapPanel)c;
                    HeatMapToolBar toolBar = p.getToolBar();
                    toolBar.add((Component)viewButton, toolBar.getSearchComponentIndex() - 1);
                    p.getColorScheme().setRelative(false);
                }

                @Override
                public boolean inherits() {
                    return false;
                }
            };
            if (this.display == PlateHeatMapDisplay.PLATE_LAYOUT) {
                SortKeys.VectorSortKey sortKey = new SortKeys.VectorSortKey("plate", SortOrder.ASCENDING, true);
                project.setRowSortOrder(Arrays.asList(sortKey));
                project.setRowGroupBy(new ProjectSortKey[]{sortKey});
            }
            return new ProjectGENEEResultTreeNode((Project)project, map, cc);
        }

        @Override
        protected void succeeded(ProjectGENEEResultTreeNode node) {
            Application.add(new GENEEFolderNode("Import", node.getAuditTrail().last(), node));
        }

        private Dataset createDataset() throws IOException {
            Object reader;
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            if (this.fileFormat.equals("EnVision")) {
                reader = new EnVisionTxtReader();
                for (String file : this.files) {
                    datasets.addAll(((EnVisionTxtReader)reader).read(file));
                }
            } else if (this.fileFormat.equals("Analyst")) {
                reader = new AnalystReader();
                for (String file : this.files) {
                    datasets.addAll(((AnalystReader)reader).read(file));
                }
            } else if (this.fileFormat.equals("SpectraMax")) {
                reader = new SpectraMaxReader();
                for (String file : this.files) {
                    datasets.addAll(((SpectraMaxReader)reader).read(file));
                }
            } else {
                System.err.println("Unknown file format");
            }
            StringBuilder name = new StringBuilder();
            for (int i = 0; i < this.files.length; ++i) {
                if (i > 0) {
                    name.append(", ");
                }
                name.append(new File(this.files[i]).getName());
            }
            if (this.display == PlateHeatMapDisplay.PLATE_COLUMN) {
                return PlateUtil.toPlateColumn(datasets, name.toString());
            }
            if (this.display == PlateHeatMapDisplay.PLATE_ROW) {
                return PlateUtil.toPlateRow(datasets, name.toString());
            }
            if (this.display == PlateHeatMapDisplay.PLATE_LAYOUT) {
                return PlateUtil.toPlateLayout(datasets, name.toString());
            }
            Map<String, AbstractSampleInfoFile> fileToSampleInfo = this.wizard.createFileToSampleInfo();
            return PlateUtil.toWellContents(datasets, fileToSampleInfo, this.wizard.getHeatMapColumns().toArray(new String[0]), this.wizard.getHeatMapRows().toArray(new String[0]), name.toString());
        }
    }

    public static enum PlateHeatMapDisplay {
        PLATE_COLUMN,
        PLATE_LAYOUT,
        PLATE_ROW,
        WELL_CONTENTS;

    }
}

