/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.SeekableLineReader;

public class SeekableLineInputStreamTableModel
extends AbstractTableModel {
    private Map<Integer, String[]> cache;
    private int columns;
    private boolean enableCache = true;
    private String[] lastRow;
    private int lastRowIndex = -1;
    private SeekableLineReader seekableLineInputStream;

    public SeekableLineInputStreamTableModel(String file) {
        try {
            this.seekableLineInputStream = new SeekableLineReader(file);
            this.cache = new LinkedHashMap<Integer, String[]>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, String[]> entry) {
                    return this.size() > 100;
                }
            };
            String tmp = this.seekableLineInputStream.readLine(0);
            this.columns = IOUtil.split(tmp).length;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFile() {
        return this.seekableLineInputStream.getFile();
    }

    public void close() {
        this.cache.clear();
        this.seekableLineInputStream.close();
    }

    @Override
    public Class<?> getColumnClass(int j) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.seekableLineInputStream.getLineCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.lastRowIndex == rowIndex) {
            return this.lastRow[columnIndex];
        }
        String[] line = this.cache.get(rowIndex);
        if (line == null) {
            String s = this.seekableLineInputStream.readLine(rowIndex);
            line = new String[this.columns];
            IOUtil.split(s, line, '\t');
            if (this.enableCache) {
                this.cache.put(rowIndex, line);
            }
            this.lastRowIndex = rowIndex;
            this.lastRow = line;
        }
        return line[columnIndex];
    }

    public void setEnableCache(boolean enableCache) {
        if (!enableCache) {
            this.cache.clear();
        }
        this.enableCache = enableCache;
    }
}

