/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.heatmap.AbstractProjectSortKey;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.marker.permutation.PermutationGenerator;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.bivariate.PearsonCorrelation;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.FloatListAdapter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.TransformedDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class SortKeys {
    private SortKeys() {
    }

    public static class VectorSortKey
    extends AbstractProjectSortKey {
        private String metadataColumnName;
        private boolean rows;
        private Vector vector;

        public VectorSortKey(String metadataColumnName, SortOrder sortOrder, boolean rows) {
            super(sortOrder);
            this.metadataColumnName = metadataColumnName;
            this.rows = rows;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VectorSortKey) {
                VectorSortKey sortKey = (VectorSortKey)obj;
                return this.metadataColumnName.equals(sortKey.metadataColumnName) && this.rows == sortKey.rows;
            }
            return false;
        }

        @Override
        public Comparable<?> getValue(int index) {
            return (Comparable)this.vector.getValue(index);
        }

        public Vector getVector() {
            return this.vector;
        }

        public String getVectorName() {
            return this.metadataColumnName;
        }

        public int hashCode() {
            return this.metadataColumnName.hashCode();
        }

        @Override
        public void init(Project project) {
            super.init(project);
            MetadataModel metadata = this.rows ? project.getOriginalDataset().getRowMetadata() : project.getOriginalDataset().getColumnMetadata();
            int index = metadata.getColumnIndex(this.metadataColumnName);
            if (index == -1) {
                throw new IllegalArgumentException(this.metadataColumnName + " not found in " + (this.rows ? "row" : "column") + " metadata. Names are: " + MetadataUtil.getNames(metadata) + ".");
            }
            this.vector = metadata.get(index);
        }

        public String toString() {
            return this.metadataColumnName;
        }
    }

    public static class WaterFallSortKey
    extends AbstractProjectSortKey {
        public WaterFallSortKey(Project project, SortOrder sortOrder) {
            super(sortOrder);
        }

        @Override
        public Comparable<?> getValue(int index) {
            DatasetColumnView view = new DatasetColumnView(this.dataset);
            view.setIndex(index);
            ComparableFloatListNansAtEnd c = new ComparableFloatListNansAtEnd(view);
            return c;
        }

        public boolean equals(Object obj) {
            return obj instanceof WaterFallSortKey;
        }

        public int hashCode() {
            return 11;
        }

        @Override
        public void init(Project project) {
            super.init(project);
            this.dataset = DatasetUtil.sliceView(this.dataset, project.getModelRowIndices(false, false), null);
        }

        public String toString() {
            return "Waterfall";
        }
    }

    private static class ComparableFloatListNansAtEnd
    extends FloatListAdapter
    implements Comparable<FloatList> {
        public ComparableFloatListNansAtEnd(FloatList list) {
            super(list);
        }

        @Override
        public int compareTo(FloatList o) {
            float nan = Float.NEGATIVE_INFINITY;
            int size = Math.min(this.size(), o.size());
            for (int i = 0; i < size; ++i) {
                int val;
                float f2;
                float f1 = this.getValue(i);
                if (Float.isNaN(f1)) {
                    f1 = nan;
                }
                if (Float.isNaN(f2 = o.getValue(i))) {
                    f2 = nan;
                }
                if ((val = Float.compare(f1, f2)) == 0) continue;
                return val;
            }
            return 0;
        }
    }

    public static class SortByValues
    extends AbstractProjectSortKey {
        private int[] originalRowOrColumnIndices;
        private DatasetRowView rowView;
        private boolean sortRows;
        private FloatListFunction summaryFunction;
        private float threshold;

        public SortByValues(Project project, int originalRowOrColumnIndex, SortOrder sortOrder, boolean sortRows) {
            this(project, new int[]{originalRowOrColumnIndex}, sortOrder, new Mean(), Float.NaN, sortRows);
        }

        public SortByValues(Project project, int[] originalRowOrColumnIndices, SortOrder sortOrder, FloatListFunction summaryFunction, float threshold, boolean sortRows) {
            super(sortOrder);
            this.sortRows = sortRows;
            this.originalRowOrColumnIndices = originalRowOrColumnIndices;
            this.summaryFunction = summaryFunction;
            this.threshold = threshold;
            this.init(project);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SortByValues) {
                SortByValues sortKey = (SortByValues)obj;
                return Arrays.equals(this.originalRowOrColumnIndices, sortKey.originalRowOrColumnIndices);
            }
            return false;
        }

        @Override
        public Comparable<?> getValue(int index) {
            this.rowView.setIndex(index);
            return Float.valueOf(this.summaryFunction.evaluate(this.rowView));
        }

        public int hashCode() {
            return Arrays.hashCode(this.originalRowOrColumnIndices);
        }

        @Override
        public void init(Project project) {
            super.init(project);
            Dataset d = this.sortRows ? this.dataset : DatasetUtil.transposeView(this.dataset);
            this.rowView = new DatasetRowView(Float.isNaN(this.threshold) ? d : new TransformedDataset(d, false, false, false, this.threshold, this.threshold, false));
            this.rowView.setIndices(this.originalRowOrColumnIndices);
        }

        public String toString() {
            if (this.dataset == null) {
                return "";
            }
            Dataset d = this.sortRows ? this.dataset : DatasetUtil.transposeView(this.dataset);
            StringBuilder sb = new StringBuilder();
            int nindices = this.originalRowOrColumnIndices.length;
            int length = this.originalRowOrColumnIndices.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                int index = this.originalRowOrColumnIndices[i];
                if (nindices > 1) {
                    sb.append("[");
                }
                sb.append(ToStringUtil.toString(d.getColumnMetadata(), index));
                if (nindices <= 1) continue;
                sb.append("]");
            }
            return sb.toString();
        }
    }

    public static class SortByInvariantLevelFlips
    extends AbstractProjectSortKey {
        private int numberOfLevels;
        private int[] order;

        public SortByInvariantLevelFlips(int numberOfLevels) {
            super(SortOrder.CUSTOM);
            this.numberOfLevels = numberOfLevels;
        }

        @Override
        public Comparable<?> getValue(int index) {
            return this.order[index];
        }

        @Override
        public void init(Project project) {
            super.init(project);
            PermutationGenerator permutationGenerator = new PermutationGenerator(this.numberOfLevels);
            int[] levels = new int[this.numberOfLevels];
            for (int i = 0; i < levels.length; ++i) {
                levels[i] = i + 1;
            }
            this.order = new int[this.dataset.getRowCount()];
            int rowSortOrderIndex = 0;
            while (permutationGenerator.hasMore()) {
                int i;
                int[] indices = permutationGenerator.getNext();
                int[] values = new int[indices.length];
                for (i = 0; i < indices.length; ++i) {
                    values[i] = levels[indices[i]];
                }
                int rows = this.dataset.getRowCount();
                for (i = 0; i < rows; ++i) {
                    boolean eq = true;
                    int cols = this.dataset.getColumnCount();
                    for (int j = 0; j < cols; ++j) {
                        int rank = (Integer)this.dataset.getObjectValue(i, j, 0);
                        if (rank == values[j]) continue;
                        eq = false;
                        break;
                    }
                    if (!eq) continue;
                    this.order[rowSortOrderIndex++] = i;
                }
            }
        }

        public String toString() {
            return "Invariant Levels";
        }
    }

    public static class SelectedIndicesFirstSortKey
    extends AbstractProjectSortKey {
        private Set<Integer> indices;

        public SelectedIndicesFirstSortKey(Set<Integer> indices) {
            this(indices, SortOrder.CUSTOM);
        }

        public SelectedIndicesFirstSortKey(Set<Integer> indices, SortOrder sortOrder) {
            super(sortOrder);
            this.indices = indices;
        }

        @Override
        public Comparable<?> getValue(int index) {
            return this.indices.contains(index) ? -1 : index;
        }

        public String toString() {
            return "Specified indices 1st";
        }
    }

    public static class FunctionRow
    extends AbstractProjectSortKey {
        private FloatListFunction function;
        private DatasetRowView view;

        public FunctionRow(FloatListFunction function, SortOrder sortOrder) {
            super(sortOrder);
            this.function = function;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionRow) {
                FunctionRow sortKey = (FunctionRow)obj;
                return Objects.equal((Object)this.function.toString(), (Object)sortKey.function.toString());
            }
            return false;
        }

        @Override
        public Comparable<?> getValue(int index) {
            this.view.setIndex(index);
            return Float.valueOf(this.function.evaluate(this.view));
        }

        public int hashCode() {
            return this.function.toString().hashCode();
        }

        @Override
        public void init(Project project) {
            super.init(project);
            this.view = new DatasetRowView(this.dataset);
        }

        public String toString() {
            return this.function != null ? this.function.toString() : "";
        }
    }

    public static class FunctionColumn
    extends AbstractProjectSortKey {
        private FloatListFunction function;
        private DatasetColumnView view;

        public FunctionColumn(FloatListFunction function, SortOrder sortOrder) {
            super(sortOrder);
            this.function = function;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionColumn) {
                FunctionColumn sortKey = (FunctionColumn)obj;
                return this.function.toString().equals(sortKey.function.toString());
            }
            return false;
        }

        @Override
        public Comparable<?> getValue(int index) {
            this.view.setIndex(index);
            return Float.valueOf(this.function.evaluate(this.view));
        }

        public int hashCode() {
            return this.function.toString().hashCode();
        }

        @Override
        public void init(Project project) {
            super.init(project);
            this.view = new DatasetColumnView(this.dataset);
        }

        public String toString() {
            return this.function.toString();
        }
    }

    public static class CustomSortKey
    extends AbstractProjectSortKey {
        private Map<Integer, Integer> map = new HashMap<Integer, Integer>();

        public CustomSortKey(int[] order) {
            this(order, SortOrder.CUSTOM);
        }

        public CustomSortKey(int[] order, SortOrder sortOrder) {
            super(sortOrder);
            int length = order.length;
            for (int i = 0; i < length; ++i) {
                this.map.put(order[i], i);
            }
        }

        @Override
        public Comparable<?> getValue(int index) {
            return this.map.get(index);
        }

        public String toString() {
            return "Custom";
        }
    }

    public static class CorrelationSortKey
    extends AbstractProjectSortKey {
        private PearsonCorrelation correlation = new PearsonCorrelation();
        private DatasetRowView datasetRowView;
        private FloatList floatList;
        private String metadataColumnName;
        private Vector vector;

        public CorrelationSortKey(String metadataColumnName, SortOrder sortOrder) {
            super(sortOrder);
            this.metadataColumnName = metadataColumnName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CorrelationSortKey) {
                CorrelationSortKey sortKey = (CorrelationSortKey)obj;
                return this.metadataColumnName.equals(sortKey.metadataColumnName);
            }
            return false;
        }

        @Override
        public Comparable<?> getValue(int index) {
            this.datasetRowView.setIndex(index);
            return Float.valueOf(this.correlation.evaluate(this.floatList, this.datasetRowView));
        }

        public String getVectorName() {
            return this.metadataColumnName;
        }

        public int hashCode() {
            return this.metadataColumnName.hashCode();
        }

        @Override
        public void init(Project project) {
            super.init(project);
            MetadataModel metadata = project.getOriginalDataset().getColumnMetadata();
            this.datasetRowView = new DatasetRowView(this.dataset);
            int index = metadata.getColumnIndex(this.metadataColumnName);
            if (index == -1) {
                throw new IllegalArgumentException(this.metadataColumnName + " not found in  column metadata. Names are: " + MetadataUtil.getNames(metadata) + ".");
            }
            this.vector = metadata.get(index);
            this.floatList = VectorUtil.asFloatList(this.vector);
        }

        public String toString() {
            return "Correlation with " + this.metadataColumnName;
        }
    }
}

