/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class ZoomActions {
    public static final KeyStroke ZOOM_IN_COLUMNS_KEY_STROKE = KeyStroke.getKeyStroke(39, UIUtil.getMenuShortcutKeyMask());
    public static final KeyStroke ZOOM_IN_ROWS_KEY_STROKE = KeyStroke.getKeyStroke(40, UIUtil.getMenuShortcutKeyMask());
    public static final KeyStroke ZOOM_OUT_COLUMNS_KEY_STROKE = KeyStroke.getKeyStroke(37, UIUtil.getMenuShortcutKeyMask());
    public static final KeyStroke ZOOM_OUT_ROWS_KEY_STROKE = KeyStroke.getKeyStroke(38, UIUtil.getMenuShortcutKeyMask());

    private ZoomActions() {
    }

    public static class ZoomOutRows
    extends AbstractAction {
        private HeatMapPanel heatMapPanel;

        public ZoomOutRows(HeatMapPanel heatMapPanel) {
            super("Rows");
            this.heatMapPanel = heatMapPanel;
            this.putValue("ShortDescription", "Zoom out rows");
            this.putValue("AcceleratorKey", ZOOM_OUT_ROWS_KEY_STROKE);
            UIUtil.addKeyboardShortcut(heatMapPanel.getRootPane(), this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.heatMapPanel.zoom(false, true, false);
        }
    }

    public static class ZoomOutColumns
    extends AbstractAction {
        private HeatMapPanel heatMapPanel;

        public ZoomOutColumns(HeatMapPanel heatMapPanel) {
            super("Columns");
            this.heatMapPanel = heatMapPanel;
            this.putValue("ShortDescription", "Zoom out columns");
            this.putValue("AcceleratorKey", ZOOM_OUT_COLUMNS_KEY_STROKE);
            UIUtil.addKeyboardShortcut(heatMapPanel.getRootPane(), this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.heatMapPanel.zoom(false, false, true);
        }
    }

    public static class ZoomInRows
    extends AbstractAction {
        private HeatMapPanel heatMapPanel;

        public ZoomInRows(HeatMapPanel heatMapPanel) {
            super("Rows");
            this.heatMapPanel = heatMapPanel;
            this.putValue("ShortDescription", "Zoom in rows");
            this.putValue("AcceleratorKey", ZOOM_IN_ROWS_KEY_STROKE);
            UIUtil.addKeyboardShortcut(heatMapPanel.getRootPane(), this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.heatMapPanel.zoom(true, true, false);
        }
    }

    public static class ZoomInColumns
    extends AbstractAction {
        private HeatMapPanel heatMapPanel;

        public ZoomInColumns(HeatMapPanel heatMapPanel) {
            super("Columns");
            this.heatMapPanel = heatMapPanel;
            this.putValue("ShortDescription", "Zoom in columns");
            this.putValue("AcceleratorKey", ZOOM_IN_COLUMNS_KEY_STROKE);
            UIUtil.addKeyboardShortcut(heatMapPanel.getRootPane(), this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.heatMapPanel.zoom(true, false, true);
        }
    }
}

