/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import org.broadinstitute.genee.application.GENEEWindowMenu;
import org.broadinstitute.genee.application.GeneeExtensionManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.Zoomable;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.menu.EditMenu;
import org.broadinstitute.genee.heatmap.menu.HelpMenu;
import org.broadinstitute.genee.heatmap.menu.ViewMenu;
import org.broadinstitute.genee.heatmap.menu.analysis.ToolsMenu;
import org.broadinstitute.genee.heatmap.menu.file.FileMenu;
import org.broadinstitute.genee.heatmap.visualization.VisualizationMenu;

public class GENEEMenuBar
extends JMenuBar {
    private JPopupMenu rowDendrogramPopupMenu;
    private JPopupMenu columnDendrogramPopupMenu;
    private ViewMenu viewMenu;
    private EditMenu editMenu;
    private VisualizationMenu visualizationMenu;
    protected HeatMapPanel heatMapPanel;
    private GENEEWindowMenu windowMenu;
    private FileMenu fileMenu;
    private AbstractAction columnDendrogramSizeAction;
    private AbstractAction rowDendrogramSizeAction;
    private AbstractAction flipColumnDendrogramAction;
    private AbstractAction flipRowDendrogramAction;

    public GENEEMenuBar(final HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        this.fileMenu = this.createFileMenu();
        this.add(this.fileMenu);
        this.editMenu = new EditMenu(heatMapPanel);
        this.viewMenu = new ViewMenu(heatMapPanel);
        this.add(this.editMenu);
        if (heatMapPanel.getRowDendrogramPanel() != null) {
            this.rowDendrogramPopupMenu = new JPopupMenu();
            this.flipRowDendrogramAction = new AbstractAction("Flip Node"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (heatMapPanel.getRowDendrogramPanel().getSelectedNode() == null) {
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                        return;
                    }
                    heatMapPanel.flipRowDendrogram();
                }
            };
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (heatMapPanel.getRowDendrogramPanel().getSelectedNode() == null) {
                            heatMapPanel.getRowDendrogramPanel().setSelectedNode(e);
                        }
                        boolean enabled = heatMapPanel.getRowDendrogramPanel().getSelectedNode() != null;
                        heatMapPanel.getHeatMapEditorKit().getRowDendrogramBranchColorAction().setEnabled(enabled);
                        GENEEMenuBar.this.flipRowDendrogramAction.setEnabled(enabled);
                        heatMapPanel.getHeatMapEditorKit().getCutRowDendrogramAction().setEnabled(enabled);
                        GENEEMenuBar.this.rowDendrogramPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
            heatMapPanel.getRowDendrogramPanel().addMouseListener(mouseListener);
            this.rowDendrogramSizeAction = new AbstractAction("Width\u2026"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int value;
                    String s = UIUtil.showInputDialog(heatMapPanel, "Dendrogram width", heatMapPanel.getRowDendrogramWidth() + "");
                    if (s != null && (value = Integer.parseInt(s)) > 0) {
                        heatMapPanel.setRowDendrogramWidth(value);
                    }
                }
            };
            this.rowDendrogramPopupMenu.add(this.rowDendrogramSizeAction);
            this.rowDendrogramPopupMenu.addSeparator();
            this.rowDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getRowDendrogramBranchColorAction());
            this.rowDendrogramPopupMenu.add(this.flipRowDendrogramAction);
            this.rowDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getCutRowDendrogramAction());
        }
        if (heatMapPanel.getColumnDendrogramPanel() != null) {
            this.columnDendrogramPopupMenu = new JPopupMenu();
            heatMapPanel.getColumnDendrogramPanel().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (heatMapPanel.getColumnDendrogramPanel().getSelectedNode() == null) {
                            heatMapPanel.getColumnDendrogramPanel().setSelectedNode(e);
                        }
                        boolean enabled = heatMapPanel.getColumnDendrogramPanel().getSelectedNode() != null;
                        heatMapPanel.getHeatMapEditorKit().getColumnDendrogramBranchColorAction().setEnabled(enabled);
                        GENEEMenuBar.this.flipColumnDendrogramAction.setEnabled(enabled);
                        heatMapPanel.getHeatMapEditorKit().getCutColumnDendrogramAction().setEnabled(enabled);
                        GENEEMenuBar.this.columnDendrogramPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.flipColumnDendrogramAction = new AbstractAction("Flip Node"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (heatMapPanel.getColumnDendrogramPanel().getSelectedNode() == null) {
                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Please select a dendrogram node first.");
                        return;
                    }
                    heatMapPanel.flipColumnDendrogram();
                }
            };
            this.columnDendrogramSizeAction = new AbstractAction("Height\u2026"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int value;
                    String height = UIUtil.showInputDialog(heatMapPanel, "Dendrogram height", heatMapPanel.getColumnDendrogramHeight() + "");
                    if (height != null && (value = Integer.parseInt(height)) > 0) {
                        heatMapPanel.setColumnDendrogramHeight(value);
                    }
                }
            };
            this.columnDendrogramPopupMenu.add(this.columnDendrogramSizeAction);
            this.columnDendrogramPopupMenu.addSeparator();
            this.columnDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getColumnDendrogramBranchColorAction());
            this.columnDendrogramPopupMenu.add(this.flipColumnDendrogramAction);
            this.columnDendrogramPopupMenu.add(heatMapPanel.getHeatMapEditorKit().getCutColumnDendrogramAction());
        }
        this.add(this.viewMenu);
        this.visualizationMenu = new VisualizationMenu(heatMapPanel);
        this.add(this.visualizationMenu);
        this.add(this.createToolsMenu());
        this.windowMenu = new GENEEWindowMenu();
        this.add(this.windowMenu);
        this.add(new HelpMenu(heatMapPanel));
        this.setZoomable(heatMapPanel);
        GeneeExtensionManager.getInstance().install(this, heatMapPanel.getToolBar());
    }

    public void rebuild() {
        this.windowMenu.rebuild();
    }

    protected FileMenu createFileMenu() {
        return new FileMenu(this.heatMapPanel);
    }

    protected JMenu createToolsMenu() {
        return new ToolsMenu(this.heatMapPanel);
    }

    private void setZoomable(Zoomable zoomable) {
        this.heatMapPanel.getHeatMapEditorKit().getZoomInAction().setEnabled(zoomable != null);
        this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction().setEnabled(zoomable != null);
        this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setEnabled(zoomable != null);
        if (zoomable != null) {
            this.heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setZoomable(zoomable);
            this.heatMapPanel.getHeatMapEditorKit().getZoomInAction().setZoomable(zoomable);
            this.heatMapPanel.getHeatMapEditorKit().getZoomOutAction().setZoomable(zoomable);
        }
    }
}

