/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class MouseModeMenuItems {
    private JCheckBoxMenuItem zoomMode;
    private JCheckBoxMenuItem panMode;
    private JCheckBoxMenuItem magnifyingGlassMode;

    public MouseModeMenuItems(HeatMapPanel heatMapPanel) {
        this.zoomMode = new JCheckBoxMenuItem("Zoom Selection", heatMapPanel.getMouseMode() == HeatMapPanel.MouseMode.DRAG_FISHEYE);
        this.panMode = new JCheckBoxMenuItem("Pan", heatMapPanel.getMouseMode() == HeatMapPanel.MouseMode.DRAG_PAN);
        this.magnifyingGlassMode = new JCheckBoxMenuItem("Magnifying Glass", heatMapPanel.getMouseMode() == HeatMapPanel.MouseMode.MAGNIFYING_GLASS);
        this.zoomMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.panMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.magnifyingGlassMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        heatMapPanel.addPropertyChangeListener("mouseMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MouseModeMenuItems.this.setMouseMode((HeatMapPanel.MouseMode)((Object)evt.getNewValue()));
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.zoomMode);
        bg.add(this.panMode);
        bg.add(this.magnifyingGlassMode);
    }

    public JCheckBoxMenuItem[] getMenuItems() {
        return new JCheckBoxMenuItem[]{this.panMode, this.magnifyingGlassMode, this.zoomMode};
    }

    public void setMouseMode(HeatMapPanel.MouseMode mode) {
        if (mode == HeatMapPanel.MouseMode.DRAG_FISHEYE) {
            this.zoomMode.setSelected(true);
        } else if (mode == HeatMapPanel.MouseMode.DRAG_PAN) {
            this.panMode.setSelected(true);
        } else if (mode == HeatMapPanel.MouseMode.MAGNIFYING_GLASS) {
            this.magnifyingGlassMode.setSelected(true);
        }
    }
}

