/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.HistoryPanel;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.BlockingThread;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.menu.VerticalDrawableArray;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.mac.AppleScript;
import org.jdesktop.swingx.util.OS;

public class SaveImageAction
extends AbstractAction {
    private WeakReference<JComponent> componentWeakRef;
    private GENEEWindow dialog;
    private WeakReference<Drawable> drawableWeakRef;
    private JButton okButton;

    public SaveImageAction() {
        super("Save Image\u2026");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UIUtil.getMenuShortcutKeyMask()));
        this.setEnabled(false);
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/26630.sc_save.png"));
        this.putValue("ShortDescription", "Save Image");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = Application.createDialog("Save Image");
            final JComboBox fileFormat = UIUtil.createComboBox(new String[]{"bmp", "jpeg", "pdf", "png", "tiff"});
            fileFormat.setSelectedItem("pdf");
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.nextRow();
            formBuilder.addLabel("File format:");
            formBuilder.add(fileFormat);
            final JCheckBox tileColumns = new JCheckBox("Tile horizontally", false);
            formBuilder.nextRow();
            formBuilder.add(tileColumns);
            final JCheckBox tileRows = new JCheckBox("Tile vertically", false);
            formBuilder.nextRow();
            formBuilder.add(tileRows);
            fileFormat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tileColumns.setEnabled("pdf".equals(fileFormat.getSelectedItem()));
                    tileRows.setEnabled(tileColumns.isEnabled());
                }
            });
            tileColumns.setEnabled("pdf".equals(fileFormat.getSelectedItem()));
            tileRows.setEnabled(tileColumns.isEnabled());
            final JCheckBox openFile = new JCheckBox("View file after save completes", false);
            formBuilder.nextRow();
            formBuilder.add(openFile);
            final JCheckBox programVersionCheckBox = new JCheckBox("Include program version", false);
            formBuilder.nextRow();
            formBuilder.add(programVersionCheckBox);
            final JCheckBox historyCheckBox = new JCheckBox("Include history", false);
            formBuilder.nextRow();
            formBuilder.add(historyCheckBox);
            formBuilder.nextRow();
            this.okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == SaveImageAction.this.okButton) {
                        TrackerUtil.trackPageView((String)SaveImageAction.this.getValue("Name"));
                        String format = (String)fileFormat.getSelectedItem();
                        boolean buildInfo = programVersionCheckBox.isSelected();
                        boolean history = historyCheckBox.isSelected();
                        boolean spotlight = OS.isMacOSX();
                        boolean open = openFile.isSelected();
                        SaveImageAction.this.dialog.dispose();
                        SaveImageAction.this.showSaveImageDialog(format, buildInfo, history, spotlight, open, tileColumns.isEnabled() && tileColumns.isSelected(), tileRows.isEnabled() && tileRows.isSelected());
                    } else {
                        SaveImageAction.this.dialog.dispose();
                    }
                }
            };
            JPanel okCancelPanel = UIUtil.buildOKCancelBar(this.okButton, cancelButton);
            this.okButton.addActionListener(l);
            cancelButton.addActionListener(l);
            this.dialog.getContentPane().add((Component)formBuilder.getPanel(), "Center");
            this.dialog.getContentPane().add((Component)okCancelPanel, "South");
            this.dialog.pack();
        }
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.setVisible(true);
    }

    public void setDrawable(Drawable drawable) {
        WeakReference<Drawable> weakReference = this.drawableWeakRef = drawable == null ? null : new WeakReference<Drawable>(drawable);
        if (drawable instanceof JComponent) {
            this.setJComponent((JComponent)((Object)drawable));
        }
        this.setEnabled(drawable != null);
    }

    public void setJComponent(JComponent component) {
        WeakReference<JComponent> weakReference = this.componentWeakRef = component == null ? null : new WeakReference<JComponent>(component);
        if (component != null && !GraphicsEnvironment.isHeadless()) {
            KeyStroke ks = KeyStroke.getKeyStroke(83, UIUtil.getMenuShortcutKeyMask());
            component.getInputMap(2).put(ks, this.getValue("Name"));
            component.getActionMap().put(this.getValue("Name"), this);
        }
        this.setEnabled(component != null);
    }

    protected void saveImage(ViewableGENEETreeNode node, File file, String format, boolean buildInfo, boolean includeHistoryInImage, boolean setSpotlighComment, boolean tileColumns, boolean tileRows) throws Exception {
        JComponent c;
        Drawable d = null;
        Drawable drawable = this.drawableWeakRef != null ? (Drawable)this.drawableWeakRef.get() : null;
        JComponent jComponent = c = this.componentWeakRef == null ? null : (JComponent)this.componentWeakRef.get();
        if (drawable != null) {
            d = drawable;
        } else if (c != null) {
            Drawable drawable2 = d = c instanceof Drawable ? (Drawable)((Object)c) : new DrawableWrapper(c);
        }
        if (includeHistoryInImage && node != null) {
            HistoryPanel historyPanel = new HistoryPanel(node, buildInfo, null);
            historyPanel.setBackground(Color.WHITE);
            DrawableWrapper history = includeHistoryInImage ? new DrawableWrapper(historyPanel) : null;
            d = new VerticalDrawableArray(d, history);
        }
        if (tileRows || tileColumns) {
            ImageUtil.saveTiledPdf(d, file, tileColumns, tileRows);
        } else {
            ImageUtil.saveImage(d, format, file, false);
        }
        if (setSpotlighComment) {
            AppleScript.setSpotlightComment(HistoryPanel.toString(node, buildInfo ? Application.getVersion() : null), file);
        }
    }

    private void showSaveImageDialog(final String format, final boolean buildInfo, final boolean includeHistoryInImage, final boolean setSpotlighComment, final boolean open, final boolean tileColumns, final boolean tileRows) {
        final File file = FileChooserUtil.showSaveDialog(UIUtil.getCurrentFrame(), ImageUtil.getExtensions(format), "Save " + format.toUpperCase() + " Image");
        if (file != null) {
            final GENEETreeNode node = Application.getWindowManager().getNode();
            new BlockingThread("Save Image", true){

                @Override
                public void doInBackground() throws Exception {
                    SaveImageAction.this.saveImage(node instanceof ViewableGENEETreeNode ? (ViewableGENEETreeNode)node : null, file, format, buildInfo, includeHistoryInImage, setSpotlighComment, tileColumns, tileRows);
                    if (open) {
                        BrowserLauncher.openFile(file);
                    }
                }
            };
        }
    }
}

