/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.clustering.hierarchical.AbstractDendrogramPanel;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class ScoreDendrogramAction
extends AbstractAction {
    private boolean row;
    private HeatMapPanel heatMapPanel;

    public ScoreDendrogramAction(HeatMapPanel heatMapPanel, boolean row) {
        super("Load " + (row ? "Row Dendrogram" : "Column Dendrogram") + " Node Data" + "\u2026");
        this.heatMapPanel = heatMapPanel;
        this.row = row;
        this.setEnabled(row ? heatMapPanel.getRowDendrogramPanel() != null : heatMapPanel.getColumnDendrogramPanel() != null);
    }

    private void addToMap(Node node, Map<String, Node> map) {
        Node left = node.getLeft();
        Node right = node.getRight();
        String id = node.getId();
        map.put(id, node);
        if (!left.isLeaf()) {
            this.addToMap(left, map);
        }
        if (!right.isLeaf()) {
            this.addToMap(right, map);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final File file = FileChooserUtil.showOpenDialog(UIUtil.getCurrentFrame());
        if (file != null) {
            new BackgroundTask<Void>("Opening " + file.getName()){

                @Override
                protected Void doInBackground() throws Exception {
                    Dendrogram dendrogram;
                    Project p = Application.getProject();
                    Dendrogram dendrogram2 = dendrogram = ScoreDendrogramAction.this.row ? p.getRowDendrogram() : p.getColumnDendrogram();
                    if (dendrogram == null) {
                        throw new NullPointerException("No dendrogram loaded.");
                    }
                    Node[] rootNodesArray = dendrogram.getRootNodes();
                    HashMap map = new HashMap();
                    for (Node node : rootNodesArray) {
                        ScoreDendrogramAction.this.addToMap(node, map);
                    }
                    String[][] data = ((Array2DContentHandler)new ExcelReader(IOUtil.getPath(file), new Array2DContentHandler()).getContentHandler()).getData();
                    int numPoints = data[0].length - 1;
                    HashMap<String, float[]> nodeIdToScores = new HashMap<String, float[]>();
                    int rows = data.length;
                    for (int i = 1; i < rows; ++i) {
                        String nodeId = data[i][0];
                        float[] array = new float[numPoints];
                        for (int j = 0; j < numPoints; ++j) {
                            float score = Float.NaN;
                            try {
                                score = ParserHelper.parseFloat(data[i][j + 1]);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            array[j] = score;
                        }
                        Node node = (Node)map.get(nodeId);
                        if (node == null) continue;
                        nodeIdToScores.put(nodeId, array);
                    }
                    String[] header = data[0];
                    String[] names = new String[header.length - 1];
                    for (int i = 0; i < names.length; ++i) {
                        names[i] = header[i + 1];
                    }
                    if (ScoreDendrogramAction.this.row) {
                        ScoreDendrogramAction.this.heatMapPanel.getRowDendrogramPanel().setNodeIdToScores(false, nodeIdToScores);
                        ScoreDendrogramAction.this.heatMapPanel.getRowDendrogramPanel().setNodeScoreNames(false, names);
                        ScoreDendrogramAction.this.heatMapPanel.getRowDendrogramPanel().setNodeScoreSource(AbstractDendrogramPanel.NodeScoreSource.NODE_SCORE_SOURCE_STATIC);
                        ScoreDendrogramAction.this.heatMapPanel.getRowDendrogramPanel().repaintImage();
                    } else {
                        ScoreDendrogramAction.this.heatMapPanel.getColumnDendrogramPanel().setNodeIdToScores(false, nodeIdToScores);
                        ScoreDendrogramAction.this.heatMapPanel.getColumnDendrogramPanel().setNodeScoreNames(false, names);
                        ScoreDendrogramAction.this.heatMapPanel.getColumnDendrogramPanel().setNodeScoreSource(AbstractDendrogramPanel.NodeScoreSource.NODE_SCORE_SOURCE_STATIC);
                        ScoreDendrogramAction.this.heatMapPanel.getColumnDendrogramPanel().repaintImage();
                    }
                    return null;
                }
            }.execute();
        }
    }
}

