/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import org.broadinstitute.genee.gui.Drawable;

public class VerticalDrawableArray
implements Drawable {
    private Drawable[] array;
    private Dimension[] sizes;
    private Dimension drawableSize;

    public VerticalDrawableArray(Collection<Drawable> drawables) {
        this(drawables.toArray(new Drawable[0]));
    }

    public VerticalDrawableArray(Drawable ... array) {
        int i;
        this.array = array;
        this.drawableSize = new Dimension();
        this.sizes = new Dimension[array.length];
        int length = array.length;
        for (i = 0; i < length; ++i) {
            if (array[i] != null) {
                Dimension size = array[i].getDrawableSize();
                this.drawableSize.width = Math.max(this.drawableSize.width, size.width);
                this.drawableSize.height += size.height;
                this.sizes[i] = size;
                continue;
            }
            this.sizes[i] = new Dimension();
        }
        length = array.length;
        for (i = 0; i < length; ++i) {
            this.sizes[i].width = this.drawableSize.width;
        }
    }

    protected void afterDraw(Graphics g, Rectangle size) {
    }

    protected void beforeDraw(Graphics g, Rectangle size) {
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        this.beforeDraw(g, clip);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform saved = g2.getTransform();
        int ty = 0;
        int length = this.array.length;
        for (int i = 0; i < length; ++i) {
            if (this.array[i] == null) continue;
            g2.setTransform(saved);
            g.translate(0, ty);
            this.array[i].draw(g, new Rectangle(this.sizes[i]));
            ty += this.sizes[i].height;
        }
        g2.setTransform(saved);
        this.afterDraw(g2, clip);
    }

    @Override
    public Dimension getDrawableSize() {
        return this.drawableSize;
    }
}

