/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.ZoomActions;
import org.jdesktop.swingx.util.OS;

public class ViewMenu
extends JMenu {
    public ViewMenu(HeatMapPanel heatMapPanel) {
        super("View");
        if (!OS.isMacOSX() || Application.isStandalone()) {
            this.add(heatMapPanel.getHeatMapEditorKit().getPreferencesAction());
            this.add(new JSeparator());
        }
        JMenu zoomInMenu = new JMenu("Zoom In");
        zoomInMenu.add(heatMapPanel.getHeatMapEditorKit().getZoomInAction());
        zoomInMenu.add(new ZoomActions.ZoomInColumns(heatMapPanel));
        zoomInMenu.add(new ZoomActions.ZoomInRows(heatMapPanel));
        this.add(zoomInMenu);
        JMenu zoomOutMenu = new JMenu("Zoom Out");
        zoomOutMenu.add(heatMapPanel.getHeatMapEditorKit().getZoomOutAction());
        zoomOutMenu.add(new ZoomActions.ZoomOutColumns(heatMapPanel));
        zoomOutMenu.add(new ZoomActions.ZoomOutRows(heatMapPanel));
        this.add(zoomOutMenu);
        if (heatMapPanel.getProject().getOriginalDataset().getRowCount() == 0) {
            UIUtil.setChildrenEnabledRecursively(this, false);
            heatMapPanel.getHeatMapEditorKit().getPreferencesAction().setEnabled(true);
        }
    }
}

