/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.analysis;

import javax.swing.JMenu;
import javax.swing.JSeparator;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.compound.CurveFittingAction;
import org.broadinstitute.genee.compound.painter.ImportImagesAction;
import org.broadinstitute.genee.compound.painter.RenameImageFilesAction;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.CCAlgorithmAction;
import org.broadinstitute.genee.gui.actions.CollapseDatasetAction;
import org.broadinstitute.genee.gui.actions.ConcatenateAction;
import org.broadinstitute.genee.gui.actions.CorrelationAcrossDatasetsAction;
import org.broadinstitute.genee.gui.actions.HypergeometricAction;
import org.broadinstitute.genee.gui.actions.KMeansAction;
import org.broadinstitute.genee.gui.actions.SignatureBrowserAction;
import org.broadinstitute.genee.gui.actions.SynergyAction;
import org.broadinstitute.genee.gui.actions.TransposeAction;
import org.broadinstitute.genee.heatmap.HeatMapEditorKit;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.LinkToAction;
import org.broadinstitute.genee.heatmap.menu.analysis.NearestNeighborsAction;
import org.broadinstitute.genee.luminex.PrismPreprocessAction;
import org.broadinstitute.genee.math.adjust.gui.AdjustDataAlgorithmInput;

public class ToolsMenu
extends JMenu {
    public ToolsMenu(HeatMapPanel heatMapPanel) {
        super("Tools");
        this.add(heatMapPanel.getHeatMapEditorKit().getNewHeatMapAction());
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getFilterRowsAction());
        this.add(new JSeparator());
        this.add(new AdjustDataAlgorithmInput());
        this.add(new JSeparator());
        this.add(new CollapseDatasetAction());
        this.add(new JSeparator());
        this.add(new TransposeAction());
        this.add(new JSeparator());
        if (Application.isDevVersion()) {
            this.add(new SignatureBrowserAction());
        }
        this.add(heatMapPanel.getHeatMapEditorKit().getMarkerSelectionAction());
        this.add(new JSeparator());
        this.add(heatMapPanel.getHeatMapEditorKit().getColumnCorrelationMatrixAction());
        this.add(heatMapPanel.getHeatMapEditorKit().getRowCorrelationMatrixAction());
        this.add(new JSeparator());
        this.add(new NearestNeighborsAction());
        this.add(new CorrelationAcrossDatasetsAction());
        this.add(new JSeparator());
        JMenu clusteringMenu = new JMenu("Clustering");
        clusteringMenu.add(new CCAlgorithmAction());
        clusteringMenu.add(heatMapPanel.getHeatMapEditorKit().getHierarchicalClusteringAction());
        clusteringMenu.add(new KMeansAction());
        this.add(clusteringMenu);
        if (Application.isDevVersion()) {
            this.add(new JSeparator());
            this.add(new HypergeometricAction());
        }
        this.add(new JSeparator());
        HeatMapEditorKit editorKit = heatMapPanel.getHeatMapEditorKit();
        this.add(editorKit.getSortColumnsAction());
        this.add(editorKit.getSortRowsAction());
        if (Application.isDevVersion()) {
            this.add(new JSeparator());
            this.add(new CurveFittingAction());
        }
        if (Application.isDevVersion()) {
            this.add(new JSeparator());
            this.add(new PrismPreprocessAction());
        }
        this.add(new JSeparator());
        this.add(new SynergyAction());
        this.add(new JSeparator());
        this.add(new LinkToAction());
        this.add(new ConcatenateAction(true));
        this.add(new ConcatenateAction(false));
        if (Application.isDevVersion()) {
            this.add(new JSeparator());
            this.add(new ImportImagesAction());
            this.add(new RenameImageFilesAction());
        }
        if (heatMapPanel.getProject().getOriginalDataset().getRowCount() == 0) {
            UIUtil.setChildrenEnabledRecursively(this, false);
        }
    }
}

