/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap.menu.file;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.AbstractAction;
import org.apache.tools.ant.filters.StringInputStream;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.heatmap.menu.file.Importer;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class ImportFromClipboard
extends AbstractAction {
    public ImportFromClipboard() {
        super("Clipboard Data\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView("Import Clipboard Data");
        new BackgroundTask<String[][]>("Import Data"){

            @Override
            protected String[][] doInBackground() throws Exception {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t = clipboard.getContents(this);
                DataFlavor[] flavors = t.getTransferDataFlavors();
                if (flavors == null || flavors.length == 0) {
                    throw new RuntimeException("No parseable data on the clipboard");
                }
                String contents = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (contents == null || contents.length() == 0) {
                    throw new RuntimeException("No data on the clipboard");
                }
                StringInputStream is = new StringInputStream(contents);
                Array2DContentHandler handler = new Array2DContentHandler();
                ExcelReader.parseAsText((InputStream)is, '\t', 0, handler);
                String[][] result = handler.getData();
                if (result == null) {
                    throw new RuntimeException("No parseable data on the clipboard");
                }
                return result;
            }

            @Override
            protected void succeeded(String[][] result) {
                new Importer(new StringTableModel(result), "Clipboard");
            }
        }.execute();
    }
}

