/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io;

import com.google.common.io.Files;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public class LSFUtil {
    private static final int JOB_NAME_INDEX = 6;

    public static void bkill(BJob job) {
        try {
            String id = job.getJobId();
            Process p = new ProcessBuilder("bkill", id).redirectErrorStream(true).start();
            InputStream is = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            try {
                String s;
                while ((s = in.readLine()) != null) {
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe + " while reading from process stream");
            }
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void bsub(Class<?> c, String[] args, String jobName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bsub");
        list.add("-o");
        list.add("/dev/null");
        list.add("-J");
        jobName = jobName.replace(' ', '_');
        list.add(jobName);
        list.add("java");
        list.add("-Djava.library.path=/xchip/cogs/src/cogs/client/lib/native/linux/64");
        list.add("-Djava.awt.headless=true");
        list.add("-Xmx2g");
        list.add("-cp");
        list.add(System.getProperty("java.class.path"));
        list.add(c.getCanonicalName());
        list.addAll(Arrays.asList(args));
        Process p = new ProcessBuilder(list).redirectErrorStream(true).start();
    }

    public static BJob getJob(String jobName) {
        try {
            Process p = new ProcessBuilder("bjobs", "-w").redirectErrorStream(true).start();
            StringBuilder sb = new StringBuilder();
            InputStream is = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            try {
                String s;
                while ((s = in.readLine()) != null) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(s);
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe + " while reading from process stream");
            }
            p.waitFor();
            String text = sb.toString();
            return LSFUtil.getJob(jobName, text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String text = Files.toString((File)new File("/Users/jgould/out.txt"), (Charset)Charset.defaultCharset());
        System.out.println(LSFUtil.getJob("*I52LO.csv", text));
    }

    private static BJob getJob(String jobName, String text) {
        jobName = jobName.trim();
        TIntArrayList whiteSpaceToCharTransitions = new TIntArrayList();
        whiteSpaceToCharTransitions.add(0);
        String[] lines = text.split("\n");
        String header = lines[0];
        boolean inSpace = false;
        int nchars = header.length();
        for (int i = 0; i < nchars; ++i) {
            char c = header.charAt(i);
            if (c == ' ') {
                inSpace = true;
                continue;
            }
            if (inSpace) {
                whiteSpaceToCharTransitions.add(i);
            }
            inSpace = false;
        }
        String[] row = null;
        boolean found = false;
        for (int i = 1; i < lines.length && !found; ++i) {
            row = LSFUtil.split(lines[i], whiteSpaceToCharTransitions);
            String test = row[6].trim();
            if (!jobName.equals(test)) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        BJob job = new BJob();
        job.setJobId(row[0]);
        job.setUser(row[1]);
        job.setStatus(row[2]);
        job.setQueue(row[3]);
        job.setFromHost(row[4]);
        job.setExecHost(row[5]);
        job.setJobName(row[6]);
        job.setSubmitTime(row[7]);
        return job;
    }

    private static String[] split(String line, TIntArrayList list) {
        String[] tokens = new String[list.size()];
        for (int i = 0; i < tokens.length; ++i) {
            String s;
            int pos = list.getQuick(i);
            int pos1 = i + 1 < list.size() ? list.getQuick(i + 1) : line.length();
            tokens[i] = s = line.substring(pos, pos1).trim();
        }
        return tokens;
    }

    public static class BJob {
        private String fromHost;
        private String user;
        private String queue;
        private String jobId;
        private String status;
        private String execHost;
        private String jobName;
        private String submitTime;

        public String getExecHost() {
            return this.execHost;
        }

        public String getFromHost() {
            return this.fromHost;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getStatus() {
            return this.status;
        }

        public String getSubmitTime() {
            return this.submitTime;
        }

        public String getUser() {
            return this.user;
        }

        public void setExecHost(String execHost) {
            this.execHost = execHost;
        }

        public void setFromHost(String fromHost) {
            this.fromHost = fromHost;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setSubmitTime(String submitTime) {
            this.submitTime = submitTime;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String toString() {
            return "BJob [fromHost=" + this.fromHost + ", user=" + this.user + ", queue=" + this.queue + ", jobId=" + this.jobId + ", status=" + this.status + ", execHost=" + this.execHost + ", jobName=" + this.jobName + ", submitTime=" + this.submitTime + "]";
        }
    }
}

