/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.csv;

import au.com.bytecode.opencsv.CSVReader;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class AnnotationFile {
    private Map<String, Integer> rowNameToRowNumber;
    private List<String[]> values;
    private String[] columnNames;
    private List<String> rowNames;
    private String fileName;

    public AnnotationFile(String file) throws IOException {
        this(file, false, null);
    }

    public AnnotationFile(String file, boolean readAllLines, String[] colNames) throws IOException {
        InputStreamReader r;
        this.fileName = IOUtil.getBaseFileName(file);
        if (file.toLowerCase().endsWith("xls")) {
            ExcelReader reader = new ExcelReader(file, new Array2DContentHandler());
            this.init(((Array2DContentHandler)reader.getContentHandler()).getData());
            return;
        }
        if (file.toLowerCase().endsWith(".zip")) {
            ZipInputStream zis = new ZipInputStream(IOUtil.getInputStream(file));
            ZipEntry e = zis.getNextEntry();
            r = new InputStreamReader(zis);
        } else {
            r = new InputStreamReader(IOUtil.getInputStream(file));
        }
        this.init(r, colNames, readAllLines);
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRowCount() {
        return this.values.size();
    }

    public int getRowIndex(String rowName) {
        Integer index = this.rowNameToRowNumber.get(rowName);
        return index != null ? index : -1;
    }

    public String getRowName(int row) {
        return this.rowNames.get(row);
    }

    public String getParameterValue(int row, int column) {
        String[] rowArray = this.values.get(row);
        return column < rowArray.length ? rowArray[column] : null;
    }

    public String getParameterValue(String rowName, int column) {
        if (!this.rowNameToRowNumber.containsKey(rowName)) {
            return null;
        }
        return this.getParameterValue(this.rowNameToRowNumber.get(rowName), column);
    }

    private void init(String[][] data) {
        String[] headerRow = data[0];
        this.columnNames = new String[headerRow.length - 1];
        System.arraycopy(headerRow, 1, this.columnNames, 0, headerRow.length - 1);
        this.rowNameToRowNumber = new HashMap<String, Integer>();
        this.values = new ArrayList<String[]>();
        this.rowNames = new ArrayList<String>();
        int rows = data.length;
        for (int i = 1; i < rows; ++i) {
            String probe = data[i][0];
            String[] row = data[i];
            String[] dest = new String[row.length - 1];
            System.arraycopy(row, 1, dest, 0, row.length - 1);
            data[i] = null;
            this.values.add(dest);
            this.rowNameToRowNumber.put(probe, this.rowNames.size());
            this.rowNames.add(probe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Reader r, String[] colNames, boolean readAllLines) throws IOException {
        int i;
        char delim;
        BufferedReader br = new BufferedReader(r, 0x100000);
        String header = br.readLine();
        while (header.startsWith("#%") || header.startsWith("##")) {
            header = br.readLine();
        }
        int nlines = -1;
        boolean illumina = false;
        int rowNamesColumnIndex = 0;
        if (header.equals("? Illumina, Inc.") || header.startsWith("Illumina")) {
            String s = null;
            illumina = true;
            delim = '\t';
            while (!(s = br.readLine()).equals("[Probes]")) {
                if (!s.startsWith("Number of Probes")) continue;
                nlines = Integer.parseInt(s.split("\t")[1]);
            }
            header = br.readLine();
        } else {
            delim = header.indexOf(9) != -1 ? (char)'\t' : ',';
        }
        String[] headerTokens = header.split("" + delim);
        for (i = 0; i < headerTokens.length; ++i) {
            String col = headerTokens[i];
            if (col.charAt(0) != '\"') continue;
            headerTokens[i] = col.substring(1, col.length() - 1);
        }
        if (illumina) {
            for (i = 0; i < headerTokens.length; ++i) {
                if (!headerTokens[i].equals("Search_Key")) continue;
                rowNamesColumnIndex = i;
                break;
            }
        }
        LinkedHashMap<String, Integer> allDataColumnNamesToIdx = new LinkedHashMap<String, Integer>();
        int[] dataColumnIndices = null;
        for (int i2 = 0; i2 < headerTokens.length; ++i2) {
            if (i2 == rowNamesColumnIndex) continue;
            allDataColumnNamesToIdx.put(headerTokens[i2], i2);
        }
        if (colNames != null) {
            TIntArrayList tmpIndices = new TIntArrayList();
            for (String col : colNames) {
                if (!allDataColumnNamesToIdx.containsKey(col)) continue;
                tmpIndices.add(((Integer)allDataColumnNamesToIdx.get(col)).intValue());
            }
            dataColumnIndices = tmpIndices.toArray();
        } else {
            dataColumnIndices = new int[allDataColumnNamesToIdx.size()];
            int idx = 0;
            for (String key : allDataColumnNamesToIdx.keySet()) {
                int val = (Integer)allDataColumnNamesToIdx.get(key);
                dataColumnIndices[idx++] = val;
            }
        }
        int dataColumnCount = dataColumnIndices.length;
        if (dataColumnCount == 0) {
            throw new IOException("No columns found.");
        }
        this.columnNames = new String[dataColumnCount];
        for (int i3 = 0; i3 < dataColumnCount; ++i3) {
            this.columnNames[i3] = headerTokens[dataColumnIndices[i3]];
        }
        if (!readAllLines) {
            return;
        }
        this.values = new ArrayList<String[]>(nlines == -1 ? 100 : nlines);
        CSVReader reader = null;
        try {
            String[] tokens;
            reader = new CSVReader((Reader)br, delim);
            int linesRead = 0;
            if (nlines < 0) {
                nlines = Integer.MAX_VALUE;
            }
            this.rowNameToRowNumber = new HashMap<String, Integer>();
            this.rowNames = new ArrayList<String>();
            while ((tokens = reader.readNext()) != null && linesRead < nlines) {
                String[] line = new String[dataColumnIndices.length];
                String rowName = tokens[rowNamesColumnIndex];
                this.rowNames.add(rowName);
                this.rowNameToRowNumber.put(rowName, linesRead);
                for (int j = 0; j < dataColumnCount; ++j) {
                    int idx = dataColumnIndices[j];
                    if (idx >= tokens.length) continue;
                    line[j] = tokens[idx];
                }
                this.values.add(line);
                ++linesRead;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

