/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;

public class Array2DContentHandler
implements ExcelReaderContentHandler {
    private String[] array;
    private Map<MatrixElement, Color> colors;
    private int columns;
    private String[][] data;
    private ArrayList<String[]> list;
    protected int rowIndex = -1;

    @Override
    public void color(int c, String value, Color color) {
        this.colors.put(new MatrixElement(this.rowIndex, c), color);
    }

    @Override
    public void end() {
        if (this.data == null) {
            if (this.list == null) {
                return;
            }
            this.data = new String[this.list.size()][];
            int rows = this.data.length;
            for (int i = 0; i < rows; ++i) {
                this.data[i] = this.list.get(i);
            }
        }
        this.trimEmpty();
    }

    public String[][] getData() {
        return this.data;
    }

    public Map<MatrixElement, Color> getElementColors() {
        return this.colors;
    }

    @Override
    public void init(int rows, int columns) {
        this.columns = columns;
        this.colors = new HashMap<MatrixElement, Color>();
        if (rows != -1) {
            this.data = new String[rows][columns];
        } else {
            this.list = new ArrayList();
        }
    }

    @Override
    public boolean nextRow() {
        ++this.rowIndex;
        if (this.data != null) {
            this.array = this.data[this.rowIndex];
        } else {
            this.array = new String[this.columns];
            this.list.add(this.array);
        }
        return true;
    }

    @Override
    public void value(int columnIndex, String string) {
        this.array[columnIndex] = string;
    }

    private void trimEmpty() {
        int rowsToRemove = 0;
        for (int i = this.data.length - 1; i >= 0; --i) {
            boolean rowEmpty = true;
            int cols = this.data[0].length;
            for (int j = 0; j < cols; ++j) {
                String val = this.data[i][j];
                if (val == null || val.equals("")) continue;
                rowEmpty = false;
            }
            if (!rowEmpty) break;
            ++rowsToRemove;
        }
        if (rowsToRemove > 0) {
            String[][] copy = new String[this.data.length - rowsToRemove][];
            int length = copy.length;
            for (int i = 0; i < length; ++i) {
                copy[i] = this.data[i];
            }
            this.data = copy;
        }
    }
}

