/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.broadinstitute.genee.io.excel.DelimLineReader;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class ExcelDelimReader
implements DelimLineReader {
    private int columns;
    private InputStream is;
    private Row row;
    private int rowIndex = -1;
    private int rows;
    private Sheet sheet;
    private int skipHeaderLines;

    public ExcelDelimReader(String file, int skipHeaderLines) throws IOException, InvalidFormatException {
        this.skipHeaderLines = skipHeaderLines;
        this.rowIndex = skipHeaderLines - 1;
        if (this.rowIndex < -1) {
            this.rowIndex = -1;
        }
        this.is = IOUtil.getInputStream(file);
        this.sheet = this.getSheet(0, file);
        this.getSheetInfo();
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sheet = null;
        this.row = null;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getValue(int column) {
        Cell cell = this.row.getCell(column);
        String txt = ExcelReader.getStringCellValue(cell);
        return txt != null ? new String(txt) : "";
    }

    @Override
    public boolean nextRow() {
        ++this.rowIndex;
        if (this.rowIndex < this.rows) {
            this.row = this.sheet.getRow(this.rowIndex);
            return true;
        }
        return false;
    }

    private Sheet getSheet(Object sheetIndexOrName, String file) throws IOException, InvalidFormatException {
        Workbook wb = null;
        if (file != null) {
            if (file.toLowerCase().endsWith(".xlsx")) {
                wb = new XSSFWorkbook(OPCPackage.open((InputStream)this.is));
            } else if (file.toLowerCase().endsWith(".xls")) {
                wb = new HSSFWorkbook(this.is);
            }
        }
        if (wb == null) {
            wb = WorkbookFactory.create((InputStream)this.is);
        }
        Sheet sheet = sheetIndexOrName instanceof Integer ? wb.getSheetAt(((Integer)sheetIndexOrName).intValue()) : wb.getSheet((String)sheetIndexOrName);
        return sheet;
    }

    private void getSheetInfo() {
        Row row = this.sheet.getRow(this.skipHeaderLines);
        this.columns = row.getLastCellNum() + 1;
        for (int c = this.columns - 1; c >= 0; --c) {
            boolean nonNull = false;
            int rows = this.sheet.getLastRowNum() + 1;
            for (int r = 0; r < rows; ++r) {
                Cell cell = row.getCell(c);
                String txt = ExcelReader.getStringCellValue(cell);
                if (txt == null || "".equals(txt)) continue;
                nonNull = true;
                break;
            }
            if (nonNull) break;
            --this.columns;
        }
        this.rows = this.sheet.getLastRowNum() + 1 - this.skipHeaderLines;
    }
}

