/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.excel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.broadinstitute.genee.io.excel.DelimLineReader;
import org.broadinstitute.genee.io.util.IOUtil;

public class TextDelimReader
implements DelimLineReader {
    private BufferedReader br;
    private int columns;
    private String s;
    private char sep;
    private String[] tokens;

    public TextDelimReader(String file, int skip) throws IOException {
        this(file, skip, TextDelimReader.getSeparator(file, skip));
    }

    public TextDelimReader(String file, int skip, char sep) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
        this.sep = sep;
        for (int i = 0; i < skip; ++i) {
            this.br.readLine();
        }
        String[] header = this.br.readLine().split(String.valueOf(sep));
        this.columns = header.length;
        this.tokens = new String[this.columns];
    }

    @Override
    public void close() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.tokens = null;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public String getValue(int column) {
        return new String(this.tokens[column].trim());
    }

    @Override
    public boolean nextRow() {
        try {
            this.s = this.br.readLine();
            IOUtil.split(this.s, this.tokens, this.sep);
            return this.s != null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getSeparator(String file, int skipHeaderLines) throws IOException {
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)), 0x100000);
            for (int i = 0; i < skipHeaderLines; ++i) {
                br.readLine();
            }
            String headerLine = br.readLine();
            String[] headerTokens = headerLine.split("\t");
            char sep = '\t';
            if (headerTokens.length <= 1) {
                sep = ',';
            }
            char c = sep;
            return c;
        }
    }
}

