/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.geo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GEOSeriesMatrixParser {
    private static final String[] BANG_LINES = new String[]{"!Series_platform_id", "!Series_platform_taxid", "!Series_pubmed_id", "!Series_title", "!Series_overall_design", "!Series_summary", "!Series_last_update_date", "!Series_submission_date"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset read(File file, boolean getDataMatrix) throws IOException {
        HashMap<String, String> bangLines = new HashMap<String, String>();
        try (BufferedReader br = null;){
            RowMajorArray2DDataset dataset;
            String s;
            br = IOUtil.getBufferedReader(file);
            boolean foundSeriesMatrixTableBegin = false;
            String[] sampleSourceName = null;
            String[] sampleTitle = null;
            ArrayList<String[]> sampleCharacteristics = new ArrayList<String[]>();
            while ((s = br.readLine()) != null) {
                if (s.startsWith("!Sample_title")) {
                    sampleTitle = s.split("\t");
                    continue;
                }
                if (s.startsWith("!Sample_source_name_ch1")) {
                    sampleSourceName = s.split("\t");
                    continue;
                }
                if (s.startsWith("!Sample_characteristics_ch1")) {
                    String[] tokens = s.split("\t");
                    sampleCharacteristics.add(tokens);
                    continue;
                }
                if (s.startsWith("!series_matrix_table_begin")) {
                    foundSeriesMatrixTableBegin = true;
                    break;
                }
                for (String b : BANG_LINES) {
                    if (!s.startsWith(b)) continue;
                    b = b.substring(1);
                    String existing = (String)bangLines.get(b);
                    String val = GEOSeriesMatrixParser.dequote(s.split("\t")[1].trim());
                    if (existing == null) {
                        bangLines.put(b, val);
                        continue;
                    }
                    bangLines.put(b, existing + "\n" + val);
                }
            }
            if (!foundSeriesMatrixTableBegin && getDataMatrix) {
                throw new IllegalArgumentException("series matrix not found");
            }
            String[] header = br.readLine().split("\t");
            String[] tokens = new String[header.length];
            int ncols = header.length - 1;
            if (getDataMatrix) {
                ArrayList<float[]> dataArray = new ArrayList<float[]>();
                ArrayList<String> rowIdsList = new ArrayList<String>();
                while (!(s = br.readLine()).equals("!series_matrix_table_end")) {
                    IOUtil.split(s, tokens, '\t');
                    float[] row = new float[ncols];
                    for (int j = 0; j < ncols; ++j) {
                        row[j] = ParserHelper.parseFloatNaN(tokens[j + 1]);
                    }
                    String id = tokens[0];
                    if (id.charAt(0) == '\"') {
                        id = id.substring(1, id.length() - 1);
                    }
                    rowIdsList.add(id);
                    dataArray.add(row);
                }
                if (dataArray.size() == 0) {
                    throw new IOException("No data rows found");
                }
                float[][] data = new float[dataArray.size()][];
                int length = data.length;
                for (int i = 0; i < length; ++i) {
                    data[i] = (float[])dataArray.get(i);
                }
                dataset = new RowMajorArray2DDataset(IOUtil.getBaseFileName(file), data);
                Vector rowIds = MetadataUtil.addRowVector(dataset.getRowMetadata(), "id", String.class);
                int length2 = data.length;
                for (int i = 0; i < length2; ++i) {
                    rowIds.setValue(i, rowIdsList.get(i));
                }
            } else {
                dataset = new RowMajorArray2DDataset(IOUtil.getBaseFileName(file), 0, ncols);
            }
            for (String key : bangLines.keySet()) {
                String lines = (String)bangLines.get(key);
                dataset.setProperty(key, lines);
            }
            String seriesPlatform = (String)dataset.getProperty("Series_platform_id");
            String[] seriesPlatforms = seriesPlatform.split("\n");
            if (seriesPlatforms.length > 1) {
                String fileName = file.getName();
                int dash = fileName.indexOf(45);
                int underscore = fileName.indexOf(95);
                seriesPlatform = fileName.substring(dash + 1, underscore);
                dataset.setProperty("Series_platform_id", seriesPlatform);
            }
            GEOSeriesMatrixParser.addColumnVector(dataset, "id", header);
            if (sampleTitle != null) {
                GEOSeriesMatrixParser.addColumnVector(dataset, "Title", sampleTitle);
            }
            if (sampleSourceName != null) {
                GEOSeriesMatrixParser.addColumnVector(dataset, "Source Name", sampleSourceName);
            }
            for (String[] ch : sampleCharacteristics) {
                String name;
                int cIndex;
                if (ch.length == 0 || (cIndex = (name = GEOSeriesMatrixParser.dequote(ch[1])).indexOf(58)) == -1) continue;
                name = name.replace('.', '_');
                Vector vector = dataset.getColumnMetadata().add(MetadataUtil.createUniqueName(dataset.getColumnMetadata(), name.substring(0, cIndex)), String.class);
                int length = ch.length;
                for (int j = 1; j < length; ++j) {
                    String t = GEOSeriesMatrixParser.dequote(ch[j]);
                    int index = t.indexOf(58);
                    if (index == -1) continue;
                    String value = t.substring(index + 1).trim();
                    vector.setValue(j - 1, value);
                }
            }
            RowMajorArray2DDataset rowMajorArray2DDataset = dataset;
            return rowMajorArray2DDataset;
        }
    }

    private static void addColumnVector(Dataset dataset, String name, String[] line) {
        Vector columnIds = dataset.getColumnMetadata().add(name, String.class);
        int ncols = dataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            String id = line[j + 1];
            columnIds.setValue(j, GEOSeriesMatrixParser.dequote(id));
        }
    }

    private static String dequote(String s) {
        if (s.charAt(0) == '\"' && s.length() > 1) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

