/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.luminex;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.flowcyt.cfcs.CFCSData;
import org.flowcyt.cfcs.CFCSDataSet;
import org.flowcyt.cfcs.CFCSError;
import org.flowcyt.cfcs.CFCSKeyword;
import org.flowcyt.cfcs.CFCSKeywords;
import org.flowcyt.cfcs.CFCSListModeData;
import org.flowcyt.cfcs.CFCSParameter;
import org.flowcyt.cfcs.CFCSParameters;
import org.flowcyt.cfcs.CFCSSystem;
import org.flowcyt.facejava.fcsdata.exception.InvalidCFCSDataSetTypeException;
import org.flowcyt.facejava.fcsdata.impl.FcsParameter;

public class LXBUtil {
    private LXBUtil() {
    }

    public static LXBData loadLXB(InputStream is, String dataColumnName) throws Exception {
        CFCSSystem readSystem = new CFCSSystem();
        try {
            readSystem.open(is);
        }
        catch (CFCSError e) {
            if (e.errorNumber == -14) {
                throw new IOException(e.toString());
            }
            throw e;
        }
        if (readSystem.getCount() > 1) {
            throw new IOException();
        }
        CFCSDataSet cfcsDs = readSystem.getDataSet(0);
        int dataColumnIndex = LXBUtil.getColumnIndex(cfcsDs, dataColumnName);
        return LXBUtil.extractDataSet(cfcsDs, 1, dataColumnIndex);
    }

    public static LXBData loadLXB(String file, String dataColumnName) throws Exception {
        return LXBUtil.loadLXB(new BufferedInputStream(new FileInputStream(file)), dataColumnName);
    }

    private static LXBData extractDataSet(CFCSDataSet cfcsDs, int datasetNumber, int dataColumnIndex) throws Exception {
        CFCSData readData = cfcsDs.getData();
        if (readData.getType() != 1) {
            throw new InvalidCFCSDataSetTypeException();
        }
        CFCSKeywords keywords = cfcsDs.getKeywords();
        String well = null;
        String scanner = null;
        for (int i = 0; i < keywords.getCount(); ++i) {
            CFCSKeyword kw = keywords.getKeyword(i);
            String name = kw.getKeywordName();
            if ("$CYTSN".equals(name)) {
                scanner = kw.getKeywordValue();
                continue;
            }
            if (!"$SMNO".equals(name)) continue;
            well = kw.getKeywordValue();
        }
        CFCSParameters cfcsDsParams = cfcsDs.getParameters();
        int parameterCount = cfcsDsParams.getCount();
        ArrayList<FcsParameter> parameters = new ArrayList<FcsParameter>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            FcsParameter param;
            CFCSParameter cfcsParam = cfcsDsParams.getParameter(i);
            try {
                param = new FcsParameter(cfcsParam.getShortName(), i + 1);
            }
            catch (CFCSError e) {
                param = new FcsParameter(i + 1);
            }
            parameters.add(param);
        }
        CFCSListModeData readLMData = (CFCSListModeData)readData;
        int eventCount = readLMData.getCount();
        float[] values = new float[eventCount];
        int[] analytes = new int[eventCount];
        float[] tmp = new float[parameterCount];
        for (int i = 0; i < eventCount; ++i) {
            readLMData.getEvent(i, tmp);
            int analyte = (int)tmp[0];
            values[i] = tmp[dataColumnIndex];
            analytes[i] = analyte;
        }
        return new LXBData(values, analytes, scanner, well, keywords);
    }

    private static int getColumnIndex(CFCSDataSet fcsDataset, String dataColumnName) {
        CFCSParameters parameterList = fcsDataset.getParameters();
        int dataColumnIndex = -1;
        if (dataColumnName == null) {
            dataColumnName = "RP1";
        }
        for (int i = 0; i < parameterList.getCount(); ++i) {
            CFCSParameter p = parameterList.getParameter(i);
            if (!dataColumnName.equalsIgnoreCase(p.getShortName())) continue;
            dataColumnIndex = i;
            break;
        }
        return dataColumnIndex;
    }

    public static class LXBData {
        public float[] values;
        public String scanner;
        public String well;
        public int[] analytes;
        public CFCSKeywords keywords;

        public LXBData(float[] values, int[] analytes, String scanner, String well, CFCSKeywords keywords) {
            this.values = values;
            this.analytes = analytes;
            this.scanner = scanner;
            this.well = well;
            this.keywords = keywords;
        }

        public String toString() {
            return "LXBData [scanner=" + this.scanner + ", well=" + this.well + "]";
        }
    }
}

