/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.luminex;

import gnu.trove.list.array.TFloatArrayList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.luminex.LXBUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.TroveFloatList;

public class LuminexCsvWriter {
    public static ReadLXB getLxbs(File lxbDir, FileFilter fileFilter) {
        ArrayList<LXBUtil.LXBData> lxbs = new ArrayList<LXBUtil.LXBData>();
        if (lxbDir == null || !lxbDir.exists()) {
            System.out.println(IOUtil.getPath(lxbDir) + " not found.");
        }
        if (fileFilter == null) {
            fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".lxb") && pathname.length() > 0L;
                }
            };
        }
        File[] files = lxbDir == null | !lxbDir.exists() ? new File[]{} : lxbDir.listFiles(fileFilter);
        ArrayList<File> unreadableFiles = new ArrayList<File>();
        long lastModified = -1L;
        if (files != null && files.length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long anotherVal;
                    long thisVal = o1.lastModified();
                    return thisVal < (anotherVal = o2.lastModified()) ? -1 : (thisVal == anotherVal ? 0 : 1);
                }
            });
            File lastModFile = files[files.length - 1];
            lastModified = lastModFile.lastModified();
            for (File file : files) {
                if (file.length() == 0L) {
                    unreadableFiles.add(file);
                    System.out.println(file + " is incomplete.");
                    continue;
                }
                try {
                    lxbs.add(LXBUtil.loadLXB(file.getCanonicalPath(), null));
                }
                catch (Exception x) {
                    unreadableFiles.add(file);
                    System.out.println(file + " is incomplete.");
                }
            }
        }
        ReadLXB r = new ReadLXB();
        r.lastModified = lastModified;
        r.lxbs = lxbs.toArray(new LXBUtil.LXBData[0]);
        r.unreadableFiles = unreadableFiles;
        return r;
    }

    public static void write(String outputFile, File lxbDir, FileFilter fileFilter) throws Exception {
        LuminexCsvWriter.writeLXBData(outputFile, lxbDir, LuminexCsvWriter.getLxbs((File)lxbDir, (FileFilter)fileFilter).lxbs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLXBData(String outputFile, File lxbDir, LXBUtil.LXBData[] lxbs) throws IOException {
        try (PrintWriter pw = null;){
            LXBUtil.LXBData lxbData;
            Map<Integer, Integer> analyteToCount;
            String well;
            int i;
            int j;
            pw = new PrintWriter(outputFile);
            pw.println("\"Program\",\"xPONENT\",\"\",\"FlexMAP 3D\"\n\"Build\",\"4.0.846.0\"\n\"Date\",\"1/1/1970\",\"0:00 PM\"\n\n\"SN\",\"XXX\"\n\"Batch\",\"FROM_LXB2CSV:" + lxbDir.getName() + "\"\n" + "\"Version\",\"1\"\n" + "\"Operator\",\"Admin\"\n" + "\"ComputerName\",\"GLP820-D81\"\n" + "\"Country Code\",\"409\"\n" + "\"ProtocolName\",\".CMAP Final MAG Protocol FULL WASH\"\n" + "\"ProtocolVersion\",\"3\"\n" + "\"ProtocolDescription\",\"beads 1-500, count threshold at 500, std PMT\"\n" + "\"ProtocolDevelopingCompany\",\"CMAP\"\n" + "\"SampleVolume\",\"35 uL\"\n" + "\"DDGate\",\"7500 to 20000\"\n" + "\"SampleTimeout\",\"200 sec\"\n" + "\"BatchStartTime\",\"1/1/1970 0:00:00 PM\"\n" + "\"BatchStopTime\",\"1/1/1970 00:00:00 PM\"\n" + "\"BatchDescription\",\"<None>\"\n" + "\"ProtocolPlate\",\"Name\",\"Current 384-well plate\",\"Type\",\"384\",\"Plates\",\"1\"\n" + "\"ProtocolMicrosphere\",\"Map\",\"FlexMAP 3D Map\",\"Type\",\"MagPlex\",\"Count\",\"500\"\n" + "\"ProtocolAnalysis\",\"Off\"\n" + "\"NormBead\",\"None\"\n" + "\"ProtocolHeater\",\"Off\"\n" + "\n" + "\"Most Recent Calibration and Verification Results:\"\n" + "\"Last F3DeCAL1 Calibration\",\"Passed 4/21/2011 11:07:50 AM\"\n" + "\"Last F3DCAL2 Calibration\",\"Passed 4/21/2011 11:08:41 AM\"\n" + "\"Last F3DCAL3 Calibration\",\"Passed 4/21/2011 11:08:59 AM\"\n" + "\"Last F3DeVER1 Verification\",\"Passed 4/21/2011 11:09:46 AM\"\n" + "\"Last F3DVER2 Verification\",\"Passed 4/21/2011 11:10:22 AM\"\n" + "\"\"\n" + "\"CALInfo:\"\n" + "\"Classification Calibrator Extended\"\n" + "\"Lot\",\"ExpirationDate\",\"CalibrationTime\",\"DDTemp\",\"CL1Temp\",\"CL2Temp\",\"CL3Temp\",\"DDVolts\",\"CL1Volts\",\"CL2Volts\",\"CL3Volts\",\"DDRVal\",\"CL1RVal\",\"CL2RVal\",\"CL3RVal\",\"Result\",\"MachineSerialNo\"\n" + "\"B14872\",\"11/30/2011\",\"4/21/2011 11:07:58 AM\",\"21.96\",\"22.28\",\"22.25\",\"21.91\",\"47.01\",\"114.46\",\"121.5\",\"116.66\",\"243\",\"1240\",\"1599\",\"1347\",\"Pass\",\"FM3DD09148001\"\n" + "\"Reporter Calibrator\"\n" + "\"Lot\",\"ExpirationDate\",\"CalibrationTime\",\"RP1(1)Volts\",\"RP1(1)Val\",\"RP1(2)Volts\",\"RP1(2)Val\",\"Result\",\"MachineSerialNo\"\n" + "\"B15251\",\"12/28/2011\",\"4/21/2011 11:08:49 AM\",\"681.68\",\"3634.5\",\"848.01\",\"16553\",\"Pass\",\"FM3DD09148001\"\n" + "\"Lot\",\"ExpirationDate\",\"CalibrationTime\",\"RP1Volts\",\"RP1Val\",\"Result\",\"MachineSerialNo\"\n" + "\"B15363\",\"1/7/2012\",\"4/21/2011 11:09:06 AM\",\"848.07\",\"16574\",\"Pass\",\"FM3DD09148001\"\n" + "\n" + "\n" + "\"Samples\",\"" + lxbs.length + "\",\"Min Events\",\"500\",\"Per Bead\"");
            pw.println();
            pw.println("\"Results\"");
            pw.println();
            LuminexCsvWriter.printSectionHeader(pw, "Median");
            HashMap<String, LXBUtil.LXBData> wellToLXB = new HashMap<String, LXBUtil.LXBData>();
            for (int i2 = 0; i2 < lxbs.length; ++i2) {
                wellToLXB.put(PlateUtil.checkWellFormat(lxbs[i2].well), lxbs[i2]);
            }
            HashMap wellToAnalyteToCount = new HashMap();
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            for (j = 0; j < 24; ++j) {
                for (i = 0; i < 16; ++i) {
                    int k;
                    well = PlateUtil.getWell(i, j);
                    analyteToCount = new HashMap();
                    wellToAnalyteToCount.put(well, analyteToCount);
                    lxbData = (LXBUtil.LXBData)wellToLXB.get(well);
                    LuminexCsvWriter.printRowHeader(pw, 1 + i + j * 16, i, j);
                    HashMap<Integer, TFloatArrayList> analyteToValues = new HashMap<Integer, TFloatArrayList>();
                    if (lxbData != null) {
                        int nanalytes = lxbData.analytes.length;
                        for (k = 0; k < nanalytes; ++k) {
                            int analyte = lxbData.analytes[k];
                            if (analyte == 0) continue;
                            float val = lxbData.values[k];
                            TFloatArrayList values = (TFloatArrayList)analyteToValues.get(analyte);
                            if (values == null) {
                                values = new TFloatArrayList();
                                analyteToValues.put(analyte, values);
                            }
                            values.add(val);
                        }
                    }
                    for (k = 1; k <= 500; ++k) {
                        pw.print(",");
                        TFloatArrayList values = (TFloatArrayList)analyteToValues.get(k);
                        float median = Float.NaN;
                        if (values != null) {
                            analyteToCount.put(k, values.size());
                            median = FloatListStatUtils.median(new TroveFloatList(values));
                        }
                        pw.print("\"");
                        if (!Float.isNaN(median)) {
                            pw.print(nf.format(median));
                        }
                        pw.print("\"");
                    }
                    pw.print(",\"");
                    pw.print(0);
                    pw.print("\"");
                    pw.println();
                }
            }
            pw.println();
            LuminexCsvWriter.printSectionHeader(pw, "Count");
            for (j = 0; j < 24; ++j) {
                for (i = 0; i < 16; ++i) {
                    well = PlateUtil.getWell(i, j);
                    analyteToCount = (Map)wellToAnalyteToCount.get(well);
                    lxbData = (LXBUtil.LXBData)wellToLXB.get(well);
                    LuminexCsvWriter.printRowHeader(pw, 1 + i + j * 16, i, j);
                    for (int k = 1; k <= 500; ++k) {
                        pw.print(",");
                        Integer count = (Integer)analyteToCount.get(k);
                        if (count == null) {
                            count = 0;
                        }
                        pw.print("\"");
                        pw.print(lxbData == null ? "" : count);
                        pw.print("\"");
                    }
                    pw.print(",\"");
                    pw.print(0);
                    pw.print("\"");
                    pw.println();
                }
            }
        }
    }

    private static void printRowHeader(PrintWriter pw, int wellIndex, int i, int j) {
        pw.print("\"");
        pw.print(wellIndex);
        pw.print("(1,");
        char plateRow = PlateUtil.convertRowIndexToChar(i);
        pw.print(plateRow);
        pw.print(j + 1);
        pw.print(")\",\"Unknown");
        pw.print(wellIndex);
        pw.print("\"");
    }

    private static void printSectionHeader(PrintWriter pw, String dataType) {
        pw.println("\"DataType:\",\"" + dataType + "\"");
        pw.println("\"Location\",\"Sample\",\"Analyte 1\",\"Analyte 2\",\"Analyte 3\",\"Analyte 4\",\"Analyte 5\",\"Analyte 6\",\"Analyte 7\",\"Analyte 8\",\"Analyte 9\",\"Analyte 10\",\"Analyte 11\",\"Analyte 12\",\"Analyte 13\",\"Analyte 14\",\"Analyte 15\",\"Analyte 16\",\"Analyte 17\",\"Analyte 18\",\"Analyte 19\",\"Analyte 20\",\"Analyte 21\",\"Analyte 22\",\"Analyte 23\",\"Analyte 24\",\"Analyte 25\",\"Analyte 26\",\"Analyte 27\",\"Analyte 28\",\"Analyte 29\",\"Analyte 30\",\"Analyte 31\",\"Analyte 32\",\"Analyte 33\",\"Analyte 34\",\"Analyte 35\",\"Analyte 36\",\"Analyte 37\",\"Analyte 38\",\"Analyte 39\",\"Analyte 40\",\"Analyte 41\",\"Analyte 42\",\"Analyte 43\",\"Analyte 44\",\"Analyte 45\",\"Analyte 46\",\"Analyte 47\",\"Analyte 48\",\"Analyte 49\",\"Analyte 50\",\"Analyte 51\",\"Analyte 52\",\"Analyte 53\",\"Analyte 54\",\"Analyte 55\",\"Analyte 56\",\"Analyte 57\",\"Analyte 58\",\"Analyte 59\",\"Analyte 60\",\"Analyte 61\",\"Analyte 62\",\"Analyte 63\",\"Analyte 64\",\"Analyte 65\",\"Analyte 66\",\"Analyte 67\",\"Analyte 68\",\"Analyte 69\",\"Analyte 70\",\"Analyte 71\",\"Analyte 72\",\"Analyte 73\",\"Analyte 74\",\"Analyte 75\",\"Analyte 76\",\"Analyte 77\",\"Analyte 78\",\"Analyte 79\",\"Analyte 80\",\"Analyte 81\",\"Analyte 82\",\"Analyte 83\",\"Analyte 84\",\"Analyte 85\",\"Analyte 86\",\"Analyte 87\",\"Analyte 88\",\"Analyte 89\",\"Analyte 90\",\"Analyte 91\",\"Analyte 92\",\"Analyte 93\",\"Analyte 94\",\"Analyte 95\",\"Analyte 96\",\"Analyte 97\",\"Analyte 98\",\"Analyte 99\",\"Analyte 100\",\"Analyte 101\",\"Analyte 102\",\"Analyte 103\",\"Analyte 104\",\"Analyte 105\",\"Analyte 106\",\"Analyte 107\",\"Analyte 108\",\"Analyte 109\",\"Analyte 110\",\"Analyte 111\",\"Analyte 112\",\"Analyte 113\",\"Analyte 114\",\"Analyte 115\",\"Analyte 116\",\"Analyte 117\",\"Analyte 118\",\"Analyte 119\",\"Analyte 120\",\"Analyte 121\",\"Analyte 122\",\"Analyte 123\",\"Analyte 124\",\"Analyte 125\",\"Analyte 126\",\"Analyte 127\",\"Analyte 128\",\"Analyte 129\",\"Analyte 130\",\"Analyte 131\",\"Analyte 132\",\"Analyte 133\",\"Analyte 134\",\"Analyte 135\",\"Analyte 136\",\"Analyte 137\",\"Analyte 138\",\"Analyte 139\",\"Analyte 140\",\"Analyte 141\",\"Analyte 142\",\"Analyte 143\",\"Analyte 144\",\"Analyte 145\",\"Analyte 146\",\"Analyte 147\",\"Analyte 148\",\"Analyte 149\",\"Analyte 150\",\"Analyte 151\",\"Analyte 152\",\"Analyte 153\",\"Analyte 154\",\"Analyte 155\",\"Analyte 156\",\"Analyte 157\",\"Analyte 158\",\"Analyte 159\",\"Analyte 160\",\"Analyte 161\",\"Analyte 162\",\"Analyte 163\",\"Analyte 164\",\"Analyte 165\",\"Analyte 166\",\"Analyte 167\",\"Analyte 168\",\"Analyte 169\",\"Analyte 170\",\"Analyte 171\",\"Analyte 172\",\"Analyte 173\",\"Analyte 174\",\"Analyte 175\",\"Analyte 176\",\"Analyte 177\",\"Analyte 178\",\"Analyte 179\",\"Analyte 180\",\"Analyte 181\",\"Analyte 182\",\"Analyte 183\",\"Analyte 184\",\"Analyte 185\",\"Analyte 186\",\"Analyte 187\",\"Analyte 188\",\"Analyte 189\",\"Analyte 190\",\"Analyte 191\",\"Analyte 192\",\"Analyte 193\",\"Analyte 194\",\"Analyte 195\",\"Analyte 196\",\"Analyte 197\",\"Analyte 198\",\"Analyte 199\",\"Analyte 200\",\"Analyte 201\",\"Analyte 202\",\"Analyte 203\",\"Analyte 204\",\"Analyte 205\",\"Analyte 206\",\"Analyte 207\",\"Analyte 208\",\"Analyte 209\",\"Analyte 210\",\"Analyte 211\",\"Analyte 212\",\"Analyte 213\",\"Analyte 214\",\"Analyte 215\",\"Analyte 216\",\"Analyte 217\",\"Analyte 218\",\"Analyte 219\",\"Analyte 220\",\"Analyte 221\",\"Analyte 222\",\"Analyte 223\",\"Analyte 224\",\"Analyte 225\",\"Analyte 226\",\"Analyte 227\",\"Analyte 228\",\"Analyte 229\",\"Analyte 230\",\"Analyte 231\",\"Analyte 232\",\"Analyte 233\",\"Analyte 234\",\"Analyte 235\",\"Analyte 236\",\"Analyte 237\",\"Analyte 238\",\"Analyte 239\",\"Analyte 240\",\"Analyte 241\",\"Analyte 242\",\"Analyte 243\",\"Analyte 244\",\"Analyte 245\",\"Analyte 246\",\"Analyte 247\",\"Analyte 248\",\"Analyte 249\",\"Analyte 250\",\"Analyte 251\",\"Analyte 252\",\"Analyte 253\",\"Analyte 254\",\"Analyte 255\",\"Analyte 256\",\"Analyte 257\",\"Analyte 258\",\"Analyte 259\",\"Analyte 260\",\"Analyte 261\",\"Analyte 262\",\"Analyte 263\",\"Analyte 264\",\"Analyte 265\",\"Analyte 266\",\"Analyte 267\",\"Analyte 268\",\"Analyte 269\",\"Analyte 270\",\"Analyte 271\",\"Analyte 272\",\"Analyte 273\",\"Analyte 274\",\"Analyte 275\",\"Analyte 276\",\"Analyte 277\",\"Analyte 278\",\"Analyte 279\",\"Analyte 280\",\"Analyte 281\",\"Analyte 282\",\"Analyte 283\",\"Analyte 284\",\"Analyte 285\",\"Analyte 286\",\"Analyte 287\",\"Analyte 288\",\"Analyte 289\",\"Analyte 290\",\"Analyte 291\",\"Analyte 292\",\"Analyte 293\",\"Analyte 294\",\"Analyte 295\",\"Analyte 296\",\"Analyte 297\",\"Analyte 298\",\"Analyte 299\",\"Analyte 300\",\"Analyte 301\",\"Analyte 302\",\"Analyte 303\",\"Analyte 304\",\"Analyte 305\",\"Analyte 306\",\"Analyte 307\",\"Analyte 308\",\"Analyte 309\",\"Analyte 310\",\"Analyte 311\",\"Analyte 312\",\"Analyte 313\",\"Analyte 314\",\"Analyte 315\",\"Analyte 316\",\"Analyte 317\",\"Analyte 318\",\"Analyte 319\",\"Analyte 320\",\"Analyte 321\",\"Analyte 322\",\"Analyte 323\",\"Analyte 324\",\"Analyte 325\",\"Analyte 326\",\"Analyte 327\",\"Analyte 328\",\"Analyte 329\",\"Analyte 330\",\"Analyte 331\",\"Analyte 332\",\"Analyte 333\",\"Analyte 334\",\"Analyte 335\",\"Analyte 336\",\"Analyte 337\",\"Analyte 338\",\"Analyte 339\",\"Analyte 340\",\"Analyte 341\",\"Analyte 342\",\"Analyte 343\",\"Analyte 344\",\"Analyte 345\",\"Analyte 346\",\"Analyte 347\",\"Analyte 348\",\"Analyte 349\",\"Analyte 350\",\"Analyte 351\",\"Analyte 352\",\"Analyte 353\",\"Analyte 354\",\"Analyte 355\",\"Analyte 356\",\"Analyte 357\",\"Analyte 358\",\"Analyte 359\",\"Analyte 360\",\"Analyte 361\",\"Analyte 362\",\"Analyte 363\",\"Analyte 364\",\"Analyte 365\",\"Analyte 366\",\"Analyte 367\",\"Analyte 368\",\"Analyte 369\",\"Analyte 370\",\"Analyte 371\",\"Analyte 372\",\"Analyte 373\",\"Analyte 374\",\"Analyte 375\",\"Analyte 376\",\"Analyte 377\",\"Analyte 378\",\"Analyte 379\",\"Analyte 380\",\"Analyte 381\",\"Analyte 382\",\"Analyte 383\",\"Analyte 384\",\"Analyte 385\",\"Analyte 386\",\"Analyte 387\",\"Analyte 388\",\"Analyte 389\",\"Analyte 390\",\"Analyte 391\",\"Analyte 392\",\"Analyte 393\",\"Analyte 394\",\"Analyte 395\",\"Analyte 396\",\"Analyte 397\",\"Analyte 398\",\"Analyte 399\",\"Analyte 400\",\"Analyte 401\",\"Analyte 402\",\"Analyte 403\",\"Analyte 404\",\"Analyte 405\",\"Analyte 406\",\"Analyte 407\",\"Analyte 408\",\"Analyte 409\",\"Analyte 410\",\"Analyte 411\",\"Analyte 412\",\"Analyte 413\",\"Analyte 414\",\"Analyte 415\",\"Analyte 416\",\"Analyte 417\",\"Analyte 418\",\"Analyte 419\",\"Analyte 420\",\"Analyte 421\",\"Analyte 422\",\"Analyte 423\",\"Analyte 424\",\"Analyte 425\",\"Analyte 426\",\"Analyte 427\",\"Analyte 428\",\"Analyte 429\",\"Analyte 430\",\"Analyte 431\",\"Analyte 432\",\"Analyte 433\",\"Analyte 434\",\"Analyte 435\",\"Analyte 436\",\"Analyte 437\",\"Analyte 438\",\"Analyte 439\",\"Analyte 440\",\"Analyte 441\",\"Analyte 442\",\"Analyte 443\",\"Analyte 444\",\"Analyte 445\",\"Analyte 446\",\"Analyte 447\",\"Analyte 448\",\"Analyte 449\",\"Analyte 450\",\"Analyte 451\",\"Analyte 452\",\"Analyte 453\",\"Analyte 454\",\"Analyte 455\",\"Analyte 456\",\"Analyte 457\",\"Analyte 458\",\"Analyte 459\",\"Analyte 460\",\"Analyte 461\",\"Analyte 462\",\"Analyte 463\",\"Analyte 464\",\"Analyte 465\",\"Analyte 466\",\"Analyte 467\",\"Analyte 468\",\"Analyte 469\",\"Analyte 470\",\"Analyte 471\",\"Analyte 472\",\"Analyte 473\",\"Analyte 474\",\"Analyte 475\",\"Analyte 476\",\"Analyte 477\",\"Analyte 478\",\"Analyte 479\",\"Analyte 480\",\"Analyte 481\",\"Analyte 482\",\"Analyte 483\",\"Analyte 484\",\"Analyte 485\",\"Analyte 486\",\"Analyte 487\",\"Analyte 488\",\"Analyte 489\",\"Analyte 490\",\"Analyte 491\",\"Analyte 492\",\"Analyte 493\",\"Analyte 494\",\"Analyte 495\",\"Analyte 496\",\"Analyte 497\",\"Analyte 498\",\"Analyte 499\",\"Analyte 500\",\"Total Events\"");
    }

    public static class ReadLXB {
        public long lastModified;
        public List<File> unreadableFiles;
        public LXBUtil.LXBData[] lxbs;
    }
}

