/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.magetab;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broadinstitute.genee.io.util.IOUtil;

public class IdfReader {
    private static final Set<String> FIELDS = new HashSet<String>(Arrays.asList("Investigation Title", "Public Release Date", "PubMed ID", "Publication Title", "Experiment Description"));

    public static Map<String, String> read(String file) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try (BufferedReader br = IOUtil.getBufferedReader(file);){
            String s;
            while ((s = br.readLine()) != null) {
                String val;
                String field;
                int tab = s.indexOf(9);
                if (tab == -1 || !FIELDS.contains(field = s.substring(0, tab)) || (val = s.substring(tab + 1).trim()).equals("")) continue;
                map.put(field, val);
            }
        }
        return map;
    }
}

