/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import gnu.trove.list.array.TCharArrayList;
import gnu.trove.list.array.TFloatArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class CxtReader
implements ProjectReader {
    @Override
    public List<String> getFileSuffixes() {
        return Arrays.asList("cxt");
    }

    @Override
    public String getFormatName() {
        return "cxt";
    }

    public Map<String, String> readComments(BufferedReader br) throws IOException {
        String s;
        HashMap<String, String> comments = new HashMap<String, String>();
        while ((s = br.readLine()) != null) {
            if (s.startsWith("#")) {
                int index = s.indexOf(58);
                if (index == -1) continue;
                comments.put(s.substring(1, index).trim(), s.substring(index + 1).trim());
                continue;
            }
            if (!s.equals("NAME\tMAS5\tPCALLS")) continue;
            break;
        }
        return comments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        try (BufferedReader br = null;){
            String s;
            br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            Map<String, String> comments = this.readComments(br);
            String[] tokens = new String[3];
            ArrayList<String> probeIdsList = new ArrayList<String>();
            TFloatArrayList valuesList = new TFloatArrayList();
            TCharArrayList callsList = new TCharArrayList();
            while ((s = br.readLine()) != null) {
                if (s.startsWith("#") || s.equals("")) continue;
                IOUtil.split(s, tokens, '\t');
                probeIdsList.add(tokens[0].trim());
                valuesList.add(ParserHelper.parseFloat(tokens[1]));
                String call = tokens[2];
                callsList.add(call.charAt(0));
            }
            RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(file, new float[][]{valuesList.toArray()});
            Vector ids = dataset.getRowMetadata().add("id", String.class);
            int callsIndex = dataset.addSeries("A-P calls", Character.class);
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                dataset.setObjectValue(i, 0, Character.valueOf(callsList.getQuick(i)), callsIndex);
                ids.setValue(i, probeIdsList.get(i));
            }
            for (String key : comments.keySet()) {
                dataset.setProperty(key, comments.get(key));
            }
            DefaultProject defaultProject = new DefaultProject(dataset);
            return defaultProject;
        }
    }
}

