/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RnkWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String file, RankedList rankedList) throws IOException {
        if (!file.toLowerCase().endsWith(".rnk")) {
            file = file + ".rnk";
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int size = rankedList.size();
            for (int i = 0; i < size; ++i) {
                Object id = rankedList.getId(i);
                if (id == null || (id = id.toString()).equals("")) continue;
                pw.print(id);
                pw.print("\t");
                pw.println(Formatter.format(rankedList.getScore(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String file, Vector ids, Vector s2n, int[] indexTable) throws IOException {
        if (!file.toLowerCase().endsWith(".rnk")) {
            file = file + ".rnk";
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            int nrows = ids.size();
            for (int i = 0; i < nrows; ++i) {
                int index = indexTable[i];
                Object id = ids.getValue(index);
                if (id == null || (id = id.toString()).equals("")) continue;
                pw.print(id);
                pw.print("\t");
                pw.println(Formatter.format((Number)s2n.getValue(index)));
            }
        }
    }
}

