/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.RowMajorListDataset;
import org.broadinstitute.genee.matrix.Vector;

public class TxtProjectReader
implements ProjectReader {
    private int dataColumnStart = 1;

    public int getDataColumnStart() {
        return this.dataColumnStart;
    }

    @Override
    public List<String> getFileSuffixes() {
        return Arrays.asList("txt");
    }

    @Override
    public String getFormatName() {
        return "txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project read(String file) throws IOException {
        try (BufferedReader br = null;){
            br = IOUtil.getBufferedReader(file);
            String s = br.readLine().trim();
            String[] header = s.split("\t");
            int ncols = header.length - this.dataColumnStart;
            ArrayList<float[]> matrix = new ArrayList<float[]>();
            ArrayList arrayOfRowArrays = new ArrayList();
            for (int i = 0; i < this.dataColumnStart; ++i) {
                arrayOfRowArrays.add(new ArrayList());
            }
            String[] tokens = new String[header.length];
            while ((s = br.readLine()) != null) {
                int j;
                if ((s = s.trim()).equals("")) continue;
                IOUtil.split(s, tokens, '\t');
                if (s == "") continue;
                float[] array = new float[ncols];
                matrix.add(array);
                for (j = 0; j < this.dataColumnStart; ++j) {
                    ((List)arrayOfRowArrays.get(j)).add(new String(tokens[j]));
                }
                for (j = this.dataColumnStart; j <= ncols; ++j) {
                    String token = tokens[j];
                    array[j - this.dataColumnStart] = ParserHelper.parseFloatNaN(token);
                }
            }
            RowMajorListDataset dataset = new RowMajorListDataset(IOUtil.getName(file), matrix);
            Vector columnIds = dataset.getColumnMetadata().add("id", String.class);
            int i = 0;
            int j = this.dataColumnStart;
            while (i < ncols) {
                columnIds.setValue(i, new String(header[j]));
                ++i;
                ++j;
            }
            Vector rowIdVector = dataset.getRowMetadata().add("id", String.class);
            for (j = 0; j < rowIdVector.size(); ++j) {
                rowIdVector.setValue(j, ((List)arrayOfRowArrays.get(0)).get(j));
            }
            for (int i2 = 1; i2 < this.dataColumnStart; ++i2) {
                Vector v = dataset.getRowMetadata().add(header[i2], String.class);
                for (int j2 = 0; j2 < v.size(); ++j2) {
                    v.setValue(j2, ((List)arrayOfRowArrays.get(i2)).get(j2));
                }
            }
            DefaultProject defaultProject = new DefaultProject(dataset);
            return defaultProject;
        }
    }

    public TxtProjectReader setDataColumnStart(int dataColumnStart) {
        this.dataColumnStart = dataColumnStart;
        return this;
    }
}

