/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class TxtProjectWriter
implements ProjectWriter {
    private static final String[] EXTENSIONS = new String[]{".txt", ".tab", ".xls", ".xlsx"};

    @Override
    public String checkFileExtension(String filename) {
        String name = filename.toLowerCase();
        boolean ok = false;
        for (String ext : EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            filename = filename + ".txt";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return "txt";
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        Object obj;
        int j;
        int metadataIndex;
        Dataset dataset = project.getSortedFilteredDataset();
        MetadataModel columnMetadata = dataset.getColumnMetadata();
        MetadataModel rowMetadata = dataset.getRowMetadata();
        if (columnMetadata.getMetadataCount() == 1 && rowMetadata.getMetadataCount() == 1) {
            this.writeSimple(project, pw);
            return;
        }
        int metadataCount = columnMetadata.getMetadataCount();
        for (metadataIndex = 0; metadataIndex < metadataCount; ++metadataIndex) {
            int rowMetadataCount = rowMetadata.getMetadataCount() - 1;
            for (int rowMetadataIndex = 0; rowMetadataIndex < rowMetadataCount; ++rowMetadataIndex) {
                pw.print("\t");
            }
            pw.print(columnMetadata.getColumnName(metadataIndex));
            int cols = dataset.getColumnCount();
            for (j = 0; j < cols; ++j) {
                obj = columnMetadata.getValue(j, metadataIndex);
                pw.print("\t");
                if (obj == null) continue;
                pw.print(Formatter.toString(obj));
            }
            pw.println();
        }
        metadataCount = rowMetadata.getMetadataCount();
        for (metadataIndex = 0; metadataIndex < metadataCount; ++metadataIndex) {
            if (metadataIndex > 0) {
                pw.print("\t");
            }
            pw.print(rowMetadata.getColumnName(metadataIndex));
        }
        pw.println();
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            int metadataCount2 = rowMetadata.getMetadataCount();
            for (int metadataIndex2 = 0; metadataIndex2 < metadataCount2; ++metadataIndex2) {
                if (metadataIndex2 > 0) {
                    pw.print("\t");
                }
                if ((obj = rowMetadata.getValue(i, metadataIndex2)) == null) continue;
                pw.print(Formatter.toString(obj));
            }
            int ncols = dataset.getColumnCount();
            for (j = 0; j < ncols; ++j) {
                pw.print("\t");
                pw.print(Formatter.format(dataset.getValue(i, j)));
            }
            pw.println();
        }
    }

    private void writeSimple(Project project, PrintWriter pw) throws IOException {
        Dataset dataset = project.getSortedFilteredDataset();
        pw.print("id");
        Vector columnIds = dataset.getColumnMetadata().get(0);
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            Object obj = columnIds.getValue(j);
            pw.print("\t");
            if (obj == null) continue;
            pw.print(Formatter.toString(obj));
        }
        pw.println();
        Vector rowIds = dataset.getRowMetadata().get(0);
        int nrows = dataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            Object id = rowIds.getValue(i);
            if (id != null) {
                pw.print(Formatter.toString(id));
            }
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                pw.print("\t");
                pw.print(Formatter.format(dataset.getValue(i, j)));
            }
            pw.println();
        }
    }
}

