/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.ColumnMajorArray2DDataset;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class BctReader
implements ProjectReader {
    @Override
    public List<String> getFileSuffixes() {
        return Arrays.asList("bct");
    }

    @Override
    public String getFormatName() {
        return "bct";
    }

    @Override
    public Project read(String file) throws IOException {
        BufferedReader br = IOUtil.getBufferedReader(file);
        MetadataModel rowMetadata = this.createMetadata(br);
        MetadataModel columnMetadata = this.createMetadata(br);
        int nrows = rowMetadata.getItemCount();
        int ncols = columnMetadata.getItemCount();
        float[][] array = new float[ncols][nrows];
        String[] tokens = new String[nrows];
        for (int j = 0; j < ncols; ++j) {
            IOUtil.split(br.readLine(), tokens, '\t');
            for (int i = 0; i < nrows; ++i) {
                array[j][i] = Float.parseFloat(tokens[i]);
            }
        }
        return new DefaultProject(new ColumnMajorArray2DDataset(file, rowMetadata, columnMetadata, array));
    }

    private MetadataModel createMetadata(BufferedReader br) throws IOException {
        int nrows = Integer.parseInt(br.readLine());
        String[] rowHeaders = IOUtil.split(br.readLine());
        DefaultMetadataModel rowMetadata = new DefaultMetadataModel(nrows);
        int length = rowHeaders.length;
        for (int i = 0; i < length; ++i) {
            MetadataUtil.addRowVector(rowMetadata, rowHeaders[i], String.class);
        }
        String[] tokens = new String[rowHeaders.length];
        for (int i = 0; i < nrows; ++i) {
            IOUtil.split(br.readLine(), tokens, '\t');
            int n = rowHeaders.length;
            for (int j = 0; j < n; ++j) {
                rowMetadata.get(j).setValue(i, tokens[j]);
            }
        }
        return rowMetadata;
    }
}

