/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.util.DefaultStringConverter;
import org.broadinstitute.genee.io.util.StringConverter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;

public class GctWriter13
implements ProjectWriter {
    public static final String FORMAT_NAME = "gct";
    private StringConverter stringConverter = new DefaultStringConverter();
    private boolean outputDimensions = true;

    public static MetadataModel idFirst(MetadataModel model) {
        int idIndex = model.getColumnIndex("pr_id");
        if (idIndex == -1) {
            idIndex = model.getColumnIndex("id");
        }
        if (idIndex > 0) {
            int[] order = new int[model.getMetadataCount()];
            order[0] = idIndex;
            int j = 1;
            int count = model.getMetadataCount();
            for (int i = 0; i < count; ++i) {
                if (i == idIndex) continue;
                order[j++] = i;
            }
            return new MetadataModelColumnView(model, order);
        }
        return model;
    }

    @Override
    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith(".gct")) {
            filename = filename + ".gct";
        }
        return filename;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    public boolean isOutputDimensions() {
        return this.outputDimensions;
    }

    public void setOutputDimensions(boolean outputDimensions) {
        this.outputDimensions = outputDimensions;
    }

    public GctWriter13 setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
        return this;
    }

    public void write(Dataset dataset, PrintWriter pw) {
        MetadataModel rowMetadata = GctWriter13.idFirst(dataset.getRowMetadata());
        MetadataModel columnMetadata = GctWriter13.idFirst(dataset.getColumnMetadata());
        this.writeHeader(rowMetadata, columnMetadata, pw);
        this.writeData(dataset, rowMetadata, pw);
        pw.flush();
    }

    @Override
    public void write(Project project, PrintWriter pw) throws IOException {
        Dataset dataset = project.getSortedFilteredDataset();
        this.write(dataset, pw);
    }

    public void writeData(Dataset dataset, MetadataModel rowMetadata, PrintWriter pw) {
        int ncols = dataset.getColumnCount();
        int rowMetadataCount = rowMetadata.getMetadataCount();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            for (int rowMetadataIndex = 0; rowMetadataIndex < rowMetadataCount; ++rowMetadataIndex) {
                Object value;
                if (rowMetadataIndex > 0) {
                    pw.print("\t");
                }
                if ((value = rowMetadata.getValue(i, rowMetadataIndex)) == null) continue;
                pw.print(this.stringConverter.toString(value));
            }
            for (int j = 0; j < ncols; ++j) {
                pw.print("\t");
                pw.print(this.stringConverter.format(dataset.getValue(i, j)));
            }
            pw.println();
        }
    }

    public void writeHeader(MetadataModel rowMetadata, MetadataModel columnMetadata, PrintWriter pw) {
        int rows = rowMetadata.getItemCount();
        int ncols = columnMetadata.getItemCount();
        String version = "#1.3";
        pw.print(version);
        pw.println();
        int rowMetadataCount = rowMetadata.getMetadataCount();
        if (this.outputDimensions) {
            pw.print(rows + "\t" + ncols + "\t");
        }
        pw.print(rowMetadataCount - 1 + "\t" + (columnMetadata.getMetadataCount() - 1));
        pw.println();
        for (int i = 0; i < rowMetadataCount; ++i) {
            if (i > 0) {
                pw.print("\t");
            }
            String name = rowMetadata.getColumnName(i);
            if (i == 0 && !name.equals(columnMetadata.getColumnName(0))) {
                name = name + "/" + columnMetadata.getColumnName(0);
            }
            pw.print(name);
        }
        for (int j = 0; j < ncols; ++j) {
            pw.print("\t");
            pw.print(this.stringConverter.toString(columnMetadata.getValue(j, 0)));
        }
        pw.println();
        int metadataSize = columnMetadata.getMetadataCount();
        for (int columnMetadataIndex = 1; columnMetadataIndex < metadataSize; ++columnMetadataIndex) {
            pw.print(columnMetadata.getColumnName(columnMetadataIndex));
            for (int i = 1; i < rowMetadataCount; ++i) {
                pw.print("\t");
                pw.print("na");
            }
            for (int j = 0; j < ncols; ++j) {
                pw.print("\t");
                Object value = columnMetadata.getValue(j, columnMetadataIndex);
                if (value == null) continue;
                pw.print(this.stringConverter.toString(value));
            }
            pw.println();
        }
    }
}

