/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.matrix.Dataset;

public class DatasetBatchIterator
implements Iterator<Dataset> {
    private ArrayList<int[]> arrayList;
    private int batch = 0;
    private GctxReader reader;

    public DatasetBatchIterator(GctxReader reader, TIntArrayList columnIndices, int batchSize) {
        this.reader = reader;
        int start = 0;
        int nbatches = (int)Math.ceil((float)columnIndices.size() / (float)batchSize);
        this.arrayList = new ArrayList();
        for (int batch = 0; batch < nbatches; ++batch) {
            int[] array;
            int end = start + batchSize;
            if (end >= columnIndices.size()) {
                end = columnIndices.size();
            }
            if ((array = new int[end - start]).length <= 0) continue;
            int i = 0;
            int length = array.length;
            while (i < length) {
                array[i] = columnIndices.get(start);
                ++i;
                ++start;
            }
            this.arrayList.add(array);
        }
    }

    @Override
    public boolean hasNext() {
        return this.batch < this.arrayList.size();
    }

    @Override
    public Dataset next() {
        Dataset d = this.reader.read(null, this.arrayList.get(this.batch), false, false, true, true);
        ++this.batch;
        return d;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

