/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.cmdline.CmdLineUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.persistence.GENEEOptions;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.BigColumnMajorArray1DDataset;
import org.broadinstitute.genee.matrix.ColumnMajorArray1DDataset;
import org.broadinstitute.genee.matrix.ColumnMajorArray1DDoubleDataset;
import org.broadinstitute.genee.matrix.ColumnMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.DoubleArrayFloatList;
import org.broadinstitute.genee.matrix.FixedSizeAbstractDataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray1DDataset;
import org.broadinstitute.genee.matrix.ShortDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.stats.Sorting;

public class GctxReader
implements AutoCloseable {
    private FileFormat h5File;
    private String path;

    public GctxReader(String path) {
        try {
            if (!new File(path).exists()) {
                throw new IOException(path + " not found.");
            }
            this.path = path;
            FileFormat fileFormat = FileFormat.getFileFormat((String)"HDF5");
            if (fileFormat == null) {
                throw new RuntimeException("Cannot find HDF5 FileFormat.");
            }
            this.h5File = fileFormat.createInstance(path, 0);
            this.h5File.open();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public void close() {
        try {
            if (this.h5File != null) {
                this.h5File.close();
                this.h5File = null;
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DatasetInfo getDatasetInfo() {
        String matrixPath = "/0/DATA/0/matrix";
        try {
            ncsa.hdf.object.Dataset tmpDataset = (ncsa.hdf.object.Dataset)this.h5File.get(matrixPath);
            if (tmpDataset == null) {
                throw new NullPointerException("No data found at " + matrixPath);
            }
            tmpDataset.init();
            long[] dims = tmpDataset.getDims();
            long[] chunk = tmpDataset.getChunkSize();
            DatasetInfo info = new DatasetInfo();
            info.nrows = (int)dims[1];
            info.ncols = (int)dims[0];
            info.rowChunkSize = chunk == null ? -1 : (int)chunk[1];
            info.columnChunkSize = chunk == null ? -1 : (int)chunk[0];
            return info;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public Set<String> getDatasets() {
        try {
            HashSet<String> names = new HashSet<String>();
            Group group = (Group)this.h5File.get("/DATA");
            if (group != null) {
                for (Object obj : group.getMemberList()) {
                    if (!(obj instanceof Group)) continue;
                    Group datasetGroup = (Group)obj;
                    names.add(datasetGroup.getName());
                }
            }
            return names;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public Dendrogram getDendrogram(MetadataModel model, boolean rows) {
        try {
            String path;
            String string = path = rows ? "/0/DATA/row_dendrogram" : "/0/DATA/column_dendrogram";
            if (!this.pathExists(path)) {
                String string2 = path = rows ? "/DATA/GCT/row_dendrogram" : "/DATA/GCT/column_dendrogram";
            }
            if (this.pathExists(path)) {
                int metadataIdx = model.getColumnIndex(rows ? "gene id" : "array id");
                if (metadataIdx == -1) {
                    System.err.println("No meta data column found");
                    return null;
                }
                Vector v = model.get(metadataIdx);
                v.setProperty("Text Visible", false);
                v.setProperty("Color Visible", false);
                v.setProperty("Tooltip Visible", false);
                if (this.h5File.get(path) instanceof Group) {
                    ncsa.hdf.object.Dataset dataset = (ncsa.hdf.object.Dataset)this.h5File.get(path + "/id");
                    dataset.init();
                    String[] ids = (String[])dataset.read();
                    dataset = (ncsa.hdf.object.Dataset)this.h5File.get(path + "/left");
                    dataset.init();
                    String[] left = (String[])dataset.read();
                    dataset = (ncsa.hdf.object.Dataset)this.h5File.get(path + "/right");
                    dataset.init();
                    String[] right = (String[])dataset.read();
                    dataset = (ncsa.hdf.object.Dataset)this.h5File.get(path + "/distance");
                    dataset.init();
                    Object distance = dataset.read();
                    return new AtrGtrDendrogram(VectorUtil.asList(v).toArray(new String[0]), new AtrGtrDendrogram.ArrayDendrogramReader(ids, left, right, distance instanceof float[] ? new ArrayFloatList((float[])distance) : new DoubleArrayFloatList((double[])distance)), null, null);
                }
                byte[] bytes = this.readBytes(path);
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                return new AtrGtrDendrogram(VectorUtil.asList(v).toArray(new String[0]), new AtrGtrDendrogram.BufferedReaderDendrogramReader(new BufferedReader(new InputStreamReader(is))), null, null);
            }
            return null;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public String getFile() {
        return this.path;
    }

    public GENEEOptions getGENEEOptions() {
        String path = "/0/DATA/GENE_E";
        if (this.pathExists(path)) {
            try {
                byte[] bytes = this.readBytes(path);
                String text = Charset.forName("UTF-8").decode(ByteBuffer.wrap(bytes)).toString();
                return GENEEOptions.create(text);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Deprecated
    public Dataset getOldDataset() throws Exception {
        String[] rowIdsArray = GctxReader.getStringArray(this.h5File, "/ds0/rows/row_ids", null);
        String[] columnIdsArray = GctxReader.getStringArray(this.h5File, "/ds0/columns/column_ids", null);
        float[] matrix = (float[])GctxReader.read(this.h5File.getFID(), "/ds0/data", null, -1);
        boolean rowMajorOrder = false;
        if (H5.H5Aexists_by_name((int)this.h5File.getFID(), (String)"/ds0/data", (String)"row_major", (int)HDF5Constants.H5P_DEFAULT)) {
            int attribute_id = H5.H5Aopen_by_name((int)this.h5File.getFID(), (String)"/ds0/data", (String)"row_major", (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            int[] tmp = new int[1];
            H5.H5Aread((int)attribute_id, (int)HDF5Constants.H5T_NATIVE_INT, (Object)tmp);
            rowMajorOrder = tmp[0] == 1;
            H5.H5Aclose((int)attribute_id);
        }
        int rowCount = rowIdsArray.length;
        int columnCount = columnIdsArray.length;
        FixedSizeAbstractDataset d = !rowMajorOrder ? new ColumnMajorArray1DDataset(new File(this.path).getName(), rowCount, columnCount, matrix) : new RowMajorArray1DDataset(new File(this.path).getName(), rowCount, columnCount, matrix);
        d.setColumnMetadata(this.getRowsOrColumns("/ds0/columns", null, null, false));
        d.setRowMetadata(this.getRowsOrColumns("/ds0/rows", null, null, true));
        return d;
    }

    public List<String> getRowsOrColumnNames(boolean isRows) {
        String path;
        String string = path = !isRows ? "/0/META/COL" : "/0/META/ROW";
        if (!this.pathExists(path)) {
            path = isRows ? "/GIN" : "/SIN";
        }
        ArrayList<String> names = new ArrayList<String>();
        try {
            int count = H5.H5Gn_members((int)this.h5File.getFID(), (String)path);
            if (count > 0) {
                String[] oname = new String[count];
                int[] otype = new int[count];
                int[] ltype = new int[count];
                long[] orefs = new long[count];
                H5.H5Gget_obj_info_all((int)this.h5File.getFID(), (String)path, (String[])oname, (int[])otype, (int[])ltype, (long[])orefs, (int)HDF5Constants.H5_INDEX_NAME);
                for (int indx = 0; indx < otype.length; ++indx) {
                    String name = oname[indx];
                    names.add(name);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names;
    }

    public MetadataModel getRowsOrColumns(boolean isRows) {
        return this.getRowsOrColumns(isRows, null, null);
    }

    public MetadataModel getRowsOrColumns(boolean isRows, int[] indices, String[] fields) {
        String path;
        String string = path = !isRows ? "/0/META/COL" : "/0/META/ROW";
        if (!this.pathExists(path)) {
            path = isRows ? "/GIN" : "/SIN";
        }
        return this.getRowsOrColumns(path, indices, fields, isRows);
    }

    public boolean pathExists(String path) {
        try {
            return this.h5File.get(path) != null;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public Dataset read(int[] rowIndices, int[] columnIndices, boolean readRowMetadata, boolean readColumnMetadata, boolean rowIndicesAreAscending, boolean columnIndicesAreAscending) {
        return this.read(rowIndices, columnIndices, readRowMetadata, readColumnMetadata, rowIndicesAreAscending, columnIndicesAreAscending, -1);
    }

    public Dataset read(int[] rowIndices, int[] columnIndices, boolean readRowMetadata, boolean readColumnMetadata, boolean rowIndicesAreAscending, boolean columnIndicesAreAscending, int memoryDataType) {
        try {
            MetadataModel rowMetadata;
            MetadataModel columnMetadata;
            int columnCount;
            String matrixPath = "/0/DATA/0/matrix";
            int[] rowIndexTableIndex = null;
            if (!rowIndicesAreAscending && rowIndices != null) {
                rowIndexTableIndex = GctxReader.index(rowIndices);
            }
            int[] columnIndexTableIndex = null;
            if (!columnIndicesAreAscending && columnIndices != null) {
                columnIndexTableIndex = GctxReader.index(columnIndices);
            }
            if (!this.pathExists(matrixPath)) {
                matrixPath = "/DATA/GCT/matrix";
            }
            if (!this.pathExists(matrixPath)) {
                matrixPath = "/0/DATA/matrix0";
            }
            if (!this.pathExists(matrixPath)) {
                throw new IOException("Path /0/DATA/0/matrix not found.");
            }
            ncsa.hdf.object.Dataset tmpDataset = (ncsa.hdf.object.Dataset)this.h5File.get(matrixPath);
            tmpDataset.init();
            int rowCount = rowIndices != null ? rowIndices.length : (int)tmpDataset.getDims()[1];
            int n = columnCount = columnIndices != null ? columnIndices.length : (int)tmpDataset.getDims()[0];
            if (columnCount == 0) {
                throw new IllegalArgumentException("Zero columns specified.");
            }
            Dataset dataset = null;
            Object matrix = null;
            ArrayList<Hyperslab> slabs = new ArrayList<Hyperslab>();
            if (columnIndices != null) {
                slabs.add(new Hyperslab(columnIndices, 1));
            }
            if (rowIndices != null) {
                slabs.add(new Hyperslab(rowIndices, 2));
            }
            try {
                matrix = GctxReader.read(this.h5File.getFID(), matrixPath, slabs.toArray(new Hyperslab[0]), memoryDataType);
            }
            catch (ArrayTooBigException x) {
                if (columnIndices != null) {
                    throw new IllegalArgumentException("User chunking is only supported when columnIndices is null.");
                }
                int ncolsPerChunk = Integer.MAX_VALUE / rowCount;
                int nchunks = (int)Math.ceil((float)columnCount / (float)ncolsPerChunk);
                System.out.println("Array is too big-chunking into " + nchunks + " arrays.");
                float[][] array2d = new float[nchunks][];
                Hyperslab[] _slabs = null;
                if (rowIndices != null) {
                    _slabs = new Hyperslab[2];
                    _slabs[1] = (Hyperslab)slabs.get(0);
                } else {
                    _slabs = new Hyperslab[1];
                }
                int j = 0;
                int columnIndex = 0;
                while (j < nchunks) {
                    int arraySize = j == nchunks - 1 ? columnCount - columnIndex : ncolsPerChunk;
                    int[] tmp = new int[arraySize];
                    int k = columnIndex;
                    for (int i = 0; i < arraySize; ++i) {
                        tmp[i] = k++;
                    }
                    _slabs[0] = new Hyperslab(tmp, 1);
                    array2d[j] = (float[])GctxReader.read(this.h5File.getFID(), matrixPath, _slabs, -1);
                    ++j;
                    columnIndex += ncolsPerChunk;
                }
                dataset = new BigColumnMajorArray1DDataset(new File(this.path).getName(), rowCount, columnCount, array2d, ncolsPerChunk);
            }
            if (dataset == null) {
                if (matrix instanceof float[]) {
                    dataset = new ColumnMajorArray1DDataset(new File(this.path).getName(), rowCount, columnCount, (float[])matrix);
                } else if (matrix instanceof short[]) {
                    dataset = new ShortDataset(new File(this.path).getName(), rowCount, columnCount, (short[])matrix);
                } else if (matrix instanceof float[][]) {
                    dataset = new ColumnMajorArray2DDataset(new File(this.path).getName(), rowCount, columnCount, (float[][])matrix);
                } else if (matrix instanceof double[]) {
                    dataset = new ColumnMajorArray1DDoubleDataset(new File(this.path).getName(), rowCount, columnCount, (double[])matrix);
                } else {
                    throw new IllegalArgumentException(matrix != null ? "Unknown matrix data type " + matrix.getClass() + "." : "Matrix is null.");
                }
            }
            MetadataModel metadataModel = columnMetadata = !readColumnMetadata ? null : this.getRowsOrColumns(false, columnIndices, null);
            if (columnMetadata == null) {
                columnMetadata = new DefaultMetadataModel(columnCount);
            }
            MetadataModel metadataModel2 = rowMetadata = !readRowMetadata ? null : this.getRowsOrColumns(true, rowIndices, null);
            if (rowMetadata == null) {
                rowMetadata = new DefaultMetadataModel(rowCount);
            }
            final MetadataModel _columnMetadata = columnMetadata;
            final MetadataModel _rowMetadata = rowMetadata;
            dataset = new DatasetAdapter(dataset){

                @Override
                public MetadataModel getColumnMetadata() {
                    return _columnMetadata;
                }

                @Override
                public MetadataModel getRowMetadata() {
                    return _rowMetadata;
                }
            };
            if (rowIndexTableIndex != null || columnIndexTableIndex != null) {
                dataset = DatasetUtil.sliceView(dataset, rowIndexTableIndex, columnIndexTableIndex);
            }
            return dataset;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public byte[] readBytes(String path) throws Exception {
        ncsa.hdf.object.Dataset dataset = (ncsa.hdf.object.Dataset)this.h5File.get(path);
        dataset.init();
        return dataset.readBytes();
    }

    private MetadataModel addToMetadata(MetadataModel metadata, String path, int[] indices, boolean rows) throws Exception {
        block12: {
            String name;
            Vector vector;
            Object obj;
            block14: {
                block13: {
                    block11: {
                        Hyperslab[] hyperslabArray;
                        int n = this.h5File.getFID();
                        if (indices == null) {
                            hyperslabArray = null;
                        } else {
                            Hyperslab[] hyperslabArray2 = new Hyperslab[1];
                            hyperslabArray = hyperslabArray2;
                            hyperslabArray2[0] = new Hyperslab(indices, 1);
                        }
                        obj = GctxReader.read(n, path, hyperslabArray, -1);
                        vector = null;
                        name = path.substring(path.lastIndexOf(47) + 1);
                        if (!(obj instanceof String[])) break block11;
                        String[] array = (String[])obj;
                        if (metadata == null) {
                            metadata = new DefaultMetadataModel(array.length);
                        }
                        vector = rows ? MetadataUtil.addRowVector(metadata, name, String.class) : MetadataUtil.addColumnVector(metadata, name, String.class);
                        int length = metadata.getItemCount();
                        for (int i = 0; i < length; ++i) {
                            String val = array[i];
                            if (val != null && val.equals("")) {
                                val = null;
                            }
                            vector.setValue(i, val);
                        }
                        break block12;
                    }
                    if (!(obj instanceof float[])) break block13;
                    float[] array = (float[])obj;
                    if (metadata == null) {
                        metadata = new DefaultMetadataModel(array.length);
                    }
                    vector = rows ? MetadataUtil.addRowVector(metadata, name, Float.class) : MetadataUtil.addColumnVector(metadata, name, Float.class);
                    int length = metadata.getItemCount();
                    for (int i = 0; i < length; ++i) {
                        vector.setValue(i, Float.valueOf(array[i]));
                    }
                    break block12;
                }
                if (!(obj instanceof double[])) break block14;
                double[] array = (double[])obj;
                if (metadata == null) {
                    metadata = new DefaultMetadataModel(array.length);
                }
                vector = rows ? MetadataUtil.addRowVector(metadata, name, Float.class) : MetadataUtil.addColumnVector(metadata, name, Double.class);
                int length = metadata.getItemCount();
                for (int i = 0; i < length; ++i) {
                    vector.setValue(i, array[i]);
                }
                break block12;
            }
            if (!(obj instanceof int[])) break block12;
            int[] array = (int[])obj;
            if (metadata == null) {
                metadata = new DefaultMetadataModel(array.length);
            }
            vector = rows ? MetadataUtil.addRowVector(metadata, name, Integer.class) : MetadataUtil.addColumnVector(metadata, name, Integer.class);
            int length = metadata.getItemCount();
            for (int i = 0; i < length; ++i) {
                vector.setValue(i, array[i]);
            }
        }
        return metadata;
    }

    private MetadataModel getRowsOrColumns(String path, int[] indices, String[] fields, boolean rows) {
        try {
            if (H5.H5Lexists((int)this.h5File.getFID(), (String)path, (int)HDF5Constants.H5P_DEFAULT)) {
                MetadataModel model = null;
                if (fields == null) {
                    int count = H5.H5Gn_members((int)this.h5File.getFID(), (String)path);
                    if (count > 0) {
                        String[] oname = new String[count];
                        int[] otype = new int[count];
                        int[] ltype = new int[count];
                        long[] orefs = new long[count];
                        H5.H5Gget_obj_info_all((int)this.h5File.getFID(), (String)path, (String[])oname, (int[])otype, (int[])ltype, (long[])orefs, (int)HDF5Constants.H5_INDEX_NAME);
                        for (int indx = 0; indx < otype.length; ++indx) {
                            String name = oname[indx];
                            model = this.addToMetadata(model, path + "/" + name, indices, rows);
                        }
                    }
                } else {
                    for (String name : fields) {
                        String metadataPath = path + "/" + name;
                        if (H5.H5Lexists((int)this.h5File.getFID(), (String)metadataPath, (int)HDF5Constants.H5P_DEFAULT)) {
                            model = this.addToMetadata(model, metadataPath, indices, rows);
                            continue;
                        }
                        metadataPath = path + "/" + name.toLowerCase();
                        if (!H5.H5Lexists((int)this.h5File.getFID(), (String)metadataPath, (int)HDF5Constants.H5P_DEFAULT)) continue;
                        model = this.addToMetadata(model, metadataPath, indices, rows);
                    }
                }
                if (rows) {
                    MetadataUtil.setRowMetadataVisibility(model);
                } else {
                    MetadataUtil.setColumnMetadataVisibility(model);
                }
                return model;
            }
            System.out.println("empty " + (rows ? "row" : "column") + " metadata for " + this.path);
            return null;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object read(int file_id, String path, Hyperslab[] slabs, int memTypeId) throws Exception {
        boolean isString = false;
        int dataset_id = -1;
        int dataspace_id = -1;
        int tid = -1;
        int mspace = -1;
        try {
            dataset_id = H5.H5Dopen((int)file_id, (String)path, (int)HDF5Constants.H5P_DEFAULT);
            dataspace_id = H5.H5Dget_space((int)dataset_id);
            int rank = H5.H5Sget_simple_extent_ndims((int)dataspace_id);
            if (rank == 0) {
                rank = 1;
            }
            long[] dims = new long[rank];
            H5.H5Sget_simple_extent_dims((int)dataspace_id, (long[])dims, null);
            long[] memSpaceDimensions = (long[])dims.clone();
            mspace = HDF5Constants.H5P_DEFAULT;
            if (slabs != null && slabs.length > 0) {
                int j;
                int length;
                long[] start;
                long[] count;
                for (Hyperslab slab : slabs) {
                    memSpaceDimensions[slab.rank - 1] = slab.indices.length;
                }
                mspace = H5.H5Screate_simple((int)rank, (long[])memSpaceDimensions, null);
                if (slabs.length == 1) {
                    Hyperslab slab = slabs[0];
                    count = (long[])dims.clone();
                    start = new long[rank];
                    count[slab.rank - 1] = 1L;
                    int[] indices = slab.indices;
                    length = indices.length;
                    for (j = 0; j < length; ++j) {
                        start[slab.rank - 1] = slab.indices[j];
                        H5.H5Sselect_hyperslab((int)dataspace_id, (int)(j == 0 ? HDF5Constants.H5S_SELECT_SET : HDF5Constants.H5S_SELECT_OR), (long[])start, null, (long[])count, null);
                    }
                } else {
                    Hyperslab slab0 = slabs[0];
                    count = (long[])dims.clone();
                    start = new long[rank];
                    count[slab0.rank - 1] = 1L;
                    int length2 = slab0.indices.length;
                    for (int j2 = 0; j2 < length2; ++j2) {
                        start[slab0.rank - 1] = slab0.indices[j2];
                        H5.H5Sselect_hyperslab((int)dataspace_id, (int)(j2 == 0 ? HDF5Constants.H5S_SELECT_SET : HDF5Constants.H5S_SELECT_OR), (long[])start, null, (long[])count, null);
                    }
                    Hyperslab slab1 = slabs[1];
                    count = (long[])dims.clone();
                    start = new long[rank];
                    count[slab1.rank - 1] = 1L;
                    length = slab1.indices.length;
                    for (j = 0; j < length; ++j) {
                        start[slab1.rank - 1] = slab1.indices[j];
                        H5.H5Sselect_hyperslab((int)dataspace_id, (int)HDF5Constants.H5S_SELECT_NOTB, (long[])start, null, (long[])count, null);
                    }
                    count = (long[])dims.clone();
                    start = new long[rank];
                    count[slab0.rank - 1] = 1L;
                    length = slab0.indices.length;
                    for (j = 0; j < length; ++j) {
                        start[slab0.rank - 1] = slab0.indices[j];
                        H5.H5Sselect_hyperslab((int)dataspace_id, (int)HDF5Constants.H5S_SELECT_XOR, (long[])start, null, (long[])count, null);
                    }
                }
            }
            long lsize = 1L;
            for (int i = 0; i < rank; ++i) {
                lsize *= memSpaceDimensions[i];
            }
            tid = H5.H5Dget_type((int)dataset_id);
            int sdim = H5.H5Tget_size((int)tid);
            boolean bl = isString = memTypeId == HDF5Constants.H5T_FORTRAN_S1;
            if (isString) {
                memTypeId = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
                H5.H5Tset_size((int)memTypeId, (int)sdim);
            }
            if (memTypeId == -1) {
                int nativeTypeId = H5.H5Tget_native_type((int)tid);
                boolean isNativeDatatype = H5.H5Tequal((int)tid, (int)nativeTypeId);
                H5.H5Tclose((int)nativeTypeId);
                if (!isNativeDatatype) {
                    int tmptid = tid;
                    try {
                        tid = H5.H5Tget_native_type((int)tmptid);
                    }
                    finally {
                        try {
                            H5.H5Tclose((int)tmptid);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            String[] data = null;
            if (isString) {
                byte[] bytes = new byte[(int)(lsize * (long)sdim)];
                H5.H5Dread((int)dataset_id, (int)(memTypeId != -1 ? memTypeId : tid), (int)mspace, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (byte[])bytes);
                data = ncsa.hdf.object.Dataset.byteToString((byte[])bytes, (int)sdim);
            } else {
                if (lsize > Integer.MAX_VALUE) {
                    throw new ArrayTooBigException();
                }
                if (data == null) {
                    data = H5Datatype.allocateArray((int)(memTypeId != -1 ? memTypeId : tid), (int)((int)lsize));
                }
                if (data == null) {
                    throw new IllegalArgumentException("Unable to allocate array.");
                }
                H5.H5Dread((int)dataset_id, (int)(memTypeId != -1 ? memTypeId : tid), (int)mspace, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (Object)data);
                if (data instanceof byte[]) {
                    data = ncsa.hdf.object.Dataset.byteToString((byte[])((byte[])data), (int)sdim);
                }
            }
            String[] stringArray = data;
            return stringArray;
        }
        finally {
            if (dataset_id != -1) {
                H5.H5Dclose((int)dataset_id);
            }
            if (dataspace_id != -1) {
                H5.H5Sclose((int)dataspace_id);
            }
            if (tid != -1) {
                H5.H5Tclose((int)tid);
            }
            if (slabs != null && mspace != -1 && mspace != HDF5Constants.H5P_DEFAULT) {
                H5.H5Sclose((int)mspace);
            }
            if (isString) {
                H5.H5Tclose((int)memTypeId);
            }
        }
    }

    public static Dataset read(String file, Collection<String> rowIds, Collection<String> columnIds) {
        return GctxReader.read(file, rowIds, columnIds, true);
    }

    public static Dataset read(String file, Collection<String> rowIds, Collection<String> columnIds, boolean failIfNotFound) {
        GctxReader reader = new GctxReader(file);
        int[] columnIndices = null;
        if (columnIds != null) {
            MetadataModel columnModel = reader.getRowsOrColumns(false);
            if (columnModel == null) {
                throw new NullPointerException("Column metadata is null in " + file);
            }
            Vector columnVector = columnModel.get("id");
            if (columnVector == null) {
                columnVector = columnModel.get(0);
            }
            columnIndices = CmdLineUtil.getIndicesForValues(columnVector, columnIds, failIfNotFound);
        }
        int[] rowIndices = null;
        if (rowIds != null) {
            MetadataModel rowModel = reader.getRowsOrColumns(true);
            if (rowModel == null) {
                throw new NullPointerException("Row metadata is null in " + file);
            }
            Vector rowVector = rowModel.get("pr_id");
            if (rowVector == null) {
                rowVector = rowModel.get("id");
            }
            rowIndices = CmdLineUtil.getIndicesForValues(rowVector, rowIds, failIfNotFound);
        }
        Dataset dataset = reader.read(rowIndices, columnIndices, true, true, false, false);
        reader.close();
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project readProject(String path, int[] rowIndices, int[] columnIndices, boolean rowIndicesAreSorted, boolean columnIndicesAreSorted) {
        try (GctxReader reader = null;){
            Dendrogram dend;
            reader = new GctxReader(path);
            Dataset d = reader.read(rowIndices, columnIndices, true, true, rowIndicesAreSorted, columnIndicesAreSorted);
            DefaultProject project = new DefaultProject(d);
            if (rowIndices == null && (dend = reader.getDendrogram(d.getRowMetadata(), true)) != null) {
                project.setRowDendrogram(dend);
            }
            if (columnIndices == null && (dend = reader.getDendrogram(d.getColumnMetadata(), false)) != null) {
                project.setColumnDendrogram(dend);
            }
            project.getOriginalDataset().setProperty("genee.options", reader.getGENEEOptions());
            DefaultProject defaultProject = project;
            return defaultProject;
        }
    }

    private static String[] getStringArray(FileFormat h5File, String h5Path, int[] indices) throws Exception {
        ncsa.hdf.object.Dataset d = (ncsa.hdf.object.Dataset)h5File.get(h5Path);
        if (d == null) {
            return new String[0];
        }
        d.init();
        long[] start = d.getStartDims();
        long[] sizes = d.getSelectedDims();
        if (indices == null) {
            return (String[])d.read();
        }
        sizes[0] = 1L;
        String[] array = new String[indices.length];
        int nIds = indices.length;
        for (int i = 0; i < nIds; ++i) {
            start[0] = indices[i];
            String[] tmp = (String[])d.read();
            array[i] = tmp[0];
        }
        return array;
    }

    private static int[] index(int[] indices) {
        Sorting.Indexable[] pairs = new Sorting.IntIntPair[indices.length];
        int length = indices.length;
        for (int i = 0; i < length; ++i) {
            pairs[i] = new Sorting.IntIntPair(indices[i], i);
        }
        int[] indexTable = Sorting.index(pairs, true);
        int length2 = indices.length;
        for (int i = 0; i < length2; ++i) {
            pairs[i] = new Sorting.IntIntPair(indexTable[i], i);
        }
        int[] indexTableIndex = Sorting.index(pairs, true);
        return indexTableIndex;
    }

    private static class Hyperslab {
        int[] indices;
        int rank;

        public Hyperslab(int[] indices, int rank) {
            this.indices = indices;
            this.rank = rank;
        }
    }

    private static class ArrayTooBigException
    extends Exception {
        private ArrayTooBigException() {
        }
    }

    public static class DatasetInfo {
        public int nrows;
        public int ncols;
        public int rowChunkSize;
        public int columnChunkSize;

        public String toString() {
            return "[nrows=" + this.nrows + ", ncols=" + this.ncols + ", rowChunkSize=" + this.rowChunkSize + ", columnChunkSize=" + this.columnChunkSize + "]";
        }
    }
}

