/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx;

import chemaxon.struc.Molecule;
import gnu.trove.list.array.TLongArrayList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import org.apache.lucene.util.OpenBitSet;
import org.broadinstitute.genee.compound.MolarConcentration;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GctxWriter {
    private static final String VERSION = "GCTX1.0";
    private static final String VERSION_ATTR = "version";
    private long columnDataChunkSize = 200L;
    private int file_id = -1;
    private boolean gzip = false;
    private int matrixDataType = HDF5Constants.H5T_IEEE_F32BE;
    private long rowDataChunkSize = 100L;
    private boolean writeInSlabs = true;

    public GctxWriter(String file) throws Exception {
        try {
            int fapl = H5.H5Pcreate((int)HDF5Constants.H5P_FILE_ACCESS);
            H5.H5Pset_libver_bounds((int)fapl, (int)HDF5Constants.H5F_LIBVER_LATEST, (int)HDF5Constants.H5F_LIBVER_LATEST);
            this.file_id = !new File(file).exists() ? H5.H5Fcreate((String)file, (int)HDF5Constants.H5F_ACC_EXCL, (int)HDF5Constants.H5P_DEFAULT, (int)fapl) : H5.H5Fopen((String)file, (int)HDF5Constants.H5F_ACC_RDWR, (int)fapl);
            if (!H5.H5Aexists_by_name((int)this.file_id, (String)"/", (String)VERSION_ATTR, (int)HDF5Constants.H5P_DEFAULT)) {
                int SDIM = VERSION.length();
                int filetype = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
                H5.H5Tset_size((int)filetype, (int)SDIM);
                int memtype = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
                H5.H5Tset_size((int)memtype, (int)SDIM);
                long[] dims = new long[]{1L};
                int space = H5.H5Screate_simple((int)1, (long[])dims, null);
                int dset = H5.H5Acreate((int)this.file_id, (String)VERSION_ATTR, (int)filetype, (int)space, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
                byte[] byteArray = VERSION.getBytes();
                H5.H5Awrite((int)dset, (int)memtype, (byte[])byteArray);
                H5.H5Aclose((int)dset);
                H5.H5Sclose((int)space);
                H5.H5Tclose((int)filetype);
                H5.H5Tclose((int)memtype);
            }
        }
        catch (Exception x) {
            this.close();
            throw x;
        }
    }

    public void close() {
        try {
            if (this.file_id != -1) {
                H5.H5Fclose((int)this.file_id);
                this.file_id = -1;
            }
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            // empty catch block
        }
    }

    public void flush() throws Exception {
        H5.H5Fflush((int)this.file_id, (int)HDF5Constants.H5F_SCOPE_LOCAL);
    }

    public long getColumnDataChunkSize() {
        return this.columnDataChunkSize;
    }

    public int getMatrixDataType() {
        return this.matrixDataType;
    }

    public long getRowDataChunkSize() {
        return this.rowDataChunkSize;
    }

    public void initDatasetColumns(String path, int rowCount, int columnCount) throws Exception {
        if (rowCount == 0 || columnCount == 0) {
            throw new IllegalArgumentException();
        }
        int gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_LINK_CREATE);
        H5.H5Pset_create_intermediate_group((int)gcpl, (boolean)true);
        int slash = path.lastIndexOf(47);
        String groupPath = slash == -1 ? path : path.substring(0, slash);
        int group_id = H5.H5Gcreate((int)this.file_id, (String)groupPath, (int)gcpl, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        H5.H5Pclose((int)gcpl);
        H5.H5Gclose((int)group_id);
        long[] maxdims = new long[]{HDF5Constants.H5S_UNLIMITED, rowCount};
        long[] dims = new long[]{columnCount, rowCount};
        long[] chunk = new long[]{Math.min(this.columnDataChunkSize, (long)columnCount), Math.min(this.rowDataChunkSize, (long)rowCount)};
        int matrix_dataspace_id = H5.H5Screate_simple((int)2, (long[])dims, (long[])maxdims);
        int matrix_dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
        H5.H5Pset_chunk((int)matrix_dcpl, (int)2, (long[])chunk);
        H5.H5Pset_deflate((int)matrix_dcpl, (int)6);
        int matrix_dset = H5.H5Dcreate((int)this.file_id, (String)path, (int)HDF5Constants.H5T_IEEE_F32BE, (int)matrix_dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (int)matrix_dcpl, (int)HDF5Constants.H5P_DEFAULT);
        H5.H5Pclose((int)matrix_dcpl);
        H5.H5Dclose((int)matrix_dset);
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public boolean isWriteInSlabs() {
        return this.writeInSlabs;
    }

    public void setColumnDataChunkSize(long columnDataChunkSize) {
        this.columnDataChunkSize = columnDataChunkSize;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public void setMatrixDataType(int matrixDataType) {
        this.matrixDataType = matrixDataType;
    }

    public void setRowDataChunkSize(long rowDataChunkSize) {
        this.rowDataChunkSize = rowDataChunkSize;
    }

    public void setWriteInSlabs(boolean writeInSlabs) {
        this.writeInSlabs = writeInSlabs;
    }

    public void writeBytes(String path, byte[] bytes) throws Exception {
        int datatype_id = H5.H5Tcreate((int)HDF5Constants.H5T_OPAQUE, (int)1);
        int dataspace_id = H5.H5Screate_simple((int)1, (long[])new long[]{bytes.length}, null);
        int dataset_id = H5.H5Dcreate((int)this.file_id, (String)path, (int)datatype_id, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        H5.H5Dwrite((int)dataset_id, (int)datatype_id, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (byte[])bytes);
        H5.H5Dclose((int)dataset_id);
        H5.H5Sclose((int)dataspace_id);
        H5.H5Tclose((int)datatype_id);
    }

    public void writeDataset(String path, Dataset dataset) throws Exception {
        MetadataModel rowMetadata;
        long columnChunk = this.columnDataChunkSize;
        if (this.columnDataChunkSize <= 0L || this.columnDataChunkSize > (long)dataset.getColumnCount()) {
            columnChunk = dataset.getColumnCount();
        }
        long rowChunk = this.rowDataChunkSize;
        if (this.rowDataChunkSize <= 0L || this.rowDataChunkSize > (long)dataset.getRowCount()) {
            rowChunk = dataset.getRowCount();
        }
        this.writeDataMatrix(path, dataset, false, rowChunk, columnChunk);
        MetadataModel columnMetadata = dataset.getColumnMetadata();
        if (columnMetadata.getMetadataCount() > 0) {
            int size = columnMetadata.getMetadataCount();
            for (int i = 0; i < size; ++i) {
                Vector v = columnMetadata.get(i);
                this.writeMetadata(true, columnMetadata.getColumnName(i), VectorUtil.asList(v), v.getColumnClass());
            }
        }
        if ((rowMetadata = dataset.getRowMetadata()).getMetadataCount() > 0) {
            int size = rowMetadata.getMetadataCount();
            for (int i = 0; i < size; ++i) {
                Vector v = rowMetadata.get(i);
                this.writeMetadata(false, rowMetadata.getColumnName(i), VectorUtil.asList(v), v.getColumnClass());
            }
        }
    }

    public void writeDatasetColumns(String path, float[] columnMajorArray, int columnStartIndex, int rowCount, int ncols) throws Exception {
        int matrix_dset = H5.H5Dopen((int)this.file_id, (String)path, (int)HDF5Constants.H5P_DEFAULT);
        int matrix_fid = H5.H5Dget_space((int)matrix_dset);
        int matrix_mid = H5.H5Screate_simple((int)2, (long[])new long[]{ncols, rowCount}, null);
        long[] count = new long[]{ncols, rowCount};
        H5.H5Sselect_hyperslab((int)matrix_fid, (int)HDF5Constants.H5S_SELECT_SET, (long[])new long[]{columnStartIndex, 0L}, null, (long[])count, null);
        H5.H5Dwrite_float((int)matrix_dset, (int)HDF5Constants.H5T_NATIVE_FLOAT, (int)matrix_mid, (int)matrix_fid, (int)HDF5Constants.H5P_DEFAULT, (float[])columnMajorArray);
        H5.H5Sclose((int)matrix_mid);
        H5.H5Dclose((int)matrix_dset);
        H5.H5Sclose((int)matrix_fid);
    }

    public void writeGmt(GeneSetMatrix matrix) throws Exception {
        this.deleteIfExists("/GMT");
        HashSet<String> ids = new HashSet<String>();
        Object[] setNames = new String[matrix.getNumGeneSets()];
        int n = matrix.getNumGeneSets();
        for (int i = 0; i < n; ++i) {
            GeneSet set = matrix.get(i);
            setNames[i] = GeneSetIO.getNameNoJunk(set);
            for (String id : set.getMembers()) {
                ids.add(id);
            }
        }
        Map idToIndex = IOUtil.buildIndexMap(ids);
        int gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_LINK_CREATE);
        H5.H5Pset_create_intermediate_group((int)gcpl, (boolean)true);
        String path = "/GMT";
        int group_id = H5.H5Gcreate((int)this.file_id, (String)path, (int)gcpl, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        H5.H5Pclose((int)gcpl);
        H5.H5Gclose((int)group_id);
        this.writeString(path + "/ids", VectorUtil.asVector("", ids.toArray(new String[0])), -1L);
        long setChunkSize = 10L;
        if (setNames.length < 10) {
            setChunkSize = -1L;
        }
        this.writeString(path + "/set_names", VectorUtil.asVector("", setNames), setChunkSize);
        int words = OpenBitSet.bits2words((long)ids.size());
        long[] dims = new long[]{matrix.getNumGeneSets(), words};
        int mid = H5.H5Screate_simple((int)2, (long[])dims, null);
        int dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
        if (setChunkSize > 0L) {
            long[] chunks = new long[]{setChunkSize, words};
            H5.H5Pset_chunk((int)dcpl, (int)2, (long[])chunks);
            H5.H5Pset_deflate((int)dcpl, (int)6);
        }
        int dset = H5.H5Dcreate((int)this.file_id, (String)"/GMT/matrix", (int)HDF5Constants.H5T_STD_I64BE, (int)mid, (int)HDF5Constants.H5P_DEFAULT, (int)dcpl, (int)HDF5Constants.H5P_DEFAULT);
        int fid = H5.H5Dget_space((int)dset);
        TLongArrayList list = new TLongArrayList();
        int ncols = matrix.getNumGeneSets();
        for (int setIndex = 0; setIndex < ncols; ++setIndex) {
            GeneSet set = matrix.get(setIndex);
            OpenBitSet bitSet = new OpenBitSet((long)ids.size());
            for (String id : set.getMembers()) {
                bitSet.fastSet(idToIndex.get(id).intValue());
            }
            list.add(bitSet.getBits());
        }
        H5.H5Dwrite_long((int)dset, (int)HDF5Constants.H5T_STD_I64BE, (int)mid, (int)fid, (int)HDF5Constants.H5P_DEFAULT, (long[])list.toArray());
        H5.H5Dclose((int)dset);
        H5.H5Sclose((int)mid);
        H5.H5Sclose((int)fid);
        H5.H5Pclose((int)dcpl);
    }

    public void writeRnk(String rankedListName, String rankedListGroupName, float[] scores, int[] scoreIndices, String datasetPath) throws Exception {
        int names_fid;
        int names_dset;
        int indices_fid;
        int indices_dset;
        int scores_fid;
        int scores_dset;
        String rankedListGroupPath = "/RNK/" + rankedListGroupName;
        boolean linkExists = false;
        try {
            linkExists = H5.H5Lexists((int)this.file_id, (String)rankedListGroupPath, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception x) {
            // empty catch block
        }
        long columnIndex = 0L;
        int scores_dataspace_id = -1;
        int indices_dataspace_id = -1;
        int names_dataspace_id = -1;
        int string_tid = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
        H5.H5Tset_size((int)string_tid, (int)HDF5Constants.H5T_VARIABLE);
        if (!linkExists) {
            int gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_LINK_CREATE);
            H5.H5Pset_create_intermediate_group((int)gcpl, (boolean)true);
            int group_id = H5.H5Gcreate((int)this.file_id, (String)rankedListGroupPath, (int)gcpl, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Pclose((int)gcpl);
            H5.H5Gclose((int)group_id);
            long[] maxdims = new long[]{HDF5Constants.H5S_UNLIMITED, scores.length};
            long[] dims = new long[]{1L, scores.length};
            long[] chunk = new long[]{4L, scores.length};
            scores_dataspace_id = H5.H5Screate_simple((int)2, (long[])dims, (long[])maxdims);
            int scores_dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_chunk((int)scores_dcpl, (int)2, (long[])chunk);
            H5.H5Pset_deflate((int)scores_dcpl, (int)6);
            scores_dset = H5.H5Dcreate((int)this.file_id, (String)(rankedListGroupPath + "/scores"), (int)HDF5Constants.H5T_IEEE_F32BE, (int)scores_dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (int)scores_dcpl, (int)HDF5Constants.H5P_DEFAULT);
            scores_fid = H5.H5Dget_space((int)scores_dset);
            H5.H5Pclose((int)scores_dcpl);
            indices_dataspace_id = H5.H5Screate_simple((int)2, (long[])dims, (long[])maxdims);
            int indices_dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_chunk((int)indices_dcpl, (int)2, (long[])chunk);
            H5.H5Pset_deflate((int)indices_dcpl, (int)6);
            indices_dset = H5.H5Dcreate((int)this.file_id, (String)(rankedListGroupPath + "/indices"), (int)HDF5Constants.H5T_STD_I32BE, (int)indices_dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (int)indices_dcpl, (int)HDF5Constants.H5P_DEFAULT);
            indices_fid = H5.H5Dget_space((int)indices_dset);
            H5.H5Pclose((int)indices_dcpl);
            names_dataspace_id = H5.H5Screate_simple((int)1, (long[])new long[]{1L}, (long[])new long[]{HDF5Constants.H5S_UNLIMITED});
            int names_dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            H5.H5Pset_chunk((int)names_dcpl, (int)1, (long[])new long[]{10L});
            H5.H5Pset_deflate((int)names_dcpl, (int)6);
            names_dset = H5.H5Dcreate((int)this.file_id, (String)(rankedListGroupPath + "/ranked_list_names"), (int)string_tid, (int)names_dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (int)names_dcpl, (int)HDF5Constants.H5P_DEFAULT);
            names_fid = H5.H5Dget_space((int)names_dset);
            H5.H5Pclose((int)names_dcpl);
        } else {
            scores_dset = H5.H5Dopen((int)this.file_id, (String)(rankedListGroupPath + "/scores"), (int)HDF5Constants.H5P_DEFAULT);
            scores_fid = H5.H5Dget_space((int)scores_dset);
            long[] dims = new long[2];
            H5.H5Sget_simple_extent_dims((int)scores_fid, (long[])dims, null);
            dims = (long[])dims.clone();
            columnIndex = dims[0];
            dims[0] = dims[0] + 1L;
            H5.H5Dset_extent((int)scores_dset, (long[])dims);
            H5.H5Sclose((int)scores_fid);
            scores_fid = H5.H5Dget_space((int)scores_dset);
            indices_dset = H5.H5Dopen((int)this.file_id, (String)(rankedListGroupPath + "/indices"), (int)HDF5Constants.H5P_DEFAULT);
            indices_fid = H5.H5Dget_space((int)indices_dset);
            H5.H5Dset_extent((int)indices_dset, (long[])dims);
            H5.H5Sclose((int)indices_fid);
            indices_fid = H5.H5Dget_space((int)indices_dset);
            names_dset = H5.H5Dopen((int)this.file_id, (String)(rankedListGroupPath + "/ranked_list_names"), (int)HDF5Constants.H5P_DEFAULT);
            names_fid = H5.H5Dget_space((int)names_dset);
            H5.H5Dset_extent((int)names_dset, (long[])new long[]{columnIndex + 1L});
            H5.H5Sclose((int)names_fid);
            names_fid = H5.H5Dget_space((int)names_dset);
        }
        int scores_mid = H5.H5Screate_simple((int)1, (long[])new long[]{scores.length}, null);
        long[] start = new long[]{columnIndex, 0L};
        long[] count = new long[]{1L, scores.length};
        H5.H5Sselect_hyperslab((int)scores_fid, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, null, (long[])count, null);
        H5.H5Dwrite_float((int)scores_dset, (int)HDF5Constants.H5T_NATIVE_FLOAT, (int)scores_mid, (int)scores_fid, (int)HDF5Constants.H5P_DEFAULT, (float[])scores);
        H5.H5Sselect_hyperslab((int)indices_fid, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, null, (long[])count, null);
        H5.H5Dwrite_int((int)indices_dset, (int)HDF5Constants.H5T_NATIVE_INT, (int)scores_mid, (int)indices_fid, (int)HDF5Constants.H5P_DEFAULT, (int[])scoreIndices);
        int names_mid = H5.H5Screate_simple((int)1, (long[])new long[]{1L}, null);
        H5.H5Sselect_hyperslab((int)names_fid, (int)HDF5Constants.H5S_SELECT_SET, (long[])new long[]{columnIndex}, null, (long[])new long[]{1L}, null);
        H5.H5DwriteString((int)names_dset, (int)string_tid, (int)names_mid, (int)names_fid, (int)HDF5Constants.H5P_DEFAULT, (String[])new String[]{rankedListName});
        H5.H5Sclose((int)scores_mid);
        H5.H5Sclose((int)names_mid);
        linkExists = false;
        try {
            linkExists = H5.H5Lexists((int)this.file_id, (String)(rankedListGroupPath + "/dataset"), (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (Exception x) {
            // empty catch block
        }
        if (!linkExists) {
            H5.H5Lcreate_soft((String)datasetPath, (int)this.file_id, (String)(rankedListGroupPath + "/dataset"), (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        if (scores_dataspace_id != -1) {
            H5.H5Sclose((int)scores_dataspace_id);
            H5.H5Sclose((int)indices_dataspace_id);
            H5.H5Sclose((int)names_dataspace_id);
        }
        H5.H5Dclose((int)scores_dset);
        H5.H5Dclose((int)indices_dset);
        H5.H5Dclose((int)names_dset);
        H5.H5Sclose((int)scores_fid);
        H5.H5Sclose((int)indices_fid);
        H5.H5Sclose((int)names_fid);
        H5.H5Tclose((int)string_tid);
    }

    public void writeMetadata(boolean isColumnMetadata, String annotationName, List<?> values, Class<?> cl) throws Exception {
        int i;
        int nrows;
        String path = (isColumnMetadata ? "/0/META/COL" : "/0/META/ROW") + "/";
        try {
            int gid = H5.H5Gopen((int)this.file_id, (String)path, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Gclose((int)gid);
        }
        catch (Exception x) {
            int gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_LINK_CREATE);
            H5.H5Pset_create_intermediate_group((int)gcpl, (boolean)true);
            int group = H5.H5Gcreate((int)this.file_id, (String)path, (int)gcpl, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Pclose((int)gcpl);
            H5.H5Gclose((int)group);
        }
        if ("".equals(annotationName)) {
            annotationName = "annot";
        }
        annotationName = annotationName.replace('/', '_');
        if (String.class.isAssignableFrom(cl)) {
            this.writeString(path + annotationName, VectorUtil.asVector(annotationName, values), values.size());
        } else if (Float.class.isAssignableFrom(cl)) {
            float[] tmp = new float[values.size()];
            nrows = tmp.length;
            for (i = 0; i < nrows; ++i) {
                Number val = (Number)values.get(i);
                tmp[i] = val == null ? Float.NaN : val.floatValue();
            }
            this.write1DArray(path + annotationName, tmp, tmp.length, HDF5Constants.H5T_IEEE_F32BE, HDF5Constants.H5T_NATIVE_FLOAT, tmp.length);
        } else if (Integer.class.isAssignableFrom(cl)) {
            int[] tmp = new int[values.size()];
            nrows = tmp.length;
            for (i = 0; i < nrows; ++i) {
                Integer val = (Integer)values.get(i);
                tmp[i] = val == null ? -2147483647 : val;
            }
            this.write1DArray(path + annotationName, tmp, tmp.length, HDF5Constants.H5T_STD_I32BE, HDF5Constants.H5T_NATIVE_INT, tmp.length);
        } else {
            ArrayList<String> tmp = new ArrayList<String>();
            nrows = values.size();
            for (i = 0; i < nrows; ++i) {
                Object val = values.get(i);
                tmp.add(Formatter.toString(val));
            }
            this.writeString(path + annotationName, VectorUtil.asVector(annotationName, tmp), values.size());
        }
    }

    private boolean deleteIfExists(String name) {
        try {
            H5.H5Ldelete((int)this.file_id, (String)name, (int)HDF5Constants.H5P_DEFAULT);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void write1DArray(String path, Object array, int length, int fileType, int memType, long chunkSize) throws HDF5Exception {
        int mid = H5.H5Screate_simple((int)1, (long[])new long[]{length}, null);
        int dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
        int dset = H5.H5Dcreate((int)this.file_id, (String)path, (int)fileType, (int)mid, (int)HDF5Constants.H5P_DEFAULT, (int)dcpl, (int)HDF5Constants.H5P_DEFAULT);
        if (chunkSize > 0L) {
            H5.H5Pset_chunk((int)dcpl, (int)1, (long[])new long[]{chunkSize});
            H5.H5Pset_deflate((int)dcpl, (int)6);
        }
        int fid = H5.H5Dget_space((int)dset);
        H5.H5Dwrite((int)dset, (int)memType, (int)mid, (int)fid, (int)HDF5Constants.H5P_DEFAULT, (Object)array);
        H5.H5Dclose((int)dset);
        H5.H5Sclose((int)mid);
        H5.H5Sclose((int)fid);
        H5.H5Pclose((int)dcpl);
    }

    private void writeDataMatrix(String path, Dataset dataset, boolean rowMajorOrder, long rowDataChunkSize, long columnDataChunkSize) throws Exception {
        long[] lArray;
        this.deleteIfExists(path);
        int gcpl = H5.H5Pcreate((int)HDF5Constants.H5P_LINK_CREATE);
        H5.H5Pset_create_intermediate_group((int)gcpl, (boolean)true);
        int slash = path.lastIndexOf(47);
        String groupPath = slash == -1 ? path : path.substring(0, slash);
        int group = H5.H5Gcreate((int)this.file_id, (String)groupPath, (int)gcpl, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        H5.H5Pclose((int)gcpl);
        H5.H5Gclose((int)group);
        Dataset datasetForDataVariable = rowMajorOrder ? dataset : DatasetUtil.transposeView(dataset);
        long[] dims = new long[]{datasetForDataVariable.getRowCount(), datasetForDataVariable.getColumnCount()};
        long[] maxDims = new long[]{HDF5Constants.H5S_UNLIMITED, datasetForDataVariable.getColumnCount()};
        if (rowMajorOrder) {
            long[] lArray2 = new long[2];
            lArray2[0] = rowDataChunkSize;
            lArray = lArray2;
            lArray2[1] = columnDataChunkSize;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = columnDataChunkSize;
            lArray = lArray3;
            lArray3[1] = rowDataChunkSize;
        }
        long[] chunks = lArray;
        int mid = H5.H5Screate_simple((int)2, (long[])dims, (long[])maxDims);
        int dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
        H5.H5Pset_chunk((int)dcpl, (int)2, (long[])chunks);
        if (this.gzip) {
            H5.H5Pset_deflate((int)dcpl, (int)6);
        }
        int dset = H5.H5Dcreate((int)this.file_id, (String)path, (int)this.matrixDataType, (int)mid, (int)HDF5Constants.H5P_DEFAULT, (int)dcpl, (int)HDF5Constants.H5P_DEFAULT);
        int fid = H5.H5Dget_space((int)dset);
        if (this.writeInSlabs) {
            long[] stride = new long[]{1L, 1L};
            long[] count = new long[]{1L, 1L};
            long[] block = new long[]{1L, 1L};
            long[] start = new long[]{0L, 0L};
            float[] array = new float[1];
            H5.H5Sselect_hyperslab((int)mid, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, (long[])stride, (long[])count, (long[])block);
            int nrows = datasetForDataVariable.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                start[0] = i;
                int ncols = datasetForDataVariable.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    start[1] = j;
                    array[0] = datasetForDataVariable.getValue(i, j);
                    H5.H5Sselect_hyperslab((int)fid, (int)HDF5Constants.H5S_SELECT_SET, (long[])start, (long[])stride, (long[])count, (long[])block);
                    H5.H5Dwrite_float((int)dset, (int)HDF5Constants.H5T_NATIVE_FLOAT, (int)mid, (int)fid, (int)HDF5Constants.H5P_DEFAULT, (float[])array);
                }
            }
        } else {
            float[] array = new float[datasetForDataVariable.getRowCount() * datasetForDataVariable.getColumnCount()];
            int nrows = datasetForDataVariable.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncols = datasetForDataVariable.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    array[i * ncols + j] = datasetForDataVariable.getValue(i, j);
                }
            }
            H5.H5Dwrite_float((int)dset, (int)HDF5Constants.H5T_NATIVE_FLOAT, (int)mid, (int)fid, (int)HDF5Constants.H5P_DEFAULT, (float[])array);
        }
        H5.H5Dclose((int)dset);
        H5.H5Sclose((int)mid);
        H5.H5Sclose((int)fid);
        H5.H5Pclose((int)dcpl);
    }

    private void writeString(String path, Vector vector, long chunkSize) throws NullPointerException, HDF5Exception {
        int SDIM = GctxWriter.maxStringLength(vector);
        if (SDIM == 0) {
            System.out.println("All values are empty for " + vector.getName() + " vector");
            return;
        }
        int filetype = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
        H5.H5Tset_size((int)filetype, (int)SDIM);
        int memtype = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
        H5.H5Tset_size((int)memtype, (int)SDIM);
        int dcpl = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
        long[] dims = new long[]{vector.size()};
        int space = H5.H5Screate_simple((int)1, (long[])dims, null);
        if (chunkSize > 0L) {
            if (chunkSize > (long)vector.size()) {
                chunkSize = vector.size();
            }
            H5.H5Pset_chunk((int)dcpl, (int)1, (long[])new long[]{chunkSize});
            H5.H5Pset_deflate((int)dcpl, (int)6);
        }
        int dset = H5.H5Dcreate((int)this.file_id, (String)path, (int)filetype, (int)space, (int)HDF5Constants.H5P_DEFAULT, (int)dcpl, (int)HDF5Constants.H5P_DEFAULT);
        byte[][] byteArray = new byte[vector.size()][];
        int nrows = vector.size();
        for (int i = 0; i < nrows; ++i) {
            byteArray[i] = GctxWriter.getBytes((String)vector.getValue(i), new byte[SDIM]);
        }
        H5.H5Dwrite((int)dset, (int)memtype, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (Object)byteArray);
        H5.H5Dclose((int)dset);
        H5.H5Sclose((int)space);
        H5.H5Tclose((int)filetype);
        H5.H5Tclose((int)memtype);
        H5.H5Pclose((int)dcpl);
    }

    private static byte[] getBytes(String s, byte[] array) {
        int i;
        if (s == null) {
            s = "";
        }
        int slength = s.length();
        for (i = 0; i < slength; ++i) {
            array[i] = (byte)s.charAt(i);
        }
        int length = array.length;
        for (i = slength; i < length; ++i) {
            array[i] = 0;
        }
        return array;
    }

    private static ValueEncoder getEncoder(Class<?> c) {
        if (Date.class.isAssignableFrom(c)) {
            return new DateEncoder();
        }
        if (URL.class.isAssignableFrom(c)) {
            return new URLEncoder();
        }
        if (Molecule.class.isAssignableFrom(c)) {
            return new MoleculeEncoder();
        }
        if (MolarConcentration.class.isAssignableFrom(c)) {
            return new MolarConcentrationEncoder();
        }
        return new NullEncoder();
    }

    private static String getRankedListName(String name) {
        if (name.indexOf("_s2n_") != -1) {
            name = name.substring(0, name.indexOf("_s2n_"));
        }
        if (name.endsWith(".rnk")) {
            name = name.substring(0, name.length() - ".rnk".length());
        }
        return name;
    }

    private static int maxStringLength(Vector vector) {
        int maxLength = 0;
        ValueEncoder encoder = GctxWriter.getEncoder(vector.getColumnClass());
        int nrows = vector.size();
        for (int i = 0; i < nrows; ++i) {
            int length;
            Object val = vector.getValue(i);
            if (val == null || (length = (val = encoder.encode(val)).toString().length()) <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    private static interface ValueEncoder {
        public Object encode(Object var1);
    }

    private static class URLEncoder
    implements ValueEncoder {
        private URLEncoder() {
        }

        @Override
        public Object encode(Object value) {
            return value != null ? ((URL)value).toString() : null;
        }
    }

    private static class NullEncoder
    implements ValueEncoder {
        private NullEncoder() {
        }

        @Override
        public Object encode(Object value) {
            return value;
        }
    }

    private static class MoleculeEncoder
    implements ValueEncoder {
        private MoleculeEncoder() {
        }

        @Override
        public Object encode(Object value) {
            return value != null ? MoleculeUtil.toSmile((Molecule)value) : null;
        }
    }

    private static class MolarConcentrationEncoder
    implements ValueEncoder {
        private MolarConcentrationEncoder() {
        }

        @Override
        public Object encode(Object value) {
            return value != null ? ((MolarConcentration)value).getText() : null;
        }
    }

    private static class DateEncoder
    implements ValueEncoder {
        private DateEncoder() {
        }

        @Override
        public Object encode(Object value) {
            return value != null ? Long.valueOf(((Date)value).getTime()) : null;
        }
    }
}

