/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx.lucene;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.broadinstitute.genee.io.matrix.gctx.lucene.SpaceLowercaseAnalyzer;

public class LuceneUtils {
    private LuceneUtils() {
    }

    public static Query getQuery(String text, IndexReader reader, String[] fields, boolean defaultOr) throws ParseException {
        SpaceLowercaseAnalyzer analyzer = new SpaceLowercaseAnalyzer(Version.LUCENE_36);
        boolean multi = true;
        QueryParser luceneParser = !multi ? new QueryParser(Version.LUCENE_36, "", (Analyzer)analyzer) : new MultiFieldQueryParser(Version.LUCENE_36, fields, (Analyzer)analyzer);
        luceneParser.setDefaultOperator(defaultOr ? QueryParser.Operator.OR : QueryParser.Operator.AND);
        luceneParser.setAllowLeadingWildcard(true);
        luceneParser.setLowercaseExpandedTerms(true);
        Query query = luceneParser.parse(text);
        return query;
    }

    public static boolean isIndexOutOfDate(File fileToIndex, File indexDir) {
        if (!indexDir.isDirectory()) {
            return true;
        }
        Date indexDirModified = new Date(indexDir.lastModified());
        Date datasetLastModified = new Date(fileToIndex.lastModified());
        return indexDirModified.before(datasetLastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listValues(IndexReader reader, String field) throws Exception {
        try (TermEnum terms = null;){
            terms = reader.terms(new Term(field, ""));
            ArrayList<String> values = new ArrayList<String>();
            while (field.equals(terms.term().field())) {
                String text = terms.term().text();
                values.add(text);
                if (terms.next()) continue;
                break;
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    public static int[] search(String text, IndexReader reader) throws Exception {
        return LuceneUtils.search(null, text, reader, true);
    }

    public static int[] search(String text, File indexDir) throws Exception {
        return LuceneUtils.search(null, text, indexDir, true);
    }

    public static IndexReader getIndexReader(File indexDir) throws Exception {
        return IndexReader.open((Directory)FSDirectory.open((File)indexDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] search(String[] fields, String text, File indexDir, boolean defaultOr) throws Exception {
        try (IndexReader reader = null;){
            reader = LuceneUtils.getIndexReader(indexDir);
            int[] nArray = LuceneUtils.search(fields, text, reader, defaultOr);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] search(String[] fields, String text, IndexReader reader, boolean defaultOr) throws Exception {
        try (IndexSearcher searcher = null;){
            searcher = new IndexSearcher(reader);
            DocIndexCollector collector = new DocIndexCollector();
            searcher.search(LuceneUtils.getQuery(text, reader, fields, defaultOr), (Collector)collector);
            searcher.close();
            int[] nArray = collector.indices.toArray();
            return nArray;
        }
    }

    public static class DocIndexCollector
    extends Collector {
        public TIntArrayList indices = new TIntArrayList();
        private int docBase;

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void collect(int doc) {
            this.indices.add(doc + this.docBase);
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.docBase = docBase;
        }

        public void setScorer(Scorer scorer) {
        }
    }
}

