/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gctx.lucene;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.broadinstitute.genee.io.matrix.gctx.lucene.SpaceLowercaseAnalyzer;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public class MetadataModelLuceneUtils {
    private MetadataModelLuceneUtils() {
    }

    public static void createIndex(File indexDir, MetadataModel metadata) throws Exception {
        if (indexDir.isDirectory()) {
            FileUtils.deleteDirectory((File)indexDir);
        }
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        }
        FSDirectory dir = FSDirectory.open((File)indexDir);
        indexDir.setLastModified(System.currentTimeMillis());
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new SpaceLowercaseAnalyzer(Version.LUCENE_36));
        IndexWriter indexWriter = new IndexWriter((Directory)dir, conf);
        MetadataModelLuceneUtils.createIndex(indexWriter, metadata);
        indexWriter.close();
    }

    public static void createIndex(IndexWriter indexWriter, MetadataModel metadata) throws Exception {
        Field.Store store = Field.Store.NO;
        int items = metadata.getItemCount();
        for (int i = 0; i < items; ++i) {
            Document document = new Document();
            int metadataCount = metadata.getMetadataCount();
            for (int metadataIndex = 0; metadataIndex < metadataCount; ++metadataIndex) {
                Number value;
                NumericField field;
                Vector vector = metadata.get(metadataIndex);
                String name = vector.getName();
                if (String.class.isAssignableFrom(vector.getColumnClass())) {
                    String value2 = String.valueOf(vector.getValue(i));
                    if (value2 == null) continue;
                    document.add((Fieldable)new Field(name, value2, store, Field.Index.ANALYZED));
                    continue;
                }
                if (Float.class.isAssignableFrom(vector.getColumnClass()) || Float.TYPE.isAssignableFrom(vector.getColumnClass())) {
                    field = new NumericField(name, store, true);
                    value = (Float)vector.getValue(i);
                    if (value == null) continue;
                    field.setFloatValue(((Float)value).floatValue());
                    document.add((Fieldable)field);
                    continue;
                }
                if (!Integer.class.isAssignableFrom(vector.getColumnClass()) && !Integer.TYPE.isAssignableFrom(vector.getColumnClass())) continue;
                field = new NumericField(name, store, true);
                value = (Integer)vector.getValue(i);
                if (value == null) continue;
                field.setIntValue(((Integer)value).intValue());
                document.add((Fieldable)field);
            }
            indexWriter.addDocument(document);
        }
    }

    public static File getIndexDir(String path, boolean isRows) {
        return new File(new File(path).getParentFile(), "." + IOUtil.getBaseFileName(path) + (isRows ? ".gin" : ".sin") + ".idx");
    }
}

