/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gpr;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class GprReader
implements ProjectReader {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList("gpr"));

    @Override
    public List<String> getFileSuffixes() {
        return SUFFIXES;
    }

    @Override
    public String getFormatName() {
        return "gpr";
    }

    @Override
    public Project read(String file) throws IOException {
        String s;
        InputStream is = null;
        is = IOUtil.getInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader(is), 0x100000);
        while (!(s = br.readLine()).startsWith("\"Block\"")) {
        }
        String[] headerLine = IOUtil.split(s);
        HashMap<String, Integer> headerToIndex = new HashMap<String, Integer>();
        int length = headerLine.length;
        for (int i = 0; i < length; ++i) {
            headerToIndex.put(headerLine[i], i);
        }
        int snrIndex = (Integer)headerToIndex.get("\"SNR 635\"");
        int nameIndex = (Integer)headerToIndex.get("\"Name\"");
        int xIndex = (Integer)headerToIndex.get("\"X\"");
        int yIndex = (Integer)headerToIndex.get("\"Y\"");
        int diameterIndex = (Integer)headerToIndex.get("\"Dia.\"");
        int blockIndex = (Integer)headerToIndex.get("\"Block\"");
        int columnIndex = (Integer)headerToIndex.get("\"Column\"");
        int rowIndex = (Integer)headerToIndex.get("\"Row\"");
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(new File(file).getName(), 192, 64);
        float[][] array = dataset.getArray();
        for (int i = 0; i < 192; ++i) {
            Arrays.fill(array[i], Float.NaN);
        }
        dataset.addSeries("Image", Feature.class);
        for (int block = 0; block < 48; ++block) {
            int columnOffset = block % 4;
            int rowOffset = block / 4;
            for (int spot = 0; spot < 256; ++spot) {
                float value;
                s = br.readLine();
                String[] tokens = IOUtil.split(s);
                int blockRead = Integer.parseInt(tokens[blockIndex]) - 1;
                if (blockRead != block) {
                    throw new IOException("Unexpected block number found.");
                }
                int column = Integer.parseInt(tokens[columnIndex]) - 1;
                int row = Integer.parseInt(tokens[rowIndex]) - 1;
                int slideColumn = column + 16 * columnOffset;
                int slideRow = row + 16 * rowOffset;
                array[slideRow][slideColumn] = value = ParserHelper.parseFloat(tokens[snrIndex]);
                String spotName = tokens[nameIndex];
                int x = Integer.parseInt(tokens[xIndex]);
                int y = Integer.parseInt(tokens[yIndex]);
                int diameter = Integer.parseInt(tokens[diameterIndex]);
                dataset.setObjectValue(slideRow, slideColumn, new Feature(x, y, diameter), 0);
            }
        }
        return new DefaultProject(dataset);
    }

    public static class Feature {
        private int diameter;
        private int x;
        private int y;

        public Feature(int x, int y, int diameter) {
            this.x = x;
            this.y = y;
            this.diameter = diameter;
        }

        public int getDiameter() {
            return this.diameter;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "X: " + this.x + ", Y: " + this.y + ", Dia.: " + this.diameter;
        }
    }
}

