/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gpr;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class GprReader2 {
    protected int jpegOriginX;
    protected int jpegOriginY;
    protected Map<String, GprValue> map = new HashMap<String, GprValue>();
    protected int pixelSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GprReader2(String file) throws IOException {
        try (BufferedReader br = null;){
            br = IOUtil.getBufferedReader(file);
            br.readLine();
            String s = br.readLine();
            String[] dim = IOUtil.split(s);
            int rows = ParserHelper.parseInt(dim[0]);
            int columns = ParserHelper.parseInt(dim[1].trim());
            for (int i = 0; i < rows; ++i) {
                String token;
                s = br.readLine();
                if (s.startsWith("\"JpegOrigin")) {
                    token = s.split("=")[1];
                    String[] yx = token.split(",");
                    this.jpegOriginX = ParserHelper.parseInt(yx[0].trim());
                    this.jpegOriginY = ParserHelper.parseInt(yx[1].substring(0, yx[1].length() - 1).trim());
                    continue;
                }
                if (!s.startsWith("\"PixelSize")) continue;
                token = s.split("=")[1];
                this.pixelSize = ParserHelper.parseInt(token.substring(0, token.length() - 1).trim());
            }
            br.readLine();
            String[] tokens = new String[columns];
            while ((s = br.readLine()) != null) {
                int dia;
                int y;
                int x;
                int endIndex;
                IOUtil.split(s, tokens, '\t');
                String id = tokens[4];
                if ("\"Empty\"".equals(id) || this.add(id = id.substring(9, endIndex = id.indexOf(32)), new GprValue(x = ParserHelper.parseInt(tokens[5]), y = ParserHelper.parseInt(tokens[6]), dia = ParserHelper.parseInt(tokens[7])))) continue;
                return;
            }
        }
    }

    public GprValue get(String id) {
        return this.map.get(id);
    }

    public int getJpegOriginX() {
        return this.jpegOriginX;
    }

    public int getJpegOriginY() {
        return this.jpegOriginY;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    protected boolean add(String id, GprValue val) {
        this.map.put(id, val);
        return true;
    }

    public static void main(String[] args) throws Exception {
        String file = "C:\\Documents and Settings\\jgould.GPE61-20F\\Desktop\\datasets\\smobs\\gpr\\SMM1A1-14044413-BO007.gpr";
        GprReader2 reader = new GprReader2(file);
        GprValue value = reader.get("01-A21");
        System.out.println("value: " + value);
    }

    public static class GprValue {
        private int x;
        private int y;
        private int diameter;

        public GprValue(int x, int y, int diameter) {
            this.x = x;
            this.y = y;
            this.diameter = diameter;
        }

        public int getDiameter() {
            return this.diameter;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return this.x + ", " + this.y;
        }
    }
}

