/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.plate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.matrix.plate.EnvisionFileInfo;
import org.broadinstitute.genee.io.matrix.plate.PlateFileInfo;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class EnVisionTxtReader {
    public List<Dataset> read(String file) throws IOException {
        EnvisionFileInfo envisionFileInfo = new EnvisionFileInfo(file);
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        int nplates = envisionFileInfo.getNumberOfPlates();
        for (int i = 0; i < nplates; ++i) {
            list.add(this.read(envisionFileInfo, i));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset read(PlateFileInfo fileInfo, int plateIndex) throws IOException {
        BufferedReader br = null;
        EnvisionFileInfo envisionFileInfo = (EnvisionFileInfo)fileInfo;
        if (envisionFileInfo.getRows() <= 0) {
            envisionFileInfo.setDimensionsFromDataBlock();
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(fileInfo.getPlateName(plateIndex), fileInfo.getRows(), fileInfo.getColumns());
        dataset.setProperty("barcode", envisionFileInfo.getBarcode(plateIndex));
        try {
            int lineNumber;
            br = IOUtil.getBufferedReader(fileInfo.getFile());
            if (envisionFileInfo.isSingleTable()) {
                String s;
                int dataStartLineNumber = envisionFileInfo.getDataLineStarts().getQuick(0) - 1;
                String plateName = fileInfo.getPlateName(plateIndex);
                for (lineNumber = 0; lineNumber < dataStartLineNumber; ++lineNumber) {
                    br.readLine();
                }
                String[] headerTokens = br.readLine().split(",");
                int signalDataColumn = -1;
                int plateDataColumn = -1;
                int wellDataColumn = -1;
                int numTokens = headerTokens.length;
                for (int j = 0; j < numTokens; ++j) {
                    String token = headerTokens[j].trim();
                    if (token.equals("Signal")) {
                        signalDataColumn = j;
                        continue;
                    }
                    if (token.equals("PlateNumber")) {
                        plateDataColumn = j;
                        continue;
                    }
                    if (!token.equals("Well")) continue;
                    wellDataColumn = j;
                }
                if (plateDataColumn == -1) {
                    throw new IOException("'PlateNumber' not found in file " + new File(fileInfo.getFile()).getName());
                }
                String[] tokens = new String[numTokens];
                while (!(s = br.readLine().trim()).equals("")) {
                    String signalValue;
                    IOUtil.split(s, tokens, ',');
                    String plate = tokens[plateDataColumn];
                    if (!plate.equals(plateName) || "N/A".equals(signalValue = tokens[signalDataColumn])) continue;
                    String well = tokens[wellDataColumn];
                    String letter = String.valueOf(well.charAt(0));
                    int row = PlateUtil.convertWellRowToInt(letter);
                    int column = Integer.parseInt(well.substring(1)) - 1;
                    dataset.setValue(row, column, ParserHelper.parseFloat(signalValue));
                }
            } else {
                int dataStartLineNumber = envisionFileInfo.getDataLineStarts().getQuick(plateIndex);
                while (lineNumber < dataStartLineNumber) {
                    br.readLine();
                    ++lineNumber;
                }
                char delim = envisionFileInfo.isTabDelimitted() ? (char)'\t' : ',';
                int plateRows = fileInfo.getRows();
                int plateColumns = fileInfo.getColumns();
                String[] tokens = new String[plateColumns + 1];
                for (int i = 0; i < plateRows; ++i) {
                    String s = br.readLine();
                    IOUtil.split(s, tokens, delim);
                    for (int j = 0; j < plateColumns; ++j) {
                        String token = tokens[j + 1];
                        dataset.setValue(i, j, ParserHelper.parseFloat(token));
                    }
                }
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return dataset;
    }
}

