/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.stanford;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;

public class StanfordTxtWriter {
    private String format = "txt";

    public String checkFileExtension(String filename) {
        if (!filename.toLowerCase().endsWith("." + this.format)) {
            filename = filename + "." + this.format;
        }
        return filename;
    }

    public String getFormatName() {
        return this.format;
    }

    public void write(Project Project2, OutputStream os) {
        Dataset dataset = Project2.getSortedFilteredDataset();
        this.writeHeader(dataset, os);
        PrintWriter out = new PrintWriter(os);
        int rows = dataset.getRowCount();
        int columns = dataset.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            out.println();
            out.print(dataset.getRowMetadata().getValue(i, 0));
            out.print("\t");
            String rowDescription = (String)dataset.getRowMetadata().getValue(i, "Description");
            if (rowDescription == null) {
                rowDescription = "";
            }
            out.print(rowDescription);
            for (int j = 0; j < columns; ++j) {
                out.print("\t");
                float value = dataset.getValue(i, j);
                out.print(Float.isNaN(value) ? "" : Float.valueOf(value));
            }
        }
        out.println();
        out.flush();
    }

    public void writeHeader(Dataset dataset, OutputStream os) {
        PrintWriter out = new PrintWriter(os);
        int columns = dataset.getColumnCount();
        out.print("ID");
        out.print("\t");
        out.print("NAME");
        Vector columnIds = dataset.getColumnMetadata().get(0);
        for (int j = 0; j < columns; ++j) {
            out.print("\t");
            out.print(columnIds.getValue(j));
        }
        out.flush();
    }
}

