/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public class CommentCharReader
extends LineNumberReader {
    private String commentCharacter = "#";
    private boolean skipBlankLines = true;

    public CommentCharReader(Reader in) {
        super(in, 0x100000);
    }

    public String getCommentCharacter() {
        return this.commentCharacter;
    }

    public boolean isSkipBlankLines() {
        return this.skipBlankLines;
    }

    @Override
    public String readLine() throws IOException {
        String s = super.readLine();
        while (s != null && (this.skipBlankLines && s.length() == 0 || this.commentCharacter != null && s.startsWith(this.commentCharacter))) {
            s = super.readLine();
        }
        return s;
    }

    public void setCommentCharacter(String commentCharacter) {
        this.commentCharacter = commentCharacter;
    }

    public void setSkipBlankLines(boolean skipBlankLines) {
        this.skipBlankLines = skipBlankLines;
    }
}

