/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.broadinstitute.genee.cmap.scripts.ScriptUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class NCBIGeneInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCBIGeneInfo(String file, String outputFile, String taxonId, String[] fields) throws Exception {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String s;
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            pw.println("gene_id\tgene_symbol\tgene_title");
            br = IOUtil.getBufferedReader(file);
            String header = br.readLine();
            header = header.substring("#Format: ".length());
            String[] headerTokens = header.split(" ");
            int[] fieldIndices = new int[fields.length];
            Arrays.fill(fieldIndices, -1);
            Map<String, Integer> fieldNameToIndex = IOUtil.buildIndexMap(Arrays.asList(fields));
            for (int i = 0; i < headerTokens.length; ++i) {
                Integer index = fieldNameToIndex.get(headerTokens[i]);
                if (index == null) continue;
                fieldIndices[index.intValue()] = i;
            }
            int nfields = fields.length;
            for (int i = 0; i < nfields; ++i) {
                if (fieldIndices[i] != -1) continue;
                throw new IllegalArgumentException(fields[i] + " not found.");
            }
            String[] tokens = new String[headerTokens.length];
            while ((s = br.readLine()) != null) {
                if (!s.startsWith(taxonId)) continue;
                IOUtil.split(s, tokens, '\t');
                for (int i = 0; i < nfields; ++i) {
                    int index = fieldIndices[i];
                    if (i > 0) {
                        pw.print("\t");
                    }
                    pw.print(tokens[index]);
                }
                pw.println();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String[] fields = new String[]{"GeneID", "Symbol", "description"};
        try {
            GeneInfoXTractArgs argsp;
            Cli cli = CliFactory.createCli(GeneInfoXTractArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            File outputFile = (argsp = (GeneInfoXTractArgs)cli.parseArguments(args)).isOutputFile() ? argsp.getOutputFile() : new File(ScriptUtil.getOutputDir(argsp), argsp.getTaxonId() + ".txt");
            ScriptUtil.createReport(outputFile, argsp);
            new NCBIGeneInfo(argsp.getGeneInfoFile(), outputFile.getCanonicalPath(), argsp.getTaxonId(), fields);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="gene_info_x")
    public static interface GeneInfoXTractArgs {
        @Option(longName={"gene_info"}, description="path to gene_info file (default /xchip/cogs/data/vdb/gene_info)", defaultValue={"/xchip/cogs/data/vdb/gene_info"})
        public String getGeneInfoFile();

        @Option(longName={"output"}, shortName={"o"}, description="output file")
        public File getOutputFile();

        public boolean isOutputFile();

        @Option(longName={"taxon"}, shortName={"t"}, description="taxon_id (default is 9606)", defaultValue={"9606"})
        public String getTaxonId();
    }
}

