/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import com.google.common.base.Objects;
import gnu.trove.list.array.TFloatArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.heatmap.FilePlateWellValue;
import org.broadinstitute.genee.heatmap.FilePlateWellValueList;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;

public class PlateUtil {
    public static final Map<String, Integer> CHAR_TO_ROW_INDEX;
    public static final char[] ROWS;
    private static final Map<Integer, Character> ROW_INDEX_TO_CHAR;

    public static String checkWellFormat(String well) {
        if (Character.isLowerCase(well.charAt(0))) {
            well = Character.toUpperCase(well.charAt(0)) + well.substring(1);
        }
        if (well.length() < 3) {
            well = well.substring(0, 1) + "0" + well.substring(1, well.length());
        }
        return well;
    }

    public static char convertRowIndexToChar(int rowIndex) {
        if (rowIndex >= ROW_INDEX_TO_CHAR.size()) {
            rowIndex %= ROW_INDEX_TO_CHAR.size();
        }
        return ROW_INDEX_TO_CHAR.get(rowIndex).charValue();
    }

    public static String convertRowIndexToString(int rowIndex) {
        return String.valueOf(PlateUtil.convertRowIndexToChar(rowIndex));
    }

    public static int convertWellRowToInt(char letter) {
        return PlateUtil.convertWellRowToInt(String.valueOf(letter));
    }

    public static int convertWellRowToInt(String letter) {
        Integer map = CHAR_TO_ROW_INDEX.get(letter.toUpperCase());
        if (map == null) {
            throw new IllegalArgumentException("No value for " + letter);
        }
        return map;
    }

    public static AbstractSampleInfoFile createPlateAndWellSampleInfoFile(ProgressNotifier progressMonitor, String file, String worksheet) throws IOException {
        String[][] matrix = ((Array2DContentHandler)new ExcelReader(file, worksheet, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
        LinkedHashMap<String, Integer> columnNameToIndex = new LinkedHashMap<String, Integer>();
        String[] header = matrix[0];
        int length = header.length;
        for (int i = 0; i < length; ++i) {
            columnNameToIndex.put(header[i].toLowerCase(), i);
        }
        final Integer plateColumnIndex = (Integer)columnNameToIndex.remove("plate");
        if (plateColumnIndex == null) {
            throw new RuntimeException("Plate map file must include a 'plate' header.");
        }
        final Integer wellColumnIndex = (Integer)columnNameToIndex.remove("well");
        final Integer rowColumnIndex = (Integer)columnNameToIndex.remove("row");
        final Integer columnColumnIndex = (Integer)columnNameToIndex.remove("column");
        if (wellColumnIndex == null && (rowColumnIndex == null || columnColumnIndex == null)) {
            throw new RuntimeException("Plate map file must include a 'well' header or 'row' and 'column' headers.");
        }
        int[] valueColumnIndices = new int[columnNameToIndex.size()];
        int i = 0;
        for (Integer index : columnNameToIndex.values()) {
            valueColumnIndices[i++] = index;
        }
        AbstractSampleInfoFile sampleInfo = new AbstractSampleInfoFile(matrix, valueColumnIndices){

            @Override
            protected Object createKey(String[] array) {
                String well = wellColumnIndex == null ? array[rowColumnIndex].trim() + array[columnColumnIndex].trim() : array[wellColumnIndex];
                well = PlateUtil.checkWellFormat(well);
                Identifier<String> id = new Identifier<String>(array[plateColumnIndex].trim(), well);
                return id;
            }
        };
        return sampleInfo;
    }

    public static String getWell(int rowIndex, int columnIndex) {
        StringBuilder sb = new StringBuilder(PlateUtil.convertRowIndexToString(rowIndex));
        if (++columnIndex < 10) {
            sb.append("0");
        }
        return sb.append(columnIndex).toString();
    }

    public static void scaleTo(List<Dataset> datasets, Map<String, AbstractSampleInfoFile> fileToSampleInfoFile, String[] fields, String[] values) {
        int nfields = fields.length;
        TFloatArrayList list = new TFloatArrayList();
        for (Dataset dataset : datasets) {
            list.clear();
            String plate = dataset.getName();
            String file = (String)dataset.getProperty("File");
            AbstractSampleInfoFile sampleInfo = fileToSampleInfoFile.get(file);
            int[] keyColumnIndices = new int[nfields];
            for (int k = 0; k < nfields; ++k) {
                keyColumnIndices[k] = sampleInfo.getColumnIndex(fields[k]);
            }
            int rows = dataset.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int cols = dataset.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    float f;
                    String well = PlateUtil.getWell(i, j);
                    int rowIndex = sampleInfo.idToRowIndex(new Identifier<Object>(plate, well));
                    if (rowIndex == -1) continue;
                    boolean equals = true;
                    for (int k = 0; k < nfields; ++k) {
                        String value = sampleInfo.getValue(rowIndex, keyColumnIndices[k]);
                        if (Objects.equal((Object)value, (Object)values[k])) continue;
                        equals = false;
                        break;
                    }
                    if (!equals || Float.isNaN(f = dataset.getValue(i, j))) continue;
                    list.add(f);
                }
            }
            float median = FloatListStatUtils.median(new TroveFloatList(list));
            int rows2 = dataset.getRowCount();
            for (int i = 0; i < rows2; ++i) {
                int cols = dataset.getColumnCount();
                for (int j = 0; j < cols; ++j) {
                    dataset.setValue(i, j, median == 0.0f ? 0.0f : dataset.getValue(i, j) / median);
                }
            }
        }
    }

    public static Dataset toPlateColumn(List<Dataset> datasets, String name) {
        int combinedDatasetRows = datasets.get(0).getColumnCount() * datasets.get(0).getRowCount();
        int combinedDatasetColumns = datasets.size();
        RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset(name, combinedDatasetRows, combinedDatasetColumns);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate column", Integer.class);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate row", String.class);
        Vector plateColumn = combinedDataset.getRowMetadata().get(0);
        Vector plateRow = combinedDataset.getRowMetadata().get(1);
        Vector columnNames = MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), "id", String.class);
        List<String> properties = PlateUtil.addStringProperties(datasets.get(0), combinedDataset);
        int ndatasets = datasets.size();
        for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
            Dataset dataset = datasets.get(datasetIndex);
            for (String property : properties) {
                combinedDataset.getColumnMetadata().setValue(datasetIndex, property, dataset.getProperty(property));
            }
            columnNames.setValue(datasetIndex, dataset.getName());
            int combinedIndex = 0;
            int ncols = dataset.getColumnCount();
            for (int j = 0; j < ncols; ++j) {
                int nrows = dataset.getRowCount();
                for (int i = 0; i < nrows; ++i) {
                    combinedDataset.setValue(combinedIndex, datasetIndex, dataset.getValue(i, j));
                    plateColumn.setValue(combinedIndex, j + 1);
                    plateRow.setValue(combinedIndex, PlateUtil.convertRowIndexToString(i));
                    ++combinedIndex;
                }
            }
        }
        return combinedDataset;
    }

    public static Dataset toPlateLayout(List<Dataset> datasets, String name) {
        int combinedDatasetRows = datasets.get(0).getRowCount() * datasets.size();
        int combinedDatasetColumns = datasets.get(0).getColumnCount();
        RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset(name, combinedDatasetRows, combinedDatasetColumns);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate row", String.class);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate", String.class);
        Vector plateColumn = MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), "plate column", Integer.class);
        int ncols = combinedDataset.getColumnCount();
        for (int j = 0; j < ncols; ++j) {
            plateColumn.setValue(j, j + 1);
        }
        Vector row = combinedDataset.getRowMetadata().get(0);
        Vector plate = combinedDataset.getRowMetadata().get(1);
        int combinedIndex = 0;
        int ndatasets = datasets.size();
        for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
            Dataset dataset = datasets.get(datasetIndex);
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncols2 = dataset.getColumnCount();
                for (int j = 0; j < ncols2; ++j) {
                    combinedDataset.setValue(combinedIndex, j, dataset.getValue(i, j));
                    row.setValue(combinedIndex, PlateUtil.convertRowIndexToString(i));
                    plate.setValue(combinedIndex, dataset.getName());
                }
                ++combinedIndex;
            }
        }
        return combinedDataset;
    }

    public static Dataset toPlateRow(List<Dataset> datasets, String name) {
        int combinedDatasetRows = datasets.get(0).getColumnCount() * datasets.get(0).getRowCount();
        int combinedDatasetColumns = datasets.size();
        RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset(name, combinedDatasetRows, combinedDatasetColumns);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate column", Integer.class);
        MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), "plate row", String.class);
        Vector plateColumn = combinedDataset.getRowMetadata().get(0);
        Vector plateRow = combinedDataset.getRowMetadata().get(1);
        Vector columnNames = MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), "id", String.class);
        List<String> properties = PlateUtil.addStringProperties(datasets.get(0), combinedDataset);
        int ndatasets = datasets.size();
        for (int datasetIndex = 0; datasetIndex < ndatasets; ++datasetIndex) {
            Dataset dataset = datasets.get(datasetIndex);
            for (String property : properties) {
                combinedDataset.getColumnMetadata().setValue(datasetIndex, property, dataset.getProperty(property));
            }
            columnNames.setValue(datasetIndex, dataset.getName());
            int combinedIndex = 0;
            int nrows = dataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                int ncols = dataset.getColumnCount();
                for (int j = 0; j < ncols; ++j) {
                    combinedDataset.setValue(combinedIndex, datasetIndex, dataset.getValue(i, j));
                    plateColumn.setValue(combinedIndex, j + 1);
                    plateRow.setValue(combinedIndex, PlateUtil.convertRowIndexToString(i));
                    ++combinedIndex;
                }
            }
        }
        return combinedDataset;
    }

    public static int toRowMajorIndex(String well, int ncolumns) {
        well = PlateUtil.checkWellFormat(well);
        int row = PlateUtil.convertWellRowToInt(String.valueOf(well.charAt(0)));
        int column = ParserHelper.parseInt(well.substring(1)) - 1;
        return row * ncolumns + column;
    }

    public static Dataset toWellContents(List<Dataset> datasets, Map<String, AbstractSampleInfoFile> fileToSampleInfoFile, String[] headersToPlaceOnColumn, String[] headersToPlaceOnRow, String name) throws IOException {
        int i;
        int index;
        String[] array;
        int j;
        HashSet<AbstractSampleInfoFile> set = new HashSet<AbstractSampleInfoFile>(fileToSampleInfoFile.values());
        Map<Identifier<String>, Integer> columnIdToIndex = PlateUtil.getAllValues(set, headersToPlaceOnColumn);
        Map<Identifier<String>, Integer> rowIdToIndex = PlateUtil.getAllValues(set, headersToPlaceOnRow);
        RowMajorArray2DDataset combinedDataset = new RowMajorArray2DDataset(name, rowIdToIndex.size(), columnIdToIndex.size());
        combinedDataset.addSeries("Source", FilePlateWellValueList.class);
        DatasetUtil.fill(combinedDataset, Float.NaN);
        int length = headersToPlaceOnColumn.length;
        for (j = 0; j < length; ++j) {
            MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), headersToPlaceOnColumn[j], String.class);
        }
        length = headersToPlaceOnRow.length;
        for (j = 0; j < length; ++j) {
            MetadataUtil.addRowVector(combinedDataset.getRowMetadata(), headersToPlaceOnRow[j], String.class);
        }
        for (Identifier<String> id : columnIdToIndex.keySet()) {
            array = id.getArray();
            index = columnIdToIndex.get(id);
            for (i = 0; i < array.length; ++i) {
                combinedDataset.getColumnMetadata().setValue(index, i, (Object)array[i]);
            }
        }
        for (Identifier<String> id : rowIdToIndex.keySet()) {
            array = id.getArray();
            index = rowIdToIndex.get(id);
            for (i = 0; i < array.length; ++i) {
                combinedDataset.getRowMetadata().setValue(index, i, (Object)array[i]);
            }
        }
        for (Dataset d : datasets) {
            String plate = d.getName();
            String file = (String)d.getProperty("File");
            AbstractSampleInfoFile sampleInfoFile = fileToSampleInfoFile.get(file);
            String[] rowKeys = new String[headersToPlaceOnRow.length];
            String[] columKeys = new String[headersToPlaceOnColumn.length];
            int rows = d.getRowCount();
            for (int i2 = 0; i2 < rows; ++i2) {
                int cols = d.getColumnCount();
                for (int j2 = 0; j2 < cols; ++j2) {
                    int datasetColumnIndex;
                    int k;
                    String well = PlateUtil.getWell(i2, j2);
                    well = PlateUtil.checkWellFormat(well);
                    int sampleInfoFileRowIndex = sampleInfoFile.idToRowIndex(new Identifier<Object>(plate, well));
                    if (sampleInfoFileRowIndex == -1) {
                        System.err.println("No info found for plate " + plate + " and well " + well + ".");
                        continue;
                    }
                    int nkeys = rowKeys.length;
                    for (k = 0; k < nkeys; ++k) {
                        rowKeys[k] = sampleInfoFile.getValue(sampleInfoFileRowIndex, headersToPlaceOnRow[k]);
                    }
                    nkeys = columKeys.length;
                    for (k = 0; k < nkeys; ++k) {
                        columKeys[k] = sampleInfoFile.getValue(sampleInfoFileRowIndex, headersToPlaceOnColumn[k]);
                    }
                    int datasetRowIndex = rowIdToIndex.get(new Identifier<String>(rowKeys));
                    FilePlateWellValueList sourceList = (FilePlateWellValueList)combinedDataset.getObjectValue(datasetRowIndex, datasetColumnIndex = columnIdToIndex.get(new Identifier<String>(columKeys)).intValue(), 0);
                    if (sourceList == null) {
                        sourceList = new FilePlateWellValueList();
                        combinedDataset.setObjectValue(datasetRowIndex, datasetColumnIndex, sourceList, 0);
                    }
                    float value = d.getValue(i2, j2);
                    sourceList.add(new FilePlateWellValue(file, plate, well, value));
                }
            }
        }
        int rows = combinedDataset.getRowCount();
        for (int i3 = 0; i3 < rows; ++i3) {
            int cols = combinedDataset.getColumnCount();
            for (int j3 = 0; j3 < cols; ++j3) {
                FilePlateWellValueList sourceList = (FilePlateWellValueList)combinedDataset.getObjectValue(i3, j3, 0);
                if (sourceList == null) continue;
                TFloatArrayList list = new TFloatArrayList();
                int size = sourceList.size();
                for (int k = 0; k < size; ++k) {
                    float val = sourceList.getValue(k);
                    if (Float.isNaN(val)) continue;
                    list.add(val);
                }
                float median = FloatListStatUtils.median(new TroveFloatList(list));
                combinedDataset.setValue(i3, j3, median);
            }
        }
        return combinedDataset;
    }

    private static List<String> addStringProperties(Dataset dataset, Dataset combinedDataset) {
        Collection<Object> keys = dataset.getPropertyKeys();
        ArrayList<String> properties = new ArrayList<String>();
        for (Object key : keys) {
            Object value;
            if (!(key instanceof String) || !((value = dataset.getProperty(key)) instanceof String)) continue;
            MetadataUtil.addRowVector(combinedDataset.getColumnMetadata(), (String)key, String.class);
            properties.add((String)key);
        }
        return properties;
    }

    private static Map<Identifier<String>, Integer> getAllValues(Collection<AbstractSampleInfoFile> sampleInfoFiles, String[] headers) {
        if (headers == null) {
            throw new NullPointerException("Header are null.");
        }
        HashMap<Identifier<String>, Integer> map = new HashMap<Identifier<String>, Integer>();
        for (AbstractSampleInfoFile sampleInfoFile : sampleInfoFiles) {
            int i;
            int[] columnIndices = new int[headers.length];
            for (i = 0; i < columnIndices.length; ++i) {
                columnIndices[i] = sampleInfoFile.getColumnIndex(headers[i]);
                if (columnIndices[i] != -1) continue;
                System.err.println(headers[i] + " not found in sample info file.");
            }
            int rows = sampleInfoFile.getRowCount();
            for (i = 0; i < rows; ++i) {
                String[] keys = new String[headers.length];
                int cols = headers.length;
                for (int j = 0; j < cols; ++j) {
                    keys[j] = sampleInfoFile.getValue(i, columnIndices[j]);
                }
                map.put(new Identifier<String>(keys), null);
            }
        }
        int i = 0;
        for (Identifier val : map.keySet()) {
            map.put(val, i++);
        }
        return map;
    }

    static {
        ROWS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'};
        CHAR_TO_ROW_INDEX = new LinkedHashMap<String, Integer>();
        CHAR_TO_ROW_INDEX.put("A", 0);
        CHAR_TO_ROW_INDEX.put("B", 1);
        CHAR_TO_ROW_INDEX.put("C", 2);
        CHAR_TO_ROW_INDEX.put("D", 3);
        CHAR_TO_ROW_INDEX.put("E", 4);
        CHAR_TO_ROW_INDEX.put("F", 5);
        CHAR_TO_ROW_INDEX.put("G", 6);
        CHAR_TO_ROW_INDEX.put("H", 7);
        CHAR_TO_ROW_INDEX.put("I", 8);
        CHAR_TO_ROW_INDEX.put("J", 9);
        CHAR_TO_ROW_INDEX.put("K", 10);
        CHAR_TO_ROW_INDEX.put("L", 11);
        CHAR_TO_ROW_INDEX.put("M", 12);
        CHAR_TO_ROW_INDEX.put("N", 13);
        CHAR_TO_ROW_INDEX.put("O", 14);
        CHAR_TO_ROW_INDEX.put("P", 15);
        ROW_INDEX_TO_CHAR = new LinkedHashMap<Integer, Character>();
        ROW_INDEX_TO_CHAR.put(0, Character.valueOf('A'));
        ROW_INDEX_TO_CHAR.put(1, Character.valueOf('B'));
        ROW_INDEX_TO_CHAR.put(2, Character.valueOf('C'));
        ROW_INDEX_TO_CHAR.put(3, Character.valueOf('D'));
        ROW_INDEX_TO_CHAR.put(4, Character.valueOf('E'));
        ROW_INDEX_TO_CHAR.put(5, Character.valueOf('F'));
        ROW_INDEX_TO_CHAR.put(6, Character.valueOf('G'));
        ROW_INDEX_TO_CHAR.put(7, Character.valueOf('H'));
        ROW_INDEX_TO_CHAR.put(8, Character.valueOf('I'));
        ROW_INDEX_TO_CHAR.put(9, Character.valueOf('J'));
        ROW_INDEX_TO_CHAR.put(10, Character.valueOf('K'));
        ROW_INDEX_TO_CHAR.put(11, Character.valueOf('L'));
        ROW_INDEX_TO_CHAR.put(12, Character.valueOf('M'));
        ROW_INDEX_TO_CHAR.put(13, Character.valueOf('N'));
        ROW_INDEX_TO_CHAR.put(14, Character.valueOf('O'));
        ROW_INDEX_TO_CHAR.put(15, Character.valueOf('P'));
    }
}

