/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.broadinstitute.genee.io.util.DelimWriter;
import org.broadinstitute.genee.io.util.Formatter;

public class TabDelimWriter
implements DelimWriter {
    private PrintWriter pw;

    @Override
    public void close() throws IOException {
        this.pw.close();
    }

    @Override
    public void init(File file) throws IOException {
        if (!file.getName().endsWith(".tsv")) {
            file = new File(file.getParentFile(), file.getName() + ".tsv");
        }
        this.pw = new PrintWriter(file);
    }

    @Override
    public void nextColumn() {
        this.pw.print("\t");
    }

    @Override
    public void nextRow() {
        this.pw.println();
    }

    @Override
    public void print(String text) {
        this.pw.print(text);
    }

    @Override
    public void print(int value) {
        this.pw.print(value);
    }

    @Override
    public void print(Object value) {
        this.pw.print(Formatter.toString(value));
    }
}

