/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.UserUtil;

public class TrackerUtil {
    private static boolean allowUsageStats;
    private static JGoogleAnalyticsTracker tracker;
    private static final String USAGE_STATS_PREF_KEY = "usage.stats";

    private TrackerUtil() {
    }

    public static boolean isAllowUsageStats() {
        return allowUsageStats;
    }

    public static void setAllowUsageStats(boolean b) {
        allowUsageStats = b;
        Preferences p = Preferences.userNodeForPackage(Application.class);
        p.putBoolean(USAGE_STATS_PREF_KEY, b);
        try {
            p.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void trackEvent(String username, String name) {
        if (Application.getVersion().isLatest()) {
            return;
        }
        TrackerUtil.getTracker().trackEvent(name, name, username);
    }

    public static void trackPageView(String name) {
        TrackerUtil.logEvent(name);
    }

    public static void logEvent(String name) {
        if (Application.getVersion().isLatest()) {
            return;
        }
        if (!allowUsageStats) {
            return;
        }
        if (name.endsWith("\u2026")) {
            name = name.substring(0, name.length() - "\u2026".length());
        }
        try {
            String username = UserUtil.getEmail();
            TrackerUtil.trackEvent(username, name);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static JGoogleAnalyticsTracker getTracker() {
        if (tracker == null) {
            JGoogleAnalyticsTracker.setProxy((String)System.getenv("http_proxy"));
            AnalyticsConfigData config = new AnalyticsConfigData("UA-12527282-2");
            tracker = new JGoogleAnalyticsTracker(config, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        }
        return tracker;
    }

    static {
        try {
            allowUsageStats = Preferences.userNodeForPackage(Application.class).getBoolean(USAGE_STATS_PREF_KEY, true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

