/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.data;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LuminexPlateRaw {
    private String plateName;
    private List<float[]> pcrOnly;
    private float[][] rawData;
    private Map<String, float[]> stats = new HashMap<String, float[]>();
    private String[] cellLines;
    private int[] beadNumber;
    private float[] concentrations;
    private String[] drugs;
    private Map<String, Color> drugToColor;
    private Map<String, Color> cellLineToColor;
    private String source;
    private List<float[]> beadsOnly;

    public LuminexPlateRaw(LuminexPlateRaw plate) {
        this.rawData = new float[plate.getDataArray().length][];
        for (int i = 0; i < plate.getDataArray().length; ++i) {
            this.rawData[i] = (float[])plate.getDataArray()[i].clone();
        }
        this.plateName = plate.plateName;
        this.beadsOnly = plate.beadsOnly;
        this.pcrOnly = plate.pcrOnly;
        this.stats = plate.stats;
        this.cellLines = plate.cellLines;
        this.beadNumber = plate.beadNumber;
        this.concentrations = plate.concentrations;
        this.drugs = plate.drugs;
        this.source = plate.source;
        this.drugToColor = plate.drugToColor;
        this.cellLineToColor = plate.cellLineToColor;
    }

    public LuminexPlateRaw(String plate, String source, List<float[]> beadsOnly, List<float[]> pcrOnly, String[] luaTag, int[] beadNumber, float[][] data, String[] drugs, float[] concentrations, Map<String, Color> drugToColor, Map<String, Color> cellLineToColor) {
        this.drugToColor = drugToColor;
        this.cellLineToColor = cellLineToColor;
        this.source = source;
        this.cellLines = luaTag;
        this.beadNumber = beadNumber;
        this.beadsOnly = beadsOnly;
        this.pcrOnly = pcrOnly;
        this.rawData = data;
        this.drugs = drugs;
        this.concentrations = concentrations;
        this.plateName = plate;
        if (luaTag.length != beadNumber.length) {
            throw new IllegalArgumentException("LUA Tag:" + luaTag.length + " Bead number: " + beadNumber.length);
        }
    }

    public List<float[]> getBeadsOnly() {
        return this.beadsOnly;
    }

    public String[] getCellLines() {
        return this.cellLines;
    }

    public int getColumnCount() {
        return this.rawData[0].length;
    }

    public float[] getConcentrations() {
        return this.concentrations;
    }

    public float[][] getDataArray() {
        return this.rawData;
    }

    public String[] getDrugs() {
        return this.drugs;
    }

    public List<float[]> getPcrOnly() {
        return this.pcrOnly;
    }

    public String getPlateName() {
        return this.plateName;
    }

    public int getRowCount() {
        return this.rawData.length;
    }

    public float[] getStat(String key) {
        return this.stats.get(key);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.plateName);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        int size = this.getRowCount();
        for (int i = 0; i < size; ++i) {
            buf.append("\n");
            buf.append(this.drugs[i]);
            buf.append("\t");
            buf.append(this.concentrations[i]);
            for (int j = 0; j < this.getColumnCount(); ++j) {
                buf.append("\t");
                buf.append(nf.format(this.rawData[i][j]));
            }
        }
        return buf.toString();
    }
}

