/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.luminex.ui.LXBViewer;

public class LXBInputAction
extends AbstractAction {
    public LXBInputAction() {
        super("LXB Histogram Viewer\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final GENEEWindow dialog = Application.createDialog("Select LXB File(s)");
        final FileInputParameter fileInputPanel = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY);
        JPanel dialogPanel = new JPanel((LayoutManager)new FormLayout("pref", "pref, pref"));
        CellConstraints cc = new CellConstraints();
        final JLabel label = new JLabel("Luminex LXB Files Directory");
        JPanel topPanel = new JPanel();
        topPanel.add(label);
        topPanel.add(fileInputPanel);
        final JRadioButton selectDirBtn = new JRadioButton("Select Directory", true);
        JRadioButton selectZipBtn = new JRadioButton("Select Zip File", false);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == selectDirBtn) {
                    fileInputPanel.setMode(FileInputParameter.OPEN_DIRECTORY);
                    label.setText("Luminex LXB Files Directory");
                } else {
                    fileInputPanel.setMode(FileInputParameter.OPEN_FILE);
                    label.setText("Zip File of LXB File(s)");
                }
            }
        };
        selectDirBtn.addActionListener(l);
        selectZipBtn.addActionListener(l);
        ButtonGroup bg = new ButtonGroup();
        bg.add(selectDirBtn);
        bg.add(selectZipBtn);
        JPanel btnPanel = new JPanel();
        btnPanel.add(selectDirBtn);
        btnPanel.add(selectZipBtn);
        dialogPanel.add((Component)topPanel, cc.xy(1, 1));
        dialogPanel.add((Component)btnPanel, cc.xy(1, 2));
        dialog.getContentPane().add(dialogPanel);
        ActionListener okActionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean inputIsDir = selectDirBtn.isSelected();
                ArrayList<String> lxbs = new ArrayList<String>();
                String fileInputText = fileInputPanel.getText();
                dialog.setVisible(false);
                if (inputIsDir) {
                    File[] lxbFiles;
                    for (File lxbFile : lxbFiles = new File(fileInputText).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith(".lxb");
                        }
                    })) {
                        lxbs.add(lxbFile.getName());
                    }
                } else {
                    ZipFile zipFile = null;
                    try {
                        zipFile = new ZipFile(fileInputText);
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            lxbs.add(entries.nextElement().getName());
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException e1) {}
                    }
                }
                Collections.sort(lxbs);
                new LXBViewer(!inputIsDir, fileInputText, lxbs);
            }
        };
        dialog.getContentPane().add((Component)UIUtil.buildOKCancelBar(dialog, okActionListener), "South");
        dialog.pack();
        dialog.setVisible(true);
    }
}

