/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipFile;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.chart.DefaultHistogramChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.HistogramOptionsPanel;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FilterListPanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.GridFormLayout;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.matrix.Dataset;

public class LXBViewer {
    private int numberOfBins = 10;
    private boolean logScale = false;
    private float histogramMin = Float.NaN;
    private float histogramMax = Float.NaN;
    private String columnName = "RP1";
    private FilterListPanel geneSelector;
    private FilterListPanel sampleSelector = new FilterListPanel(String.CASE_INSENSITIVE_ORDER);
    private GENEEWindow window;
    private JPanel selectorPanel;
    private JPanel northPanel;
    private JPanel chartsPanel;
    private boolean zipFile;
    private String directory;

    public LXBViewer(boolean zipFile, String directory, List<String> lxbs) {
        this.zipFile = zipFile;
        this.directory = directory;
        for (String lxb : lxbs) {
            this.sampleSelector.addElement(lxb);
        }
        this.geneSelector = new FilterListPanel(String.CASE_INSENSITIVE_ORDER);
        try {
            InputStreamWrapper w = this.getInputStream(lxbs.get(0));
            LinkedHashSet geneNames = new LinkedHashSet();
            w.close();
            for (String name : geneNames) {
                this.geneSelector.addElement(name);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.chartsPanel = new JPanel();
        this.chartsPanel.setBackground(Color.WHITE);
        ListSelectionListener l = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LXBViewer.this.updatePlot();
            }
        };
        this.sampleSelector.addListSelectionListener(l);
        this.geneSelector.addListSelectionListener(l);
        this.selectorPanel = new JPanel();
        this.selectorPanel.add(this.sampleSelector);
        this.selectorPanel.add(this.geneSelector);
        this.northPanel = new JPanel((LayoutManager)new FormLayout("pref", "pref, pref, pref"));
        CellConstraints cc = new CellConstraints();
        this.northPanel.add((Component)this.selectorPanel, cc.xy(1, 1));
        FormBuilder formBuilder = new FormBuilder();
        HistogramOptionsPanel optionsPanel = new HistogramOptionsPanel(10, formBuilder, 1000){

            @Override
            public void setLogScale(boolean b) {
                LXBViewer.this.logScale = b;
                LXBViewer.this.updatePlot();
            }

            @Override
            public void setNumberOfBins(int bins) {
                LXBViewer.this.numberOfBins = bins;
                LXBViewer.this.updatePlot();
            }

            @Override
            public void setMax(float max) {
                LXBViewer.this.histogramMax = max;
                LXBViewer.this.updatePlot();
            }

            @Override
            public void setMin(float min) {
                LXBViewer.this.histogramMin = min;
                LXBViewer.this.updatePlot();
            }
        };
        formBuilder.nextSmallRow();
        formBuilder.addLabel("LXB Field:");
        TimerTextField lxbField = new TimerTextField(this.columnName, 1000){

            @Override
            public void update() {
                LXBViewer.this.columnName = this.getText().trim();
                LXBViewer.this.updatePlot();
            }
        };
        formBuilder.add(lxbField);
        this.northPanel.add((Component)optionsPanel.getFormBuilder().getPanel(), cc.xy(1, 2));
        this.window = Application.createViewWindow("LXB - " + new File(directory).getName());
        this.window.getContentPane().add((Component)this.northPanel, "North");
        this.window.getContentPane().add(new JScrollPane(this.chartsPanel));
        this.window.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.window.setSize(screenSize.width - 10, screenSize.height - 80);
        this.window.setVisible(true);
    }

    private InputStreamWrapper getInputStream(String lxb) throws IOException {
        InputStreamWrapper w = new InputStreamWrapper();
        if (!this.zipFile) {
            w.is = new FileInputStream(new File(this.directory, lxb));
        } else {
            ZipFile zipFile = new ZipFile(this.directory);
            w.is = zipFile.getInputStream(zipFile.getEntry(lxb));
            w.zipFile = zipFile;
        }
        return w;
    }

    private void updatePlot() {
        LinkedHashSet<Object> selectedSamples = new LinkedHashSet<Object>(Arrays.asList(this.sampleSelector.getCheckBoxListSelectedValues()));
        Object[] selectedValues = this.geneSelector.getCheckBoxListSelectedValues();
        HashSet<String> selectedGenes = new HashSet<String>();
        for (Object obj : selectedValues) {
            selectedGenes.add((String)obj);
        }
        if (selectedSamples.size() == 0 || selectedGenes.size() == 0) {
            GridFormLayout.layoutGrid(this.chartsPanel, Collections.EMPTY_LIST, 3, false);
            this.chartsPanel.revalidate();
            this.chartsPanel.repaint();
            return;
        }
        new BackgroundTask<List<Dataset>>("Loading LXB Files"){

            @Override
            protected List<Dataset> doInBackground() throws Exception {
                ArrayList<Dataset> datasets = new ArrayList<Dataset>();
                if (datasets.size() == 0) {
                    throw new RuntimeException("No LXB files found.");
                }
                return datasets;
            }

            @Override
            protected void succeeded(List<Dataset> datasets) {
                float xmin = Float.MAX_VALUE;
                float xmax = -3.4028235E38f;
                float ymin = Float.MAX_VALUE;
                float ymax = -3.4028235E38f;
                float tmpMin = LXBViewer.this.histogramMin;
                float tmpMax = LXBViewer.this.histogramMax;
                if (LXBViewer.this.logScale && !Float.isNaN(tmpMin)) {
                    tmpMin = (float)Math.pow(2.0, tmpMin);
                }
                if (LXBViewer.this.logScale && !Float.isNaN(tmpMax)) {
                    tmpMax = (float)Math.pow(2.0, tmpMax);
                }
                for (Dataset dataset : datasets) {
                    DefaultXYChartDataset chartDataset = new DefaultXYChartDataset(DefaultHistogramChartSeries.createInstance(dataset, LXBViewer.this.numberOfBins, tmpMin, tmpMax));
                    xmin = Math.min(xmin, chartDataset.getXMin());
                    ymin = Math.min(ymin, chartDataset.getYMin());
                    xmax = Math.max(xmax, chartDataset.getXMax());
                    ymax = Math.max(ymax, chartDataset.getYMax());
                }
                ArrayList panels = new ArrayList();
                GridFormLayout.layoutGrid(LXBViewer.this.chartsPanel, panels, 3, false);
                LXBViewer.this.chartsPanel.revalidate();
                LXBViewer.this.chartsPanel.repaint();
            }
        }.execute();
    }

    private static class InputStreamWrapper {
        InputStream is;
        ZipFile zipFile;

        private InputStreamWrapper() {
        }

        public void close() throws IOException {
            this.is.close();
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
    }
}

