/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.rnai;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.luminex.AbstractLuminexProcessor;
import org.broadinstitute.genee.luminex.CollapsedToolTipProvider;
import org.broadinstitute.genee.luminex.LuminexImporter;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.stat.CollapseDataset;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.math.stat.function.Sum;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowArrayFloatList;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.VectorUtil;

public class RNAiProcessor
extends AbstractLuminexProcessor {
    float ceiling = Float.NaN;
    boolean customScaleTo;
    List<String[]> customScaleToValues;
    List<Integer> customScaleToPuroStatus;
    private String hairpinMetatadataFieldName;
    float floor = Float.NaN;
    float puroPlusDividedByPuroMinusCensorValue = Float.NaN;
    boolean scaleToWellSignalFraction;
    private float lowSignalCensorValue = Float.NaN;
    private String lowSignalHairpin = null;
    private int lowSignalHairpinPuroStatus;

    public void process() {
        new BackgroundTask<GENEEFolderNode>("PRISM"){

            @Override
            protected GENEEFolderNode doInBackground() throws Exception {
                String text;
                ArrayList<ProjectGENEEResultTreeNode> results = new ArrayList<ProjectGENEEResultTreeNode>();
                History history = new History("PRISM");
                if (RNAiProcessor.this.subtractBackground) {
                    history.add(RNAiProcessor.this.subtractBackgroundFunction.toString(), null);
                }
                if (RNAiProcessor.this.scaleToWellSignalFraction) {
                    history.add("Scaled to well signal fraction", null);
                }
                if (!Float.isNaN(RNAiProcessor.this.lowSignalCensorValue)) {
                    text = "Censor points for cell line on plate if " + RNAiProcessor.this.lowSignalHairpin + " minus background is less than " + RNAiProcessor.this.lowSignalCensorValue;
                    history.add(text, null);
                }
                if (!Float.isNaN(RNAiProcessor.this.puroPlusDividedByPuroMinusCensorValue)) {
                    text = "Censor hairpins whose puro+ score divided by puro- score is less than " + RNAiProcessor.this.puroPlusDividedByPuroMinusCensorValue;
                    history.add(text, null);
                }
                if (RNAiProcessor.this.customScaleTo) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < RNAiProcessor.this.customScaleToValues.size(); ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        String[] fields = RNAiProcessor.this.customScaleToValues.get(i);
                        buf.append("[");
                        for (int j = 0; j < fields.length; ++j) {
                            if (j > 0) {
                                buf.append(", ");
                            }
                            buf.append(fields[j]);
                        }
                        buf.append("]");
                    }
                    String text2 = "Scaled to " + buf + RNAiProcessor.this.customScaleToPuroStatus;
                    history.add(text2, null);
                }
                ArrayList<RowMajorArray2DDataset> datasetProcessingSteps = new ArrayList<RowMajorArray2DDataset>();
                datasetProcessingSteps.add(DatasetUtil.deepCopy(RNAiProcessor.this.dataset));
                if (RNAiProcessor.this.subtractBackground) {
                    Dataset backgroundDataset = RNAiProcessor.this.subtractBackgroundFunction.execute();
                    RNAiProcessor.this.createNode(results, backgroundDataset, "Background", history);
                    datasetProcessingSteps.add((RowMajorArray2DDataset)RNAiProcessor.this.createNode(results, RNAiProcessor.this.dataset, "Subtract Background", datasetProcessingSteps, history).getProject().getOriginalDataset());
                }
                if (RNAiProcessor.this.scaleToWellSignalFraction) {
                    RNAiProcessor.this.scaleToWellSignalFraction();
                    datasetProcessingSteps.add((RowMajorArray2DDataset)RNAiProcessor.this.createNode(results, RNAiProcessor.this.dataset, "Scale To Well Signal", datasetProcessingSteps, history).getProject().getOriginalDataset());
                }
                String collapseString = "Collapsed replicates using " + RNAiProcessor.this.collapseReplicatesMethod.toString();
                history.add(collapseString, null);
                if (RNAiProcessor.this.collapseReplicatesMethod == CollapseMethodOption.TRIMMED_MEAN) {
                    collapseString = collapseString + " s=" + RNAiProcessor.this.collapseReplicatesTrimmedMeanS + ", l=" + RNAiProcessor.this.collapseReplicatesTrimmedMeanS;
                }
                HashMap<Object, TIntArrayList> plateToRowIndices = LuminexImporter.createPlateNameToRowIndices(RNAiProcessor.this.plateMetadataName, RNAiProcessor.this.dataset);
                RowMajorArray2DDataset datasetsForPuroPlusPuroMinusPlot = DatasetUtil.deepCopy(RNAiProcessor.this.dataset);
                if (!Float.isNaN(RNAiProcessor.this.lowSignalCensorValue) && RNAiProcessor.this.lowSignalHairpin != null) {
                    for (int plateIdx = 0; plateIdx < RNAiProcessor.this.plateNames.length; ++plateIdx) {
                        int[] noHairpinIndices = new int[]{RNAiProcessor.getIndex(RNAiProcessor.this.dataset, RNAiProcessor.this.plateNames[plateIdx], plateToRowIndices, RNAiProcessor.this.lowSignalHairpin, RNAiProcessor.this.lowSignalHairpinPuroStatus, RNAiProcessor.this.concentrationMetadataNames[0])};
                        int cols = RNAiProcessor.this.dataset.getColumnCount();
                        for (int j = 0; j < cols; ++j) {
                            boolean censor = false;
                            TFloatArrayList bin = new TFloatArrayList();
                            for (int i = 0; i < noHairpinIndices.length; ++i) {
                                float puroMinus = RNAiProcessor.this.dataset.getValue(noHairpinIndices[i], j);
                                if (Float.isNaN(puroMinus)) continue;
                                bin.add(puroMinus);
                            }
                            float mean = FloatListStatUtils.mean(new TroveFloatList(bin));
                            if (mean < RNAiProcessor.this.lowSignalCensorValue) {
                                censor = true;
                            }
                            if (!censor) continue;
                            System.out.println("Censored " + RNAiProcessor.this.dataset.getColumnMetadata().get(0).getValue(j) + " in plate " + RNAiProcessor.this.plateNames[plateIdx]);
                            TIntArrayList rowIndices = (TIntArrayList)plateToRowIndices.get(RNAiProcessor.this.plateNames[plateIdx]);
                            int rows = rowIndices.size();
                            for (int i = 0; i < rows; ++i) {
                                int index = rowIndices.getQuick(i);
                                RNAiProcessor.this.dataset.setValue(index, j, Float.NaN);
                            }
                        }
                    }
                    RNAiProcessor.this.createNode(results, RNAiProcessor.this.dataset, "No signal censoring", history);
                }
                Map<Identifier, TIntArrayList> replicateToIndicesForCollapsing = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(RNAiProcessor.this.dataset.getRowMetadata(), RNAiProcessor.this.namesForReplicates));
                if (!Float.isNaN(RNAiProcessor.this.puroPlusDividedByPuroMinusCensorValue)) {
                    for (int plateIdx = 0; plateIdx < RNAiProcessor.this.plateNames.length; ++plateIdx) {
                        Object plate = RNAiProcessor.this.plateNames[plateIdx];
                        Map<Object, int[]> hairpinToIndicesMap = RNAiProcessor.buildHairpinToIndicesMap(RNAiProcessor.this.dataset, plateToRowIndices, plate, RNAiProcessor.this.concentrationMetadataNames[0]);
                        TIntArrayList rowIndices = (TIntArrayList)plateToRowIndices.get(plate);
                        int rows = rowIndices.size();
                        for (int i = 0; i < rows; ++i) {
                            int index = rowIndices.getQuick(i);
                            Object hairpin = RNAiProcessor.this.dataset.getRowMetadata().get(RNAiProcessor.this.hairpinMetatadataFieldName).getValue(index);
                            int[] indices = hairpinToIndicesMap.get(hairpin);
                            if (indices == null) continue;
                            int cols = RNAiProcessor.this.dataset.getColumnCount();
                            for (int j = 0; j < cols; ++j) {
                                float puroPlusToMinusRatio = RNAiProcessor.this.dataset.getValue(indices[1], j) / RNAiProcessor.this.dataset.getValue(indices[0], j);
                                if (!(puroPlusToMinusRatio < RNAiProcessor.this.puroPlusDividedByPuroMinusCensorValue)) continue;
                                RNAiProcessor.this.dataset.setValue(indices[0], j, Float.NaN);
                                RNAiProcessor.this.dataset.setValue(indices[1], j, Float.NaN);
                            }
                        }
                    }
                    RNAiProcessor.this.createNode(results, RNAiProcessor.this.dataset, "Censored shRNAs puro+/puro-", history);
                }
                if (RNAiProcessor.this.customScaleTo) {
                    for (int i = 0; i < RNAiProcessor.this.plateNames.length; ++i) {
                        RNAiProcessor.this.scaleRNAi(RNAiProcessor.this.dataset, plateToRowIndices, RNAiProcessor.this.plateNames[i], RNAiProcessor.this.customScaleToValues.get(i), RNAiProcessor.this.customScaleToPuroStatus.get(i));
                    }
                    RNAiProcessor.this.createNode(results, RNAiProcessor.this.dataset, "Scaled to custom list", history);
                }
                if (!Float.isNaN(RNAiProcessor.this.ceiling)) {
                    int rows = RNAiProcessor.this.dataset.getRowCount();
                    for (int i = 0; i < rows; ++i) {
                        int cols = RNAiProcessor.this.dataset.getColumnCount();
                        for (int j = 0; j < cols; ++j) {
                            if (!(RNAiProcessor.this.dataset.getValue(i, j) > RNAiProcessor.this.ceiling)) continue;
                            RNAiProcessor.this.dataset.setValue(i, j, RNAiProcessor.this.ceiling);
                        }
                    }
                }
                if (!Float.isNaN(RNAiProcessor.this.floor)) {
                    int rows = RNAiProcessor.this.dataset.getRowCount();
                    for (int i = 0; i < rows; ++i) {
                        int cols = RNAiProcessor.this.dataset.getColumnCount();
                        for (int j = 0; j < cols; ++j) {
                            if (!(RNAiProcessor.this.dataset.getValue(i, j) < RNAiProcessor.this.floor)) continue;
                            RNAiProcessor.this.dataset.setValue(i, j, RNAiProcessor.this.floor);
                        }
                    }
                }
                CollapseDataset collapseReplicates = new CollapseDataset();
                collapseReplicates.setCollapseMethod(RNAiProcessor.this.collapseReplicatesMethod);
                collapseReplicates.setTrimmedMeanL(RNAiProcessor.this.collapseReplicatesTrimmedMeanL);
                collapseReplicates.setTrimmedMeanS(RNAiProcessor.this.collapseReplicatesTrimmedMeanS);
                collapseReplicates.setCollapseTo(RNAiProcessor.this.namesForReplicates);
                collapseReplicates.setDataset(RNAiProcessor.this.dataset);
                Dataset collapsedDataset = collapseReplicates.execute();
                ProjectGENEEResultTreeNode collapsedNode = RNAiProcessor.this.createNode(results, collapsedDataset, "Collapse Replicates", history);
                Map<Identifier, TIntArrayList> collapseToFieldsToDatasetRowIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(RNAiProcessor.this.dataset.getRowMetadata(), RNAiProcessor.this.namesForReplicates));
                ((HeatMapPanel)collapsedNode.getDisplayInfo().getComponent()).setToolTipProvider(new CollapsedToolTipProvider(collapsedNode.getProject(), datasetProcessingSteps, collapseToFieldsToDatasetRowIndices, RNAiProcessor.this.namesForReplicates));
                RNAiResult result = new RNAiResult();
                ArrayList<Dataset> puroMinusDatasets = new ArrayList<Dataset>();
                ArrayList<Dataset> puroPlusDatasets = new ArrayList<Dataset>();
                result.datasetsForPuroPlusPuroMinusPlot = datasetsForPuroPlusPuroMinusPlot;
                ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(RNAiProcessor.this.namesForReplicates));
                tmp.remove(RNAiProcessor.this.concentrationMetadataNames[0]);
                String[] replicatesWithPuroStatusRemoved = tmp.toArray(new String[0]);
                Map<Identifier, TIntArrayList> replicateToIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(collapsedDataset.getRowMetadata(), replicatesWithPuroStatusRemoved));
                for (Identifier id : replicateToIndices.keySet()) {
                    TIntArrayList indices = replicateToIndices.get(id);
                    if (indices.size() != 2) {
                        System.out.println("Skipping " + id.get(0) + " size " + indices.size());
                        continue;
                    }
                    TIntArrayList puroMinusIndices = new TIntArrayList();
                    TIntArrayList puroPlusIndices = new TIntArrayList();
                    for (int k = 0; k < 2; ++k) {
                        int i = indices.get(k);
                        int puroStatus = ((Float)collapsedDataset.getRowMetadata().getValue(i, RNAiProcessor.this.concentrationMetadataNames[0])).intValue();
                        if (puroStatus == 0) {
                            puroMinusIndices.add(i);
                            continue;
                        }
                        if (puroStatus == 1) {
                            puroPlusIndices.add(i);
                            continue;
                        }
                        System.out.println("Control hairpin: " + collapsedDataset.getRowMetadata().get(0).getValue(i));
                    }
                    Dataset puroPlusDataset = DatasetUtil.sliceView(collapsedDataset, puroPlusIndices.toArray(), null);
                    Dataset puroMinusDataset = DatasetUtil.sliceView(collapsedDataset, puroMinusIndices.toArray(), null);
                    if (puroPlusDataset.getRowCount() != puroMinusDataset.getRowCount()) {
                        throw new RuntimeException("Number of rows in puro+ != puro-");
                    }
                    int rows = puroPlusDataset.getRowCount();
                    for (int i = 0; i < rows; ++i) {
                        if (puroPlusDataset.getRowMetadata().get(0).getValue(i).equals(puroMinusDataset.getRowMetadata().get(0).getValue(i))) continue;
                        throw new RuntimeException(puroPlusDataset.getRowMetadata().get(0).getValue(i) + "!=" + puroMinusDataset.getRowMetadata().get(0).getValue(i));
                    }
                    puroPlusDatasets.add(puroPlusDataset);
                    puroMinusDatasets.add(puroMinusDataset);
                }
                ComponentCustomizer cc = new ComponentCustomizer(){

                    @Override
                    public void customize(Component c) {
                        HeatMapPanel hmp = (HeatMapPanel)c;
                        HeatMapColorScheme cs = hmp.getColorScheme();
                        hmp.setDrawGrid(true);
                        cs.setGlobalMax(1.0f);
                        cs.setGlobalMin(0.0f);
                        cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE});
                    }

                    @Override
                    public boolean inherits() {
                        return false;
                    }
                };
                RowMajorArray2DDataset puroPlusDataset = DatasetUtil.combineRows(puroPlusDatasets.toArray(new Dataset[0]), "Puro+");
                puroPlusDataset.getRowMetadata().remove(puroPlusDataset.getRowMetadata().getColumnIndex(RNAiProcessor.this.concentrationMetadataNames[0]));
                DefaultProject puroPlusProject = new DefaultProject(puroPlusDataset);
                results.add(new ProjectGENEEResultTreeNode((Project)puroPlusProject, history, cc));
                RowMajorArray2DDataset puroMinusDataset = DatasetUtil.combineRows(puroMinusDatasets.toArray(new Dataset[0]), "Puro-");
                puroMinusDataset.getRowMetadata().remove(puroMinusDataset.getRowMetadata().getColumnIndex(RNAiProcessor.this.concentrationMetadataNames[0]));
                DefaultProject puroMinusProject = new DefaultProject(puroMinusDataset);
                results.add(new ProjectGENEEResultTreeNode((Project)puroMinusProject, history, cc));
                RowMajorArray2DDataset averagePuroPlusAndPuroMinus = DatasetUtil.deepCopy(puroMinusDataset);
                averagePuroPlusAndPuroMinus.setName("Average");
                int rows = averagePuroPlusAndPuroMinus.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    int cols = averagePuroPlusAndPuroMinus.getColumnCount();
                    for (int j = 0; j < cols; ++j) {
                        float plus = puroPlusDataset.getValue(i, j);
                        float minus = puroMinusDataset.getValue(i, j);
                        float average = (plus + minus) / 2.0f;
                        averagePuroPlusAndPuroMinus.setValue(i, j, average);
                    }
                }
                DefaultProject averageProject = new DefaultProject(averagePuroPlusAndPuroMinus);
                results.add(new ProjectGENEEResultTreeNode((Project)averageProject, history, cc));
                result.scaled = DatasetUtil.shallowCopy(collapsedDataset);
                return new GENEEFolderNode("PRISM", history, results.toArray(new MutableTreeNode[0]));
            }

            @Override
            protected void succeeded(GENEEFolderNode root) {
                Application.add(root);
            }
        }.execute();
    }

    public void setLowSignalFilterParameter(String lowSignalHairpin, float lowSignalCensorValue, int puroStatus) {
        this.lowSignalHairpin = lowSignalHairpin;
        this.lowSignalCensorValue = lowSignalCensorValue;
        this.lowSignalHairpinPuroStatus = puroStatus;
    }

    private ProjectGENEEResultTreeNode createNode(List<ProjectGENEEResultTreeNode> results, Dataset datasets, String name, History history) {
        return this.createNode(results, datasets, name, null, history);
    }

    private void scaleRNAi(RowMajorArray2DDataset dataset, Map<Object, TIntArrayList> collapsedPlateNameToRowIndices, Object plate, String[] scaleToValues, int puroStatus) {
        Map<Object, TIntArrayList> hairpinMap = RNAiProcessor.buildHairpinToIndicesMap(dataset, collapsedPlateNameToRowIndices, plate, puroStatus, this.hairpinMetatadataFieldName, this.concentrationMetadataNames[0]);
        TIntArrayList controlIndices = new TIntArrayList();
        for (int i = 0; i < scaleToValues.length; ++i) {
            String name = scaleToValues[i];
            TIntArrayList indices = hairpinMap.get(name);
            if (indices == null) {
                throw new RuntimeException(name + " not found.");
            }
            controlIndices.addAll((TIntCollection)indices);
        }
        float[] controlValues = new float[dataset.getColumnCount()];
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            TFloatArrayList bin = new TFloatArrayList();
            for (int i = 0; i < controlIndices.size(); ++i) {
                float controlValue = dataset.getValue(controlIndices.getQuick(i), j);
                if (Float.isNaN(controlValue)) continue;
                bin.add(controlValue);
            }
            controlValues[j] = FloatListStatUtils.median(new TroveFloatList(bin));
        }
        TIntArrayList rowIndices = collapsedPlateNameToRowIndices.get(plate);
        int rows = rowIndices.size();
        for (int i = 0; i < rows; ++i) {
            int index = rowIndices.getQuick(i);
            int cols2 = dataset.getColumnCount();
            for (int j = 0; j < cols2; ++j) {
                float controlValue = controlValues[j];
                if ((double)controlValue == 0.0) {
                    dataset.setValue(index, j, 0.0f);
                    continue;
                }
                float d = dataset.getValue(index, j);
                dataset.setValue(index, j, d /= controlValue);
            }
        }
    }

    private void scaleToWellSignalFraction() {
        Sum c = new Sum();
        RowArrayFloatList l = new RowArrayFloatList(this.dataset.getArray());
        float[][] data = this.dataset.getArray();
        int size = this.plateNames.length;
        for (int plateIdx = 0; plateIdx < size; ++plateIdx) {
            Object plate = this.plateNames[plateIdx];
            TIntArrayList rowIndices = (TIntArrayList)this.plateNameToRowIndices.get(plate);
            int rows = rowIndices.size();
            for (int i = 0; i < rows; ++i) {
                int j;
                int cols;
                int index = rowIndices.getQuick(i);
                l.setRowIndex(index);
                float sum = c.evaluate(l);
                if (sum != 0.0f) {
                    cols = this.dataset.getColumnCount();
                    for (j = 0; j < cols; ++j) {
                        data[index][j] = data[index][j] / sum;
                    }
                    continue;
                }
                System.out.println("Sum is zero for " + plateIdx + " row index " + index);
                cols = this.dataset.getColumnCount();
                for (j = 0; j < cols; ++j) {
                    data[index][j] = 0.0f;
                }
            }
        }
    }

    static Map<Object, int[]> buildHairpinToIndicesMap(Dataset dataset, Map<Object, TIntArrayList> collapsedPlateNameToRowIndices, Object plate, String concentrationMetadataName) {
        HashMap<Object, int[]> map = new HashMap<Object, int[]>();
        TIntArrayList rowIndices = plate != null ? collapsedPlateNameToRowIndices.get(plate) : null;
        int rows = plate != null ? rowIndices.size() : dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int index = plate != null ? rowIndices.getQuick(i) : i;
            Object hairpin = dataset.getRowMetadata().get(0).getValue(index);
            float conc = ((Float)dataset.getRowMetadata().getValue(index, concentrationMetadataName)).floatValue();
            if (conc != 0.0f && conc != 1.0f) continue;
            int[] puroStatus = (int[])map.get(hairpin);
            if (puroStatus == null) {
                puroStatus = new int[2];
                map.put(hairpin.toString(), puroStatus);
            }
            if (conc == 0.0f) {
                puroStatus[0] = index;
                continue;
            }
            if (conc != 1.0f) continue;
            puroStatus[1] = index;
        }
        return map;
    }

    private static Map<Object, TIntArrayList> buildHairpinToIndicesMap(Dataset dataset, Map<Object, TIntArrayList> collapsedPlateNameToRowIndices, Object plate, float puroStatusSelection, String hairpinMetadataName, String concentrationMetadataName) {
        HashMap<Object, TIntArrayList> map = new HashMap<Object, TIntArrayList>();
        TIntArrayList rowIndices = plate != null ? collapsedPlateNameToRowIndices.get(plate) : null;
        int rows = plate != null ? rowIndices.size() : dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int index = plate != null ? rowIndices.getQuick(i) : i;
            Object hairpin = dataset.getRowMetadata().get(hairpinMetadataName).getValue(index);
            float conc = ((Float)dataset.getRowMetadata().getValue(index, concentrationMetadataName)).floatValue();
            if (conc != puroStatusSelection) continue;
            TIntArrayList indices = (TIntArrayList)map.get(hairpin);
            if (indices == null) {
                indices = new TIntArrayList();
                map.put(hairpin.toString(), indices);
            }
            indices.add(index);
        }
        return map;
    }

    private static int getIndex(Dataset dataset, Object plate, Map<Object, TIntArrayList> plateToRowIndices, Object hairpin, int puroStatus, String concentrationMetadataName) {
        MetadataModel metadata = dataset.getRowMetadata();
        TIntArrayList rowIndices = plateToRowIndices.get(plate);
        int rows = rowIndices.size();
        for (int i = 0; i < rows; ++i) {
            Float conc;
            int index = rowIndices.getQuick(i);
            if (!hairpin.equals(dataset.getRowMetadata().get(0).getValue(index)) || (conc = (Float)metadata.getValue(index, concentrationMetadataName)).intValue() != puroStatus) continue;
            return index;
        }
        throw new RuntimeException(hairpin + " not found.");
    }

    public void setHairpinFieldName(String hairpinFieldName) {
        this.hairpinMetatadataFieldName = hairpinFieldName;
    }

    public static class RNAiResult {
        protected RowMajorArray2DDataset datasetsForPuroPlusPuroMinusPlot;
        protected Dataset scaled;
    }
}

