/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSampler;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import org.broadinstitute.genee.marker.permutation.Permuter;

public class BalancedRandomPermuter
implements Permuter {
    long[] values;
    int[] classZeroIndices;
    int[] classOneIndices;
    MersenneTwister random;

    public BalancedRandomPermuter(int[] classZeroIndices, int[] classOneIndices, int seed) {
        this.classZeroIndices = classZeroIndices;
        this.classOneIndices = classOneIndices;
        this.values = new long[classZeroIndices.length / 2];
        this.random = new MersenneTwister(seed);
    }

    @Override
    public int[] next() {
        int classOneIndex;
        int i;
        int[] newAssignments = new int[this.classZeroIndices.length * 2];
        RandomSampler.sample((long)this.values.length, (long)this.classZeroIndices.length, (int)this.values.length, (long)0L, (long[])this.values, (int)0, (RandomElement)this.random);
        for (i = 0; i < this.values.length; ++i) {
            classOneIndex = (int)this.values[i];
            newAssignments[this.classZeroIndices[classOneIndex]] = 1;
        }
        RandomSampler.sample((long)this.values.length, (long)this.classZeroIndices.length, (int)this.values.length, (long)0L, (long[])this.values, (int)0, (RandomElement)this.random);
        for (i = 0; i < this.values.length; ++i) {
            classOneIndex = (int)this.values[i];
            newAssignments[this.classOneIndices[classOneIndex]] = 1;
        }
        return newAssignments;
    }
}

