/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.marker.permutation.BalancedCompletePermuter;
import org.broadinstitute.genee.marker.permutation.BalancedRandomPermuter;
import org.broadinstitute.genee.marker.permutation.Permuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedCompletePermuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedRandomCovariatePermuter;
import org.broadinstitute.genee.marker.permutation.UnbalancedRandomPermuter;
import org.broadinstitute.genee.matrix.DefaultClassVector;

public class PermutationTest {
    static int seed = 4357;

    public static void main(String[] args) {
        PermutationTest.test5();
    }

    public static String toString(int[] a) {
        StringBuilder buf = new StringBuilder(a.length);
        for (int i = 0; i < a.length; ++i) {
            buf.append(a[i]);
        }
        return buf.toString();
    }

    static Map doTest(Permuter permuter, int runs) {
        HashMap map = new HashMap(){

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (String key : this.keySet()) {
                    String firstHalf = key.substring(0, key.length() / 2);
                    String secondHalf = key.substring(key.length() / 2, key.length());
                    Object value = this.get(key);
                    sb.append(firstHalf);
                    sb.append("\t");
                    sb.append(secondHalf);
                    sb.append("\t");
                    sb.append(value);
                    sb.append("\n");
                }
                return sb.toString();
            }
        };
        for (int i = 0; i < runs; ++i) {
            String p = PermutationTest.toString(permuter.next());
            Integer count = (Integer)map.get(p);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            map.put(p, count);
        }
        return map;
    }

    static void test1() {
        UnbalancedRandomPermuter permuter = new UnbalancedRandomPermuter(6, 3, seed);
        System.out.println(PermutationTest.doTest(permuter, 1000));
    }

    static void test2() {
        int[] classZeroIndices = new int[]{0, 1, 2, 3};
        int[] classOneIndices = new int[]{4, 5, 6, 7};
        BalancedRandomPermuter permuter = new BalancedRandomPermuter(classZeroIndices, classOneIndices, seed);
        System.out.println(PermutationTest.doTest(permuter, 1000));
    }

    static void test3() {
        int[] classZeroIndices = new int[]{0, 1, 2, 3};
        int[] classOneIndices = new int[]{4, 5, 6, 7};
        BalancedCompletePermuter permuter = new BalancedCompletePermuter(classZeroIndices, classOneIndices);
        int total = permuter.getTotal().intValue();
        System.out.println(PermutationTest.doTest(permuter, total));
    }

    static void test4() {
        UnbalancedCompletePermuter permuter = new UnbalancedCompletePermuter(6, 3);
        int total = permuter.getTotal().intValue();
        System.out.println(PermutationTest.doTest(permuter, total));
    }

    static void test5() {
        DefaultClassVector cv = new DefaultClassVector(new String[]{"0", "0", "0", "0", "0", "1", "1", "1", "1", "1"});
        DefaultClassVector covariate = new DefaultClassVector(new String[]{"0", "0", "2", "1", "1", "0", "1", "1", "1", "1"});
        UnbalancedRandomCovariatePermuter permuter = new UnbalancedRandomCovariatePermuter(cv, covariate, 123723423);
        System.out.println(PermutationTest.doTest(permuter, 100));
    }
}

