/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import org.broadinstitute.genee.stats.Sorting;

public class Fdr {
    private Fdr() {
    }

    public static float[] fdr(float[] nominalPValues) {
        int i;
        int i2;
        int size = nominalPValues.length;
        float[] fdr = new float[size];
        int[] pValueIndices = Sorting.index(nominalPValues, true);
        int[] ranks = Sorting.rank(pValueIndices);
        for (i2 = pValueIndices.length - 1; i2 > 0; --i2) {
            float bigPValue = nominalPValues[pValueIndices[i2]];
            float smallPValue = nominalPValues[pValueIndices[i2 - 1]];
            if (bigPValue != smallPValue) continue;
            ranks[pValueIndices[i2 - 1]] = ranks[pValueIndices[i2]];
        }
        for (i2 = 0; i2 < size; ++i2) {
            int rank = ranks[i2];
            float p = nominalPValues[i2];
            fdr[i2] = p * (float)size / (float)rank;
        }
        int[] pIndices = Sorting.index(nominalPValues, false);
        for (i = 0; i < pIndices.length - 1; ++i) {
            int highIndex = pIndices[i];
            int lowIndex = pIndices[i + 1];
            fdr[lowIndex] = Math.min(fdr[lowIndex], fdr[highIndex]);
        }
        for (i = 0; i < size; ++i) {
            fdr[i] = Math.min(fdr[i], 1.0f);
        }
        return fdr;
    }
}

